/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.atom.impl;

import com.tydic.umc.atom.UmcIntegralAddAtomService;
import com.tydic.umc.atom.UmcIntegralLogAddAtomService;
import com.tydic.umc.atom.bo.UmcIntegralAddAtomReqBO;
import com.tydic.umc.atom.bo.UmcIntegralAddAtomRspBO;
import com.tydic.umc.atom.bo.UmcIntegralLogAddAtomReqBO;
import com.tydic.umc.atom.bo.UmcIntegralLogAddAtomRspBO;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.IntegralMapper;
import com.tydic.umc.po.IntegralPO;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcIntegralAddAtomService")
public class UmcIntegralAddAtomServiceImpl
implements UmcIntegralAddAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcIntegralAddAtomServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Autowired
    private IntegralMapper integralMapper;
    @Autowired
    private UmcIntegralLogAddAtomService umcIntegralLogAddAtomService;

    @Override
    public UmcIntegralAddAtomRspBO insertIntegral(UmcIntegralAddAtomReqBO umcIntegralAddAtomReqBO) {
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u6267\u884c\u4f1a\u5458\u79ef\u5206\u65b0\u589e\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u4e3a\uff1a" + umcIntegralAddAtomReqBO.toString());
        }
        UmcIntegralAddAtomRspBO rspBO = new UmcIntegralAddAtomRspBO();
        rspBO.setRespCode("0000");
        UmcIntegralAddAtomReqBO integralAddAtomReqBO = this.initializationParameters(umcIntegralAddAtomReqBO);
        IntegralPO integralPO = new IntegralPO();
        integralPO.setMemId(integralAddAtomReqBO.getMemId());
        integralPO.setIntegral(integralAddAtomReqBO.getIntegral());
        integralPO.setState(integralAddAtomReqBO.getState());
        integralPO.setCreateTime(integralAddAtomReqBO.getCreateTime());
        integralPO.setExpTime(integralAddAtomReqBO.getExpTime());
        int insertResult = this.integralMapper.insert(integralPO);
        if (insertResult < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u65b0\u589e\u4f1a\u5458\u79ef\u5206\u5931\u8d25");
            }
            rspBO.setRespCode("2007");
            rspBO.setRespCode("\u65b0\u589e\u4f1a\u5458\u79ef\u5206\u5931\u8d25");
            return rspBO;
        }
        UmcIntegralLogAddAtomReqBO umcIntegralLogAddAtomReqBO = new UmcIntegralLogAddAtomReqBO();
        BeanUtils.copyProperties((Object)integralAddAtomReqBO, (Object)umcIntegralLogAddAtomReqBO);
        umcIntegralLogAddAtomReqBO.setOperTime(new Date());
        umcIntegralLogAddAtomReqBO.setIntId(integralPO.getIntId());
        umcIntegralLogAddAtomReqBO.setAction(UmcEnumConstant.IntegralOperCode.ADD_INTEGRAL.getCode());
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u4f1a\u5458\u4e2d\u5fc3\u589e\u52a0\u4f1a\u5458\u79ef\u5206\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e3a\uff1a" + umcIntegralLogAddAtomReqBO.toString());
        }
        UmcIntegralLogAddAtomRspBO umcIntegralLogAddAtomRspBO = this.umcIntegralLogAddAtomService.insertIntegralLog(umcIntegralLogAddAtomReqBO);
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u4f1a\u5458\u4e2d\u5fc3\u589e\u52a0\u4f1a\u5458\u79ef\u5206\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u539f\u5b50\u670d\u52a1\u51fa\u53c2\u4e3a\uff1a" + umcIntegralLogAddAtomRspBO.toString());
        }
        if (!"0000".equals(umcIntegralLogAddAtomRspBO.getRespCode())) {
            rspBO.setRespCode(umcIntegralLogAddAtomRspBO.getRespCode());
            rspBO.setRespDesc(umcIntegralLogAddAtomRspBO.getRespDesc());
            return rspBO;
        }
        rspBO.setIntId(integralPO.getIntId());
        rspBO.setCreateTime(integralAddAtomReqBO.getCreateTime());
        rspBO.setExpTime(integralAddAtomReqBO.getExpTime());
        rspBO.setRespDesc("\u65b0\u589e\u4f1a\u5458\u79ef\u5206\u6210\u529f");
        return rspBO;
    }

    private UmcIntegralAddAtomReqBO initializationParameters(UmcIntegralAddAtomReqBO reqBO) {
        if (reqBO.getState() == null) {
            reqBO.setState(UmcEnumConstant.IntegralState.EFFECTIVE.getCode());
        }
        Date sysCurrentTime = new Date();
        if (reqBO.getCreateTime() == null) {
            reqBO.setCreateTime(sysCurrentTime);
        }
        if (reqBO.getExpTime() == null) {
            if (reqBO.getCreateTime() != null) {
                reqBO.setExpTime(this.buildExpTime(reqBO.getCreateTime()));
            } else {
                reqBO.setExpTime(this.buildExpTime(sysCurrentTime));
            }
        }
        return reqBO;
    }

    private Date buildExpTime(Date createTime) {
        Integer defaultAddExpYear = 1;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(createTime);
        calendar.add(1, defaultAddExpYear);
        return calendar.getTime();
    }
}

