/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.atom.impl;

import com.tydic.umc.atom.UmcIntegralDeductAtomService;
import com.tydic.umc.atom.bo.UmcIntegralDeductAtomReqBO;
import com.tydic.umc.atom.bo.UmcIntegralDeductAtomRspBO;
import com.tydic.umc.atom.impl.UmcIntegralAddAtomServiceImpl;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.IntegralChgLogMapper;
import com.tydic.umc.dao.IntegralMapper;
import com.tydic.umc.po.IntegralChgLogPO;
import com.tydic.umc.po.IntegralPO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcIntegralDeductAtomService")
public class UmcIntegralDeductAtomServiceImpl
implements UmcIntegralDeductAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcIntegralAddAtomServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private IntegralMapper integralMapper;
    private IntegralChgLogMapper integralChgLogMapper;

    @Autowired
    public UmcIntegralDeductAtomServiceImpl(IntegralMapper integralMapper, IntegralChgLogMapper integralChgLogMapper) {
        this.integralMapper = integralMapper;
        this.integralChgLogMapper = integralChgLogMapper;
    }

    @Override
    public UmcIntegralDeductAtomRspBO deductIntegral(UmcIntegralDeductAtomReqBO atomReqBO) {
        UmcIntegralDeductAtomRspBO rsp = new UmcIntegralDeductAtomRspBO();
        List<IntegralPO> integralPOList = this.qryIntegralList(atomReqBO.getMemId());
        if (null == integralPOList || integralPOList.size() <= 0) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u8be5\u4f1a\u5458Id\u3010" + atomReqBO.getMemId() + "\u3011\u67e5\u8be2\u7684\u6709\u6548\u79ef\u5206\u4e3a\u7a7a\uff01");
            }
            rsp.setRespCode("1005");
            rsp.setRespDesc("\u8be5\u4f1a\u5458Id\u3010" + atomReqBO.getMemId() + "\u3011\u67e5\u8be2\u7684\u6709\u6548\u79ef\u5206\u4e3a\u7a7a\uff01");
            return rsp;
        }
        Long deductIntegral = atomReqBO.getDeductIntegral();
        Long totalIntegral = 0L;
        for (IntegralPO po : integralPOList) {
            totalIntegral = totalIntegral + po.getIntegral();
        }
        if (totalIntegral < deductIntegral) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u8be5\u4f1a\u5458Id\u3010" + atomReqBO.getMemId() + "\u3011\u7684\u603b\u6709\u6548\u79ef\u5206\uff1a" + totalIntegral + "\u4e0d\u8db3\u4ee5\u62b5\u6263\uff01");
            }
            rsp.setRespCode("1005");
            rsp.setRespDesc("\u8be5\u4f1a\u5458Id\u3010" + atomReqBO.getMemId() + "\u3011\u7684\u603b\u6709\u6548\u79ef\u5206\uff1a" + totalIntegral + "\u4e0d\u8db3\u4ee5\u62b5\u6263\uff01");
            return rsp;
        }
        for (IntegralPO po : integralPOList) {
            if (deductIntegral == 0L) break;
            if (po.getIntegral() == 0L) continue;
            Long remainIntegral = 0L;
            Long alreadyDeducIntegral = 0L;
            if (po.getIntegral() <= deductIntegral) {
                alreadyDeducIntegral = po.getIntegral();
                deductIntegral = deductIntegral - po.getIntegral();
            } else if (po.getIntegral() > deductIntegral && deductIntegral > 0L) {
                remainIntegral = po.getIntegral() - deductIntegral;
                alreadyDeducIntegral = deductIntegral;
                deductIntegral = 0L;
            }
            int isDeduct = this.updateIntegral(atomReqBO.getMemId(), po.getIntId(), remainIntegral);
            if (isDeduct < 1) {
                if (IS_DEBUG_ENABLED) {
                    LOGGER.debug("\u66f4\u65b0\u5355\u6761\u79ef\u5206\u8fdb\u884c\u62b5\u6263\u540e\u4efb\u5269\u4f59\u79ef\u5206\u5230\u79ef\u5206\u8868\u5931\u8d25");
                }
                throw new UmcBusinessException("1005", "\u66f4\u65b0\u5355\u6761\u79ef\u5206\u8fdb\u884c\u62b5\u6263\u540e\u4efb\u5269\u4f59\u79ef\u5206\u5230\u79ef\u5206\u8868\u5931\u8d25\uff01");
            }
            int isInsert = this.insertIntegralChgLog(atomReqBO, po.getIntId(), alreadyDeducIntegral);
            if (isInsert >= 1) continue;
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u63d2\u5165\u79ef\u5206\u62b5\u6263\u8bb0\u5f55\u5230\u65e5\u5fd7\u8868\u5931\u8d25\uff01");
            }
            throw new UmcBusinessException("1005", "\u63d2\u5165\u79ef\u5206\u62b5\u6263\u8bb0\u5f55\u5230\u65e5\u5fd7\u8868\u5931\u8d25\uff01");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4f1a\u5458\u4e2d\u5fc3\u79ef\u5206\u62b5\u6263\u539f\u5b50\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }

    private List<IntegralPO> qryIntegralList(Long memId) {
        IntegralPO integralPO = new IntegralPO();
        integralPO.setMemId(memId);
        integralPO.setState(UmcCommConstant.IntegralState.EFFECTIVE);
        integralPO.setExpTime(new Date());
        integralPO.setOrderBy("EXP_TIME");
        return this.integralMapper.getModelByMemIdAndStateAndExpTime(integralPO);
    }

    private int insertIntegralChgLog(UmcIntegralDeductAtomReqBO atomReqBO, Long intId, Long integral) {
        IntegralChgLogPO integralChgLogPO = new IntegralChgLogPO();
        integralChgLogPO.setMemId(atomReqBO.getMemId());
        integralChgLogPO.setIntId(intId);
        integralChgLogPO.setIntegral(0L - integral);
        integralChgLogPO.setAction(UmcEnumConstant.IntegralOperCode.EXPENSE_INTEGRAL.getCode());
        integralChgLogPO.setOperSystem(atomReqBO.getOperSystem());
        integralChgLogPO.setOperSn(atomReqBO.getOperSn());
        integralChgLogPO.setOperTime(new Date());
        if (!StringUtils.isEmpty((CharSequence)atomReqBO.getOperResult())) {
            integralChgLogPO.setOperResult(atomReqBO.getOperResult());
        } else {
            integralChgLogPO.setOperResult("\u79ef\u5206\u62b5\u6263");
        }
        if (!StringUtils.isEmpty((CharSequence)atomReqBO.getOperDesc())) {
            integralChgLogPO.setOperDesc(atomReqBO.getOperDesc());
        } else {
            integralChgLogPO.setOperDesc("\u79ef\u5206\u62b5\u6263");
        }
        return this.integralChgLogMapper.insert(integralChgLogPO);
    }

    private int updateIntegral(Long memId, Long intId, Long integral) {
        IntegralPO integralPO = new IntegralPO();
        integralPO.setIntId(intId);
        integralPO.setMemId(memId);
        integralPO.setIntegral(integral);
        return this.integralMapper.updateByCondition(integralPO);
    }
}

