/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.atom.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.umc.atom.UmcJudContAndRptSignAtomService;
import com.tydic.umc.atom.bo.UmcJudContAndRptSignAtomReqBO;
import com.tydic.umc.atom.bo.UmcJudContAndRptSignAtomRspBO;
import com.tydic.umc.dao.MemSignMapper;
import com.tydic.umc.po.MemSignPO;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcJudContAndRptSignAtomService")
public class UmcJudContAndRptSignAtomServiceImpl
implements UmcJudContAndRptSignAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcJudContAndRptSignAtomServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Autowired
    private MemSignMapper memSignMapper;

    @Override
    public UmcJudContAndRptSignAtomRspBO judgeSignContinue(UmcJudContAndRptSignAtomReqBO umcJudContAndRptSignAtomReqBO) {
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u6267\u884c\u5224\u65ad\u662f\u5426\u662f\u8fde\u7eed\u7b7e\u5230\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e3a\uff1a" + umcJudContAndRptSignAtomReqBO.toString());
        }
        UmcJudContAndRptSignAtomRspBO rspBO = new UmcJudContAndRptSignAtomRspBO();
        int continueSignNums = 1;
        Date newSignTime = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String newSignDateStr = simpleDateFormat.format(newSignTime);
        Date newSignDate = DateUtils.strToDate((String)newSignDateStr);
        MemSignPO memSignPO = this.qryMemSignPO(umcJudContAndRptSignAtomReqBO.getMemId());
        if (memSignPO != null) {
            Date oldSignDate = memSignPO.getSignDate();
            Map<String, Boolean> judgeResult = this.judgeIsContinueAndRepeatSign(oldSignDate, newSignDate);
            boolean isContinueSign = judgeResult.get("isContinueSign");
            boolean isRepeatSign = judgeResult.get("isRepeatSign");
            if (isRepeatSign) {
                rspBO.setRespCode("1003");
                rspBO.setRespDesc("\u8bf7\u4e0d\u8981\u91cd\u590d\u7b7e\u5230");
                return rspBO;
            }
            if (isContinueSign) {
                continueSignNums += memSignPO.getContinuityNum().intValue();
            }
        }
        rspBO.setContinuityNum(continueSignNums);
        rspBO.setSignDate(newSignDate);
        rspBO.setSignTime(newSignTime);
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private MemSignPO qryMemSignPO(Long memId) {
        MemSignPO memSignModel = new MemSignPO();
        memSignModel.setMemId(memId);
        memSignModel.setOrderBy("SIGN_DATE DESC");
        List<MemSignPO> memSignPOS = this.memSignMapper.getListByCondition(memSignModel);
        if (memSignPOS == null || memSignPOS.isEmpty()) {
            return null;
        }
        return memSignPOS.get(0);
    }

    private Map<String, Boolean> judgeIsContinueAndRepeatSign(Date oldSignDate, Date newSignDate) {
        HashMap<String, Boolean> judgeResult = new HashMap<String, Boolean>(2);
        boolean isContinueSign = false;
        boolean isRepeatSign = false;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(oldSignDate);
        calendar.add(6, 1);
        if (calendar.getTime().compareTo(newSignDate) == 0) {
            isContinueSign = true;
        } else if (calendar.getTime().compareTo(newSignDate) > 0) {
            isRepeatSign = true;
        }
        judgeResult.put("isContinueSign", isContinueSign);
        judgeResult.put("isRepeatSign", isRepeatSign);
        return judgeResult;
    }
}

