/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.atom.impl;

import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.umc.atom.UmcMemChangePozitionAtomService;
import com.tydic.umc.comb.bo.UmcMemChangePozitionAtomReqBO;
import com.tydic.umc.comb.bo.UmcMemChangePozitionAtomRspBO;
import com.tydic.umc.common.UmcEnterpriseOrgBO;
import com.tydic.umc.dao.ChangePozitionHisMapper;
import com.tydic.umc.dao.EnterpriseOrgMapper;
import com.tydic.umc.dao.MemUserMapper;
import com.tydic.umc.dao.MemberMapper;
import com.tydic.umc.po.ChangePozitionHisPO;
import com.tydic.umc.po.MemUserPO;
import com.tydic.umc.po.MemberPO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcMemChangePozitionAtomService")
public class UmcMemChangePozitionAtomServiceImpl
implements UmcMemChangePozitionAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcMemChangePozitionAtomServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLE = LOGGER.isDebugEnabled();
    @Autowired
    private MemberMapper memberMapper;
    @Autowired
    private ChangePozitionHisMapper changePozitionHisMapper;
    @Autowired
    private MemUserMapper memUserMapper;
    @Autowired
    private EnterpriseOrgMapper enterpriseOrgMapper;
    @Resource(name="memIdSequencePager")
    private OrderSequence memIdSequencePager;

    @Override
    public UmcMemChangePozitionAtomRspBO submitMemChangePozition(UmcMemChangePozitionAtomReqBO busiReqBO) {
        UmcMemChangePozitionAtomRspBO rsp = new UmcMemChangePozitionAtomRspBO();
        Long memberId = this.getMemId();
        MemberPO memberPO = new MemberPO();
        memberPO.setMemId(busiReqBO.getMemId());
        MemberPO member = this.memberMapper.getModelByCondition(memberPO);
        if (null == member) {
            throw new UmcBusinessException("8888", "\u4e0d\u5b58\u5728\u8be5\u4f1a\u5458\u4fe1\u606f\uff01");
        }
        MemberPO updateMember = new MemberPO();
        updateMember.setMemId(busiReqBO.getMemId());
        updateMember.setRegAccount(busiReqBO.getNewRegAccount());
        updateMember.setMemClassify("02");
        updateMember.setMainMemId(memberId);
        int isUpdate = this.memberMapper.updateByCondition(updateMember);
        if (isUpdate < 1) {
            throw new UmcBusinessException("8888", "\u4fee\u6539\u539f\u4f1a\u5458\u8d26\u6237\u540d\u5931\u8d25\uff01");
        }
        MemberPO newMember = new MemberPO();
        BeanUtils.copyProperties((Object)member, (Object)newMember);
        newMember.setOrgId(busiReqBO.getTargetOrgId());
        Long orgId = this.queryParentNotDepartment(busiReqBO.getTargetOrgId());
        if (null != orgId) {
            newMember.setCompanyId(orgId);
        } else {
            newMember.setCompanyId(busiReqBO.getTargetOrgId());
        }
        newMember.setMemId(memberId);
        newMember.setMainMemId(memberId);
        int isInsert = this.memberMapper.insert(newMember);
        if (isInsert < 1) {
            throw new UmcBusinessException("8888", "\u65b0\u589e\u4f1a\u5458\u4fe1\u606f\u5931\u8d25\uff01");
        }
        MemUserPO memUserPO = new MemUserPO();
        memUserPO.setId(Sequence.getInstance().nextId());
        memUserPO.setMemId(memberId);
        memUserPO.setUsreId(busiReqBO.getUserId());
        memUserPO.setMemClassify("02");
        memUserPO.setStatus("00");
        try {
            int isInsert2 = this.memUserMapper.insert(memUserPO);
            if (isInsert2 < 1) {
                throw new UmcBusinessException("8888", "\u63d2\u5165\u7528\u6237\u4f1a\u5458\u8868\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            throw new UmcBusinessException("8888", "\u63d2\u5165\u7528\u6237\u4f1a\u5458\u8868\u5f02\u5e38\uff01" + e);
        }
        ChangePozitionHisPO changePozitionHisPO = new ChangePozitionHisPO();
        changePozitionHisPO.setHisId(Sequence.getInstance().nextId());
        changePozitionHisPO.setMemId(memberId);
        changePozitionHisPO.setOldOrgId(member.getOrgId());
        changePozitionHisPO.setCurrentOrgId(busiReqBO.getTargetOrgId());
        changePozitionHisPO.setRemark(busiReqBO.getRemark());
        changePozitionHisPO.setChangeTime(new Date());
        int isInsert3 = this.changePozitionHisMapper.insert(changePozitionHisPO);
        if (isInsert3 < 1) {
            throw new UmcBusinessException("8888", "\u63d2\u5165\u8c03\u5c97\u65e5\u5fd7\u8868\u5931\u8d25\uff01");
        }
        rsp.setNewMemId(memberId);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4f1a\u5458\u8c03\u5c97\u63d0\u4ea4\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }

    private Long getMemId() {
        try {
            return this.memIdSequencePager.nextId();
        }
        catch (Exception e) {
            if (IS_DEBUG_ENABLE) {
                LOGGER.error("\u83b7\u53d6\u4f1a\u5458ID\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
            throw new UmcBusinessException("5005", "\u83b7\u53d6\u4f1a\u5458ID\u5f02\u5e38", e);
        }
    }

    public Long queryParentNotDepartment(Long orgId) {
        UmcEnterpriseOrgBO umcEnterpriseOrgBO;
        while ((umcEnterpriseOrgBO = this.enterpriseOrgMapper.getModelById(orgId)) != null) {
            if (!"03".equals(umcEnterpriseOrgBO.getOrgType())) {
                return umcEnterpriseOrgBO.getOrgId();
            }
            orgId = umcEnterpriseOrgBO.getParentId();
        }
        return null;
    }
}

