/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.umc.atom.UmcMemInfoUpdateAtomService;
import com.tydic.umc.atom.bo.UmcMemInfoUpdateAtomReqBO;
import com.tydic.umc.atom.bo.UmcMemInfoUpdateAtomRspBO;
import com.tydic.umc.dao.MemChgLogMapper;
import com.tydic.umc.dao.MemExtMapMapper;
import com.tydic.umc.dao.MemberMapper;
import com.tydic.umc.po.MemChgLogPO;
import com.tydic.umc.po.MemExtMapPO;
import com.tydic.umc.po.MemberPO;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcMemInfoUpdateAtomService")
public class UmcMemInfoUpdateAtomServiceImpl
implements UmcMemInfoUpdateAtomService {
    private static final Logger LOG = LoggerFactory.getLogger(UmcMemInfoUpdateAtomServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOG.isDebugEnabled();
    @Autowired
    private MemberMapper memberMapper;
    @Autowired
    private MemChgLogMapper memChgLogMapper;
    @Autowired
    private MemExtMapMapper memExtMapMapper;

    @Override
    public UmcMemInfoUpdateAtomRspBO updateMemInfoAtom(UmcMemInfoUpdateAtomReqBO atomReqBO) {
        UmcMemInfoUpdateAtomRspBO rsp = new UmcMemInfoUpdateAtomRspBO();
        MemberPO memberPO2 = new MemberPO();
        memberPO2.setMemId(atomReqBO.getMemId());
        MemberPO member2 = this.memberMapper.getModelByCondition(memberPO2);
        if (null == member2) {
            if (IS_DEBUG_ENABLED) {
                LOG.debug("\u67e5\u8be2\u4f1a\u5458\u8868\u5931\u8d25\uff01\u8fd4\u56de\u7f16\u7801\uff1a1001");
            }
            rsp.setRespCode("1001");
            rsp.setRespDesc("\u67e5\u8be2\u4f1a\u5458\u8868\u5931\u8d25\uff01");
            return rsp;
        }
        MemberPO memberPO = new MemberPO();
        BeanUtils.copyProperties((Object)member2, (Object)memberPO);
        memberPO = this.setUpdateParam(atomReqBO, memberPO);
        int isUpdate = this.memberMapper.updateByCondition(memberPO);
        if (isUpdate < 1) {
            if (IS_DEBUG_ENABLED) {
                LOG.debug("\u66f4\u65b0\u4f1a\u5458\u8868\u5931\u8d25\uff01\u8fd4\u56de\u7f16\u7801\uff1a1001");
            }
            rsp.setRespCode("1001");
            rsp.setRespDesc("\u66f4\u65b0\u4f1a\u5458\u8868\u5931\u8d25\uff01");
            return rsp;
        }
        this.updateExt(atomReqBO.getMemId(), atomReqBO.getExtendMap());
        MemChgLogPO memChgLogPO = new MemChgLogPO();
        BeanUtils.copyProperties((Object)member2, (Object)memChgLogPO);
        memChgLogPO.setOperType(atomReqBO.getOperType());
        memChgLogPO.setOperLoginId(String.valueOf(atomReqBO.getMemId()));
        memChgLogPO.setOperResult(atomReqBO.getOperResult());
        memChgLogPO.setOperDesc(atomReqBO.getOperDesc());
        memChgLogPO.setOperTime(new Date());
        memChgLogPO.setId(Sequence.getInstance().nextId());
        int isInsert = this.memChgLogMapper.insert(memChgLogPO);
        if (isInsert < 1) {
            if (IS_DEBUG_ENABLED) {
                LOG.debug("\u63d2\u5165\u4f1a\u5458\u4fe1\u606f\u53d8\u52a8\u65e5\u5fd7\u8868\u5931\u8d25\uff01\u8fd4\u56de\u7f16\u7801\uff1a1001");
            }
            rsp.setRespCode("1001");
            rsp.setRespDesc("\u63d2\u5165\u4f1a\u5458\u4fe1\u606f\u53d8\u52a8\u65e5\u5fd7\u8868\u5931\u8d25\uff01");
            return rsp;
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4f1a\u5458\u4e2d\u5fc3\u57fa\u7840\u4fe1\u606f\u7ef4\u62a4\u539f\u5b50\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }

    private MemberPO setUpdateParam(UmcMemInfoUpdateAtomReqBO atomReqBO, MemberPO memberPO) {
        MemberPO memberPO3 = memberPO;
        if (!StringUtils.isBlank((CharSequence)atomReqBO.getRegAccount())) {
            memberPO3.setRegAccount(atomReqBO.getRegAccount());
        }
        if (!StringUtils.isBlank((CharSequence)atomReqBO.getRegMobile())) {
            memberPO3.setRegMobile(atomReqBO.getRegMobile());
        }
        if (!StringUtils.isBlank((CharSequence)atomReqBO.getRegEmail())) {
            memberPO3.setRegEmail(atomReqBO.getRegEmail());
        }
        if (!StringUtils.isBlank((CharSequence)atomReqBO.getHeadUrl())) {
            memberPO3.setHeadUrl(atomReqBO.getHeadUrl());
        }
        if (!StringUtils.isBlank((CharSequence)atomReqBO.getMemName1())) {
            memberPO3.setMemName1(atomReqBO.getMemName1());
        }
        if (!StringUtils.isBlank((CharSequence)atomReqBO.getMemNickName())) {
            memberPO3.setMemNickName(atomReqBO.getMemNickName());
            memberPO3.setMemName2(atomReqBO.getMemNickName());
        }
        if (!StringUtils.isBlank((CharSequence)atomReqBO.getMemName2())) {
            memberPO3.setMemNickName(atomReqBO.getMemName2());
            memberPO3.setMemName2(atomReqBO.getMemName2());
        }
        if (!StringUtils.isBlank((CharSequence)atomReqBO.getMemName2()) && !StringUtils.isBlank((CharSequence)atomReqBO.getMemNickName())) {
            memberPO3.setMemNickName(atomReqBO.getMemNickName());
            memberPO3.setMemName2(atomReqBO.getMemName2());
        }
        if (null != atomReqBO.getSex()) {
            memberPO3.setSex(atomReqBO.getSex());
        }
        if (null != atomReqBO.getCertType()) {
            memberPO3.setCertType(atomReqBO.getCertType());
        }
        if (!StringUtils.isBlank((CharSequence)atomReqBO.getCertNo())) {
            memberPO3.setCertNo(atomReqBO.getCertNo());
        }
        if (null != atomReqBO.getState()) {
            memberPO3.setState(atomReqBO.getState());
        }
        if (null != atomReqBO.getMemType()) {
            memberPO3.setMemType(atomReqBO.getMemType());
        }
        if (StringUtils.isNotBlank((CharSequence)atomReqBO.getBirthday())) {
            memberPO3.setBirthday(atomReqBO.getBirthday());
        }
        if (null != atomReqBO.getLevelEffTime()) {
            memberPO3.setLevelEffTime(atomReqBO.getLevelEffTime());
        }
        if (null != atomReqBO.getLevelExpTime()) {
            memberPO3.setLevelExpTime(atomReqBO.getLevelExpTime());
        }
        if (null != atomReqBO.getIsPlus()) {
            memberPO3.setIsPlus(atomReqBO.getIsPlus());
        }
        if (null != atomReqBO.getPlusEffTime()) {
            memberPO3.setPlusEffTime(atomReqBO.getPlusEffTime());
        }
        if (null != atomReqBO.getPlusExpTime()) {
            memberPO3.setPlusExpTime(atomReqBO.getPlusExpTime());
        }
        if (null != atomReqBO.getIsBlackList()) {
            memberPO3.setIsBlackList(atomReqBO.getIsBlackList());
        }
        if (null != atomReqBO.getWorkNo()) {
            memberPO3.setWorkNo(atomReqBO.getWorkNo());
        }
        if (null != atomReqBO.getOfficePhone()) {
            memberPO3.setOfficePhone(atomReqBO.getOfficePhone());
        }
        if (null != atomReqBO.getStopStatus()) {
            memberPO3.setStopStatus(atomReqBO.getStopStatus());
        }
        if (null != atomReqBO.getMemClassify()) {
            memberPO3.setMemClassify(atomReqBO.getMemClassify());
        }
        if (null != atomReqBO.getOccupation()) {
            memberPO3.setOccupation(atomReqBO.getOccupation());
        }
        if (!StringUtils.isBlank((CharSequence)atomReqBO.getHeight())) {
            Double height = Double.valueOf(atomReqBO.getHeight());
            int heightInt = (int)(height * 10.0);
            memberPO3.setHeight(heightInt);
        }
        if (!StringUtils.isBlank((CharSequence)atomReqBO.getWeight())) {
            Double weight = Double.valueOf(atomReqBO.getWeight());
            int weightInt = (int)(weight * 10.0);
            memberPO3.setWeight(weightInt);
        }
        if (null != atomReqBO.getProvinceId()) {
            memberPO3.setProvinceId(atomReqBO.getProvinceId());
        }
        if (null != atomReqBO.getProvinceName()) {
            memberPO3.setProvinceName(atomReqBO.getProvinceName());
        }
        if (null != atomReqBO.getCityId()) {
            memberPO3.setCityId(atomReqBO.getCityId());
        }
        if (null != atomReqBO.getCityName()) {
            memberPO3.setCityName(atomReqBO.getCityName());
        }
        if (null != atomReqBO.getCountyId()) {
            memberPO3.setCountyId(atomReqBO.getCountyId());
        }
        if (null != atomReqBO.getCountyName()) {
            memberPO3.setCountyName(atomReqBO.getCountyName());
        }
        if (null != atomReqBO.getTownId()) {
            memberPO3.setTownId(atomReqBO.getTownId());
        }
        if (null != atomReqBO.getTownName()) {
            memberPO3.setTownName(atomReqBO.getTownName());
        }
        if (null != atomReqBO.getAddress()) {
            memberPO3.setAddress(atomReqBO.getAddress());
        }
        if (null != atomReqBO.getExtendMap()) {
            memberPO3.setExtendMap(atomReqBO.getExtendMap());
        }
        if (null != atomReqBO.getMemLevel()) {
            memberPO3.setMemLevel(atomReqBO.getMemLevel());
        }
        if (null != atomReqBO.getMemNewOld()) {
            memberPO3.setMemNewOld(atomReqBO.getMemNewOld());
        }
        return memberPO3;
    }

    private void updateExt(Long memId, Map<String, String> extendMap) {
        if (extendMap != null) {
            extendMap.forEach((k, v) -> {
                MemExtMapPO po = this.getMemExtMap(memId, (String)k);
                if (null == po) {
                    this.insertParam(memId, (String)k, (String)v);
                } else {
                    this.updateParam(po.getId(), (String)v);
                }
            });
        }
    }

    private MemExtMapPO getMemExtMap(Long memId, String paramName) {
        MemExtMapPO memExtMapPO = new MemExtMapPO();
        memExtMapPO.setMemId(memId);
        memExtMapPO.setFieldCode(paramName);
        return this.memExtMapMapper.getModel(memExtMapPO);
    }

    private void insertParam(Long memId, String paramName, String paramValue) {
        MemExtMapPO memExtMapPO = new MemExtMapPO();
        memExtMapPO.setId(Sequence.getInstance().nextId());
        memExtMapPO.setMemId(memId);
        memExtMapPO.setFieldCode(paramName);
        memExtMapPO.setFieldValue(paramValue);
        this.memExtMapMapper.insert(memExtMapPO);
    }

    private void updateParam(Long id, String paramValue) {
        MemExtMapPO memExtMapPO = new MemExtMapPO();
        memExtMapPO.setFieldValue(paramValue);
        memExtMapPO.setId(id);
        this.memExtMapMapper.updateBy(memExtMapPO);
    }
}

