/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.umc.atom.UmcMemLoginAtomService;
import com.tydic.umc.atom.bo.UmcMemLoginAtomReqBO;
import com.tydic.umc.atom.bo.UmcMemLoginAtomRspBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.LoginLogMapper;
import com.tydic.umc.dao.MemberMapper;
import com.tydic.umc.po.LoginLogPO;
import com.tydic.umc.po.MemberPO;
import java.util.Date;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcMemLoginAtomService")
public class UmcMemLoginAtomServiceImpl
implements UmcMemLoginAtomService {
    @Autowired
    private MemberMapper memberMapper;
    @Autowired
    private LoginLogMapper loginLogMapper;

    @Override
    public UmcMemLoginAtomRspBO dealMemLogin(UmcMemLoginAtomReqBO reqBO) {
        String jsessionId = this.createJsessionId(reqBO);
        this.updateMenberOnline(reqBO, jsessionId);
        this.createLoginLog(reqBO, jsessionId);
        UmcMemLoginAtomRspBO rspBO = new UmcMemLoginAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setJsessionId(jsessionId);
        return rspBO;
    }

    private String createJsessionId(UmcMemLoginAtomReqBO reqBO) {
        return UUID.randomUUID().toString().replace("-", "").toUpperCase();
    }

    private void createLoginLog(UmcMemLoginAtomReqBO reqBO, String jsessionId) {
        LoginLogPO reqPO = new LoginLogPO();
        reqPO.setMemId(reqBO.getMemId());
        reqPO.setLoginIp(reqBO.getLoginIp());
        reqPO.setLoginType(reqBO.getLoginType());
        reqPO.setJsessionid(jsessionId);
        reqPO.setId(Sequence.getInstance().nextId());
        reqPO.setLoginInTime(new Date());
        reqPO.setMaxRepeatLoginNum(UmcCommConstant.UmcDefaultValue.MAX_REPEAT_LOGIN_NUM);
        this.loginLogMapper.insert(reqPO);
    }

    private void updateMenberOnline(UmcMemLoginAtomReqBO reqBO, String jsessionId) {
        MemberPO reqPO = new MemberPO();
        reqPO.setMemId(reqBO.getMemId());
        reqPO.setIsOnline(UmcEnumConstant.IsOnline.YES.getCode());
        reqPO.setLastLoginTime(new Date());
        reqPO.setRegEmail(jsessionId);
        this.memberMapper.updateByCondition(reqPO);
    }
}

