/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.atom.impl;

import com.tydic.umc.atom.UmcMemLogoutAtomService;
import com.tydic.umc.atom.bo.UmcMemLogoutAtomReqBO;
import com.tydic.umc.atom.bo.UmcMemLogoutAtomRspBO;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.LoginLogMapper;
import com.tydic.umc.dao.MemberMapper;
import com.tydic.umc.po.LoginLogPO;
import com.tydic.umc.po.MemberPO;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="umcMemLogoutAtomService")
public class UmcMemLogoutAtomServiceImpl
implements UmcMemLogoutAtomService {
    private MemberMapper memberMapper;
    private LoginLogMapper loginLogMapper;

    @Autowired
    public UmcMemLogoutAtomServiceImpl(MemberMapper memberMapper, LoginLogMapper loginLogMapper) {
        this.memberMapper = memberMapper;
        this.loginLogMapper = loginLogMapper;
    }

    @Override
    public UmcMemLogoutAtomRspBO dealMemLogout(UmcMemLogoutAtomReqBO reqBO) {
        this.updateLoginLogLogout(reqBO);
        this.updateMemberOffline(reqBO);
        UmcMemLogoutAtomRspBO rspBO = new UmcMemLogoutAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateLoginLogLogout(UmcMemLogoutAtomReqBO reqBO) {
        LoginLogPO reqPO = new LoginLogPO();
        reqPO.setMemId(reqBO.getMemId());
        reqPO.setLoginOutTime(new Date());
        if (StringUtils.isEmpty((Object)reqBO.getJsessionId())) {
            this.loginLogMapper.updateByCondition(reqPO);
            return;
        }
        reqPO.setJsessionid(reqBO.getJsessionId());
        this.loginLogMapper.updateByCondition(reqPO);
    }

    private void updateMemberOffline(UmcMemLogoutAtomReqBO reqBO) {
        LoginLogPO loginLogPO = new LoginLogPO();
        loginLogPO.setMemId(reqBO.getMemId());
        List<LoginLogPO> logList = this.loginLogMapper.getListByCondition(loginLogPO);
        if (logList != null && logList.size() > 0) {
            for (LoginLogPO logPO : logList) {
                if (logPO.getJsessionid().equals(reqBO.getJsessionId()) || logPO.getLoginOutTime() != null) continue;
                return;
            }
        }
        MemberPO reqPO = new MemberPO();
        reqPO.setMemId(reqBO.getMemId());
        reqPO.setIsOnline(UmcEnumConstant.IsOnline.NO.getCode());
        this.memberMapper.updateByCondition(reqPO);
    }
}

