/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.atom.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.umc.atom.UmcMemRegistAtomService;
import com.tydic.umc.atom.bo.FaceInfoAtomBO;
import com.tydic.umc.atom.bo.UmcMemRegistAtomReqBO;
import com.tydic.umc.atom.bo.UmcMemRegistAtomRspBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.MemFaceMapper;
import com.tydic.umc.dao.MemberMapper;
import com.tydic.umc.dao.ThirdBindMapper;
import com.tydic.umc.po.MemFacePO;
import com.tydic.umc.po.MemberPO;
import com.tydic.umc.po.ThirdBindPO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="umcMemRegistAtomService")
public class UmcMemRegistAtomServiceImpl
implements UmcMemRegistAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcMemRegistAtomServiceImpl.class);
    private static final boolean IS_DEBUG = LOGGER.isDebugEnabled();
    @Autowired
    private MemberMapper memberMapper;
    @Autowired
    private MemFaceMapper memFaceMapper;
    @Resource(name="memIdSequencePager")
    private OrderSequence memIdSequencePager;
    @Resource(name="memNickNameIdSequencePager")
    private OrderSequence memNickNameIdSequencePager;
    @Autowired
    private ThirdBindMapper thirdBindMapper;

    @Override
    public UmcMemRegistAtomRspBO dealMemRegistAtom(UmcMemRegistAtomReqBO reqBO) {
        if (IS_DEBUG) {
            LOGGER.debug("\u6ce8\u518c\u539f\u5b50\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)reqBO);
        }
        UmcMemRegistAtomRspBO rspBO = new UmcMemRegistAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.busiCheck(reqBO, rspBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            return rspBO;
        }
        Long memId = Sequence.getInstance().nextId();
        MemberPO reqPO = this.buildMember(reqBO, memId);
        this.memberMapper.insert(reqPO);
        if (this.hasThirdAuthInfo(reqBO)) {
            ThirdBindPO thirdBindPO = new ThirdBindPO();
            thirdBindPO.setId(Sequence.getInstance().nextId());
            thirdBindPO.setMemId(memId);
            thirdBindPO.setAuthType(reqBO.getThirdAuthType());
            thirdBindPO.setAuthId(reqBO.getThirdAuthId());
            thirdBindPO.setState(UmcEnumConstant.State.EFFECTIVE.getCode());
            thirdBindPO.setCreateTime(new Date());
            thirdBindPO.setExpTime(reqBO.getAuthExpTime());
            thirdBindPO.setAccessToken(reqBO.getAccessToken());
            thirdBindPO.setRefreshToken(reqBO.getRefreshToken());
            thirdBindPO.setUnionAuthId(reqBO.getUnionAuthId());
            this.thirdBindMapper.insert(thirdBindPO);
        }
        if (this.hasFaceInfo(reqBO)) {
            for (FaceInfoAtomBO faceInfoBO : reqBO.getFaceInfoList()) {
                MemFacePO memFaceReqPO = this.buildFace(memId, faceInfoBO);
                this.memFaceMapper.insert(memFaceReqPO);
            }
        }
        rspBO.setMemId(memId);
        return rspBO;
    }

    private void busiCheck(UmcMemRegistAtomReqBO reqBO, UmcMemRegistAtomRspBO rspBO) {
        if (reqBO.getRegAccount() != null) {
            MemberPO reqPO = new MemberPO();
            reqPO.setRegAccount(reqBO.getRegAccount());
            reqPO.setState(UmcEnumConstant.State.EFFECTIVE.getCode());
            reqPO = this.memberMapper.getModelByCondition(reqPO);
            if (reqPO != null) {
                rspBO.setMemId(reqPO.getMemId());
                rspBO.setRespCode("5003");
                rspBO.setRespDesc("\u8d26\u53f7\u5df2\u7ecf\u88ab\u6ce8\u518c");
                return;
            }
        }
        if (this.hasThirdAuthInfo(reqBO)) {
            ThirdBindPO thirdBindPO = new ThirdBindPO();
            thirdBindPO.setAuthType(reqBO.getThirdAuthType());
            thirdBindPO.setAuthId(reqBO.getThirdAuthId());
            thirdBindPO.setOrgId(reqBO.getOrgIdWeb());
            thirdBindPO.setState(UmcEnumConstant.State.EFFECTIVE.getCode());
            List<ThirdBindPO> thirdBindPOS = this.thirdBindMapper.getThirdMemList(thirdBindPO);
            if (!CollectionUtils.isEmpty(thirdBindPOS)) {
                rspBO.setMemId(thirdBindPOS.get(0).getMemId());
                rspBO.setRespCode("5003");
                rspBO.setRespDesc("\u7b2c\u4e09\u65b9\u8d26\u53f7\u5df2\u7ecf\u88ab\u6ce8\u518c");
                return;
            }
        }
        if (this.hasFaceInfo(reqBO)) {
            for (FaceInfoAtomBO faceInfoAtomBO : reqBO.getFaceInfoList()) {
                MemFacePO memFacePO = new MemFacePO();
                memFacePO.setFaceId(faceInfoAtomBO.getFaceId());
                if ((memFacePO = this.memFaceMapper.getModelByCondition(memFacePO)) == null) continue;
                rspBO.setMemId(memFacePO.getMemId());
                rspBO.setRespCode("5003");
                rspBO.setRespDesc("FaceID\u5df2\u7ecf\u88ab\u6ce8\u518c");
                return;
            }
        }
    }

    private boolean hasFaceInfo(UmcMemRegistAtomReqBO reqBO) {
        return !CollectionUtils.isEmpty(reqBO.getFaceInfoList());
    }

    private boolean hasThirdAuthInfo(UmcMemRegistAtomReqBO reqBO) {
        if (reqBO.getThirdAuthType() == null) {
            return false;
        }
        return !StringUtils.isEmpty((Object)reqBO.getThirdAuthId());
    }

    private MemFacePO buildFace(Long memId, FaceInfoAtomBO faceInfoBO) {
        MemFacePO rspPO = new MemFacePO();
        rspPO.setMemId(memId);
        rspPO.setFaceId(faceInfoBO.getFaceId());
        rspPO.setState(UmcEnumConstant.State.EFFECTIVE.getCode());
        rspPO.setPhotoType(faceInfoBO.getPhotoType());
        rspPO.setPhotoUrl(faceInfoBO.getPhotoUrl());
        rspPO.setId(Sequence.getInstance().nextId());
        rspPO.setShopCode(faceInfoBO.getShopCode());
        rspPO.setCameraId(faceInfoBO.getCameraId());
        rspPO.setCreateTime(new Date());
        return rspPO;
    }

    private Long getMemId() {
        try {
            return this.memIdSequencePager.nextId();
        }
        catch (Exception e) {
            if (IS_DEBUG) {
                LOGGER.error("\u83b7\u53d6\u4f1a\u5458ID\u5f02\u5e38\uff1a");
                e.printStackTrace();
            }
            throw new UmcBusinessException("5005", "\u83b7\u53d6\u4f1a\u5458ID\u5f02\u5e38", e);
        }
    }

    private MemberPO buildMember(UmcMemRegistAtomReqBO reqBO, Long memId) {
        MemberPO rspPO = new MemberPO();
        rspPO.setMemId(memId);
        rspPO.setRegAccount(reqBO.getRegAccount());
        rspPO.setRegMobile(reqBO.getRegMobile());
        rspPO.setRegEmail(reqBO.getRegEmail());
        rspPO.setHeadUrl(reqBO.getHeadUrl());
        rspPO.setCompanyId(reqBO.getCompanyId());
        rspPO.setIsOnline(UmcEnumConstant.IsOnline.NO.getCode());
        rspPO.setState(UmcEnumConstant.MemState.EFFECTIVE.getCode());
        rspPO.setMemType(reqBO.getMemType());
        rspPO.setPasswd(reqBO.getPasswd());
        rspPO.setIsPasswdValid(UmcEnumConstant.IsPasswdValid.YES.getCode());
        rspPO.setMaxRepeatLoginNum(UmcCommConstant.UmcDefaultValue.MAX_REPEAT_LOGIN_NUM);
        rspPO.setMemName1(reqBO.getMemName1());
        rspPO.setMemName2(reqBO.getMemName2());
        rspPO.setMemNickName(reqBO.getMemNickName());
        rspPO.setSex(reqBO.getSex());
        rspPO.setCertType(reqBO.getCertType());
        rspPO.setCertNo(reqBO.getCertNo());
        rspPO.setIsBlackList(UmcEnumConstant.IsBlacklist.NO.getCode());
        if (reqBO.getMemLevel() == null) {
            rspPO.setMemLevel(UmcCommConstant.UmcDefaultValue.MEM_LEVEL);
        } else {
            rspPO.setMemLevel(reqBO.getMemLevel());
        }
        rspPO.setGrowValue(UmcCommConstant.UmcDefaultValue.GROW_VALUE);
        rspPO.setMemReputation(UmcCommConstant.UmcDefaultValue.MEM_REPUTATION);
        rspPO.setMemBalance(UmcCommConstant.UmcDefaultValue.MEM_BALANCE);
        rspPO.setCreateTime(new Date());
        if (StringUtils.isEmpty((Object)rspPO.getMemNickName())) {
            StringBuffer memNickName = new StringBuffer("NR-");
            memNickName.append(this.getMemNickNameId());
            rspPO.setMemNickName(memNickName.toString());
        }
        rspPO.setBirthday(reqBO.getBirthday());
        if (reqBO.getLevelEffTime() == null) {
            rspPO.setLevelEffTime(new Date());
        } else {
            rspPO.setLevelEffTime(reqBO.getLevelEffTime());
        }
        if (reqBO.getLevelExpTime() == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.add(1, 1);
            Date date = calendar.getTime();
            String dateStr = DateUtils.getCurrentMaxDate((String)DateUtils.dateToStr((Date)date));
            Date levelExpTime = DateUtils.strToDateLong((String)dateStr);
            rspPO.setLevelExpTime(levelExpTime);
        } else {
            rspPO.setLevelExpTime(reqBO.getLevelExpTime());
        }
        rspPO.setIsPlus(reqBO.getIsPlus());
        rspPO.setPlusEffTime(reqBO.getPlusEffTime());
        rspPO.setPlusExpTime(reqBO.getPlusExpTime());
        rspPO.setOrgId(reqBO.getOrgIdWeb());
        rspPO.setWorkNo(reqBO.getWorkNo());
        rspPO.setOfficePhone(reqBO.getOfficePhone());
        rspPO.setMainMemId(memId);
        rspPO.setMemAffiliation(reqBO.getMemAffiliation());
        rspPO.setStopStatus(reqBO.getStopStatus());
        rspPO.setMemClassify(reqBO.getMemClassify());
        rspPO.setWeight(reqBO.getWeight());
        rspPO.setHeight(reqBO.getHeight());
        rspPO.setOccupation(reqBO.getOccupation());
        rspPO.setMemNewOld(UmcCommConstant.MemNewOld.NEW);
        rspPO.setUserType(reqBO.getUserType());
        return rspPO;
    }

    private long getMemNickNameId() {
        try {
            return this.memNickNameIdSequencePager.nextId();
        }
        catch (Exception e) {
            if (IS_DEBUG) {
                LOGGER.error("\u83b7\u53d6\u4f1a\u5458\u6635\u79f0ID\u5f02\u5e38\uff1a");
                e.printStackTrace();
            }
            throw new UmcBusinessException("5005", "\u83b7\u53d6\u4f1a\u5458\u6635\u79f0ID\u5f02\u5e38", e);
        }
    }
}

