/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.atom.impl;

import com.tydic.umc.atom.UmcRuleCalculateAtomService;
import com.tydic.umc.atom.bo.UmcRuleCalculateAtomReqBO;
import com.tydic.umc.atom.bo.UmcRuleCalculateAtomRspBO;
import com.tydic.umc.atom.unicall.UmcRuleCalcStrategyService;
import com.tydic.umc.atom.unicall.bo.UmcRuleCalcStrategyReqBO;
import com.tydic.umc.atom.unicall.bo.UmcRuleCalcStrategyRspBO;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.RuleDefineMapper;
import com.tydic.umc.po.RuleDefinePO;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="umcRuleCalculateAtomService")
public class UmcRuleCalculateAtomServiceImpl
implements UmcRuleCalculateAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcRuleCalculateAtomServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private ApplicationContext applicationContext;
    private RuleDefineMapper ruleDefineMapper;

    @Autowired
    public UmcRuleCalculateAtomServiceImpl(RuleDefineMapper ruleDefineMapper, ApplicationContext applicationContext) {
        this.ruleDefineMapper = ruleDefineMapper;
        this.applicationContext = applicationContext;
    }

    @Override
    public UmcRuleCalculateAtomRspBO ruleCalculate(UmcRuleCalculateAtomReqBO umcRuleCalculateAtomReqBO) {
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u4f1a\u5458\u4e2d\u5fc3\u89c4\u5219\u8ba1\u7b97\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e3a\uff1a" + umcRuleCalculateAtomReqBO.toString());
        }
        UmcRuleCalculateAtomRspBO rspBO = null;
        RuleDefinePO ruleDefinePO = this.qryRuleDefine(umcRuleCalculateAtomReqBO);
        if (ruleDefinePO == null) {
            rspBO = new UmcRuleCalculateAtomRspBO();
            rspBO.setRespCode("1009");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8ba1\u7b97\u89c4\u5219[" + umcRuleCalculateAtomReqBO.getRuleId() + "]\u7684\u4fe1\u606f");
            return rspBO;
        }
        if (UmcEnumConstant.State.INVALID.getCode().equals(ruleDefinePO.getState())) {
            rspBO = new UmcRuleCalculateAtomRspBO();
            rspBO.setRespCode("1022");
            rspBO.setRespDesc("\u8ba1\u7b97\u89c4\u5219[" + umcRuleCalculateAtomReqBO.getRuleId() + "]\u5df2\u5931\u6548");
            return rspBO;
        }
        int methodMode = ruleDefinePO.getMethodMode();
        switch (methodMode) {
            case 1: {
                rspBO = this.getTargetValueByServ(ruleDefinePO, umcRuleCalculateAtomReqBO.getRuleParamsMap(), umcRuleCalculateAtomReqBO.getMemId());
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                rspBO = this.getTargetValueByDefaultValue(ruleDefinePO);
                break;
            }
            default: {
                if (IS_DEBUG_ENABLED) {
                    LOGGER.debug("\u4e0d\u5b58\u5728[" + umcRuleCalculateAtomReqBO.getRuleId() + "]\u7684\u7c7b\u578b\u8ba1\u7b97\u65b9\u5f0f");
                }
                rspBO = new UmcRuleCalculateAtomRspBO();
                rspBO.setRespCode("1010");
                rspBO.setRespDesc("\u4e0d\u5b58\u5728[" + umcRuleCalculateAtomReqBO.getRuleId() + "]\u7684\u7c7b\u578b\u8ba1\u7b97\u65b9\u5f0f");
            }
        }
        return rspBO;
    }

    private RuleDefinePO qryRuleDefine(UmcRuleCalculateAtomReqBO reqBO) {
        RuleDefinePO ruleDefineModel = new RuleDefinePO();
        ruleDefineModel.setRuleId(reqBO.getRuleId());
        ruleDefineModel.setRuleType(reqBO.getRuleType());
        return this.ruleDefineMapper.getModelByCondition(ruleDefineModel);
    }

    private UmcRuleCalculateAtomRspBO getTargetValueByServ(RuleDefinePO ruleDefinePO, Map<String, Object> ruleParamsMap, Long memId) {
        UmcRuleCalculateAtomRspBO rspBO = new UmcRuleCalculateAtomRspBO();
        UmcRuleCalcStrategyService umcRuleCalcStrategyService = (UmcRuleCalcStrategyService)this.applicationContext.getBean(ruleDefinePO.getServMethod());
        UmcRuleCalcStrategyReqBO umcRuleCalcStrategyReqBO = new UmcRuleCalcStrategyReqBO();
        umcRuleCalcStrategyReqBO.setRuleId(ruleDefinePO.getRuleId());
        umcRuleCalcStrategyReqBO.setTargetValue(ruleDefinePO.getTargetValue());
        umcRuleCalcStrategyReqBO.setRuleParamsMap(ruleParamsMap);
        umcRuleCalcStrategyReqBO.setMemId(memId);
        UmcRuleCalcStrategyRspBO ruleCalcStrategyRspBO = umcRuleCalcStrategyService.ruleCalc(umcRuleCalcStrategyReqBO);
        rspBO.setRespCode(ruleCalcStrategyRspBO.getRespCode());
        rspBO.setRespDesc(ruleCalcStrategyRspBO.getRespDesc());
        rspBO.setTargetValue(ruleCalcStrategyRspBO.getTargetValue());
        return rspBO;
    }

    private UmcRuleCalculateAtomRspBO getTargetValueByDefaultValue(RuleDefinePO ruleDefinePO) {
        UmcRuleCalculateAtomRspBO rspBO = new UmcRuleCalculateAtomRspBO();
        if (StringUtils.isEmpty((CharSequence)ruleDefinePO.getTargetValue())) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u89c4\u5219[" + ruleDefinePO.getRuleId() + "]\u672a\u914d\u7f6e\u9ed8\u8ba4\u503c");
            }
            rspBO.setRespCode("1011");
            rspBO.setRespDesc("\u89c4\u5219[" + ruleDefinePO.getRuleId() + "]\u672a\u914d\u7f6e\u9ed8\u8ba4\u503c");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u76ee\u6807\u503c\u83b7\u53d6\u6210\u529f");
        rspBO.setTargetValue(ruleDefinePO.getTargetValue());
        return rspBO;
    }
}

