/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.atom.unicall.impl;

import com.tydic.umc.atom.unicall.UmcRuleCalcStrategyService;
import com.tydic.umc.atom.unicall.bo.UmcRuleCalcStrategyReqBO;
import com.tydic.umc.atom.unicall.bo.UmcRuleCalcStrategyRspBO;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="umcCalcCanDedMoneyService")
public class UmcCalcCanDedMoneyServiceImpl
implements UmcRuleCalcStrategyService {
    private static final String PARAM_ONE = "deductionIntegral";
    private static final String SPLIT_ONE = ",";

    @Override
    public UmcRuleCalcStrategyRspBO ruleCalc(UmcRuleCalcStrategyReqBO umcRuleCalcStrategyReqBO) {
        UmcRuleCalcStrategyRspBO rspBO = new UmcRuleCalcStrategyRspBO();
        String targetValue = umcRuleCalcStrategyReqBO.getTargetValue();
        if (targetValue == null) {
            rspBO.setRespCode("1901");
            rspBO.setRespDesc("\u79ef\u5206\u62b5\u6263\u91d1\u989d\u8ba1\u7b97\u7b56\u7565\u6267\u884c\u5931\u8d25\uff1a\u89c4\u5219[" + umcRuleCalcStrategyReqBO.getRuleId() + "]\u8fd8\u672a\u914d\u7f6e\u89c4\u5219\u5bf9\u5e94\u7684\u76ee\u6807\u503c");
            return rspBO;
        }
        if (!targetValue.contains(SPLIT_ONE)) {
            rspBO.setRespCode("1902");
            rspBO.setRespDesc("\u79ef\u5206\u62b5\u6263\u91d1\u989d\u8ba1\u7b97\u7b56\u7565\u6267\u884c\u5931\u8d25\uff1a\u8bf7\u786e\u8ba4\u89c4\u5219[" + umcRuleCalcStrategyReqBO.getRuleId() + "\u76ee\u6807\u503c\u683c\u5f0f\u662f\u5426\u4e3aV1,V2\u7684\u683c\u5f0f!");
            return rspBO;
        }
        String[] splitRuleDefine = targetValue.split(SPLIT_ONE);
        if (StringUtils.isEmpty((CharSequence)splitRuleDefine[0]) || StringUtils.isEmpty((CharSequence)splitRuleDefine[1])) {
            rspBO.setRespCode("1901");
            rspBO.setRespDesc("\u79ef\u5206\u62b5\u6263\u91d1\u989d\u8ba1\u7b97\u7b56\u7565\u6267\u884c\u5931\u8d25\uff1a\u89c4\u5219[" + umcRuleCalcStrategyReqBO.getRuleId() + "]\u7684\u76ee\u6807\u503c\u4e2d\u8fd8\u672a\u914d\u7f6e\u91d1\u989d\u3001\u62b5\u6263\u8be5\u91d1\u989d\u9700\u8981\u7684\u79ef\u5206\u6570");
            return rspBO;
        }
        BigDecimal moneyValue = new BigDecimal(splitRuleDefine[0]);
        Long needIntegral = Long.valueOf(splitRuleDefine[1]);
        Long deductionIntegral = (Long)umcRuleCalcStrategyReqBO.getRuleParamsMap().get(PARAM_ONE);
        if (deductionIntegral == 0L) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u4f20\u5165\u7684\u62b5\u6263\u79ef\u5206\u4e3a0\uff0c\u4e0d\u4e88\u8fdb\u884c\u62b5\u6263\u91d1\u989d\u6362\u7b97");
            rspBO.setTargetValue("0");
            return rspBO;
        }
        BigDecimal canDedNums = new BigDecimal(deductionIntegral / needIntegral);
        BigDecimal deductionMoney = canDedNums.multiply(moneyValue);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u53ef\u62b5\u6263\u91d1\u989d\u8ba1\u7b97\u6210\u529f");
        rspBO.setTargetValue(deductionMoney + "");
        return rspBO;
    }
}

