/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.atom.unicall.impl;

import com.tydic.umc.atom.unicall.UmcRuleCalcStrategyService;
import com.tydic.umc.atom.unicall.bo.UmcRuleCalcStrategyReqBO;
import com.tydic.umc.atom.unicall.bo.UmcRuleCalcStrategyRspBO;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="umcExchangIntegralAndGrowValueService")
public class UmcExchangIntegralAndGrowValueServiceImpl
implements UmcRuleCalcStrategyService {
    private static final String SPLIT_ONE = ",";
    private static final String SPLIT_TWO = ":";

    @Override
    public UmcRuleCalcStrategyRspBO ruleCalc(UmcRuleCalcStrategyReqBO umcRuleCalcStrategyReqBO) {
        UmcRuleCalcStrategyRspBO rsp = new UmcRuleCalcStrategyRspBO();
        String memLevel = String.valueOf(umcRuleCalcStrategyReqBO.getRuleParamsMap().get("memLevel"));
        String targetValue = umcRuleCalcStrategyReqBO.getTargetValue();
        if (targetValue == null) {
            rsp.setRespCode("1901");
            rsp.setRespDesc("\u8bc4\u4ef7/\u56de\u7b54/\u5206\u4eab\u6210\u957f\u503c\u8ba1\u7b97\u7b56\u7565\u670d\u52a1\u5931\u8d25\uff1a\u89c4\u5219[" + umcRuleCalcStrategyReqBO.getRuleId() + "]\u8fd8\u672a\u914d\u7f6e\u89c4\u5219\u5bf9\u5e94\u7684\u76ee\u6807\u503c");
            return rsp;
        }
        if (!targetValue.contains(SPLIT_ONE) && !targetValue.contains(SPLIT_TWO)) {
            rsp.setRespCode("1902");
            rsp.setRespDesc("\u8bc4\u4ef7/\u56de\u7b54/\u5206\u4eab\u6210\u957f\u503c\u8ba1\u7b97\u7b56\u7565\u670d\u52a1\u5931\u8d25\uff1a\u8bf7\u786e\u8ba4\u89c4\u5219[" + umcRuleCalcStrategyReqBO.getRuleId() + "\u76ee\u6807\u503c\u683c\u5f0f\u662f\u5426\u4e3aA:V1,B:V2,C:V3\u4ee5\u6b64\u7c7b\u63a8\u7684\u683c\u5f0f!");
            return rsp;
        }
        String[] splitRuleDefine = targetValue.split(SPLIT_ONE);
        HashMap<String, String> ruleDefineMap = new HashMap<String, String>(splitRuleDefine.length);
        for (String ruleDefine : splitRuleDefine) {
            String[] levelAndIntegral = ruleDefine.split(SPLIT_TWO);
            ruleDefineMap.put(levelAndIntegral[0].trim(), levelAndIntegral[1].trim());
        }
        String exchangeRate = String.valueOf(ruleDefineMap.get(memLevel));
        if (StringUtils.isBlank((CharSequence)exchangeRate)) {
            rsp.setRespCode("1908");
            rsp.setRespDesc("\u4f1a\u5458\u7b49\u7ea7\u6bd4\u4f8b\u914d\u7f6e\u9519\u8bef\uff01");
            return rsp;
        }
        rsp.setTargetValue(exchangeRate);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6210\u957f\u503c\u79ef\u5206\u5151\u6362\u8ba1\u7b97\u7b56\u7565\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }
}

