/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.atom.unicall.impl;

import com.tydic.umc.atom.unicall.UmcRuleCalcStrategyService;
import com.tydic.umc.atom.unicall.bo.UmcRuleCalcStrategyReqBO;
import com.tydic.umc.atom.unicall.bo.UmcRuleCalcStrategyRspBO;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="umcIntegralDedCalcUseIntegralService")
public class UmcIntegralDedCalcUseIntegralServiceImpl
implements UmcRuleCalcStrategyService {
    private static final String PARAM_ONE = "totalMoney";
    private static final String PARAM_TWO = "usedIntegral";
    private static final String SPLIT_ONE = ",";

    @Override
    public UmcRuleCalcStrategyRspBO ruleCalc(UmcRuleCalcStrategyReqBO umcRuleCalcStrategyReqBO) {
        UmcRuleCalcStrategyRspBO rspBO = new UmcRuleCalcStrategyRspBO();
        String targetValue = umcRuleCalcStrategyReqBO.getTargetValue();
        if (targetValue == null) {
            rspBO.setRespCode("1901");
            rspBO.setRespDesc("\u79ef\u5206\u62b5\u6263\u91d1\u989d\u8ba1\u7b97\u53ef\u4f7f\u7528\u7684\u79ef\u5206\u7b56\u7565\u6267\u884c\u5931\u8d25\uff1a\u89c4\u5219[" + umcRuleCalcStrategyReqBO.getRuleId() + "]\u8fd8\u672a\u914d\u7f6e\u89c4\u5219\u5bf9\u5e94\u7684\u76ee\u6807\u503c");
            return rspBO;
        }
        if (!targetValue.contains(SPLIT_ONE)) {
            rspBO.setRespCode("1902");
            rspBO.setRespDesc("\u79ef\u5206\u62b5\u6263\u91d1\u989d\u8ba1\u7b97\u53ef\u4f7f\u7528\u7684\u79ef\u5206\u7b56\u7565\u6267\u884c\u5931\u8d25\uff1a\u8bf7\u786e\u8ba4\u89c4\u5219[" + umcRuleCalcStrategyReqBO.getRuleId() + "\u76ee\u6807\u503c\u683c\u5f0f\u662f\u5426\u4e3aV1,V2,V3\u7684\u683c\u5f0f!");
            return rspBO;
        }
        String[] splitRuleDefine = targetValue.split(SPLIT_ONE);
        if (StringUtils.isEmpty((CharSequence)splitRuleDefine[0]) || StringUtils.isEmpty((CharSequence)splitRuleDefine[1]) || StringUtils.isEmpty((CharSequence)splitRuleDefine[2])) {
            rspBO.setRespCode("1901");
            rspBO.setRespDesc("\u79ef\u5206\u62b5\u6263\u91d1\u989d\u8ba1\u7b97\u53ef\u4f7f\u7528\u7684\u79ef\u5206\u7b56\u7565\u6267\u884c\u5931\u8d25\uff1a\u89c4\u5219[" + umcRuleCalcStrategyReqBO.getRuleId() + "]\u7684\u76ee\u6807\u503c\u4e2d\u8fd8\u672a\u914d\u7f6e\u91d1\u989d\u3001\u79ef\u5206\u5151\u6362\u91d1\u989d\u6240\u9700\u503c\u3001\u6700\u5927\u62b5\u6263\u989d\u5ea6");
            return rspBO;
        }
        BigDecimal moneyValue = new BigDecimal(splitRuleDefine[0]);
        Long needIntegral = Long.valueOf(splitRuleDefine[1]);
        BigDecimal limitLines = new BigDecimal(splitRuleDefine[2]);
        BigDecimal totalMoney = new BigDecimal(String.valueOf(umcRuleCalcStrategyReqBO.getRuleParamsMap().get(PARAM_ONE)));
        Long usedIntegral = Long.valueOf(String.valueOf(umcRuleCalcStrategyReqBO.getRuleParamsMap().get(PARAM_TWO)));
        BigDecimal canDedTotalMoney = totalMoney.multiply(limitLines);
        Long canUserIntegral = 0L;
        if (usedIntegral.compareTo(needIntegral) < 0) {
            rspBO.setTargetValue(canUserIntegral + "");
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5f53\u524d\u4f20\u5165\u79ef\u5206\u672a\u6ee1\u8db3\u6700\u5c0f\u79ef\u5206\u4f7f\u7528\u989d\u5ea6[" + needIntegral + "]\u7684\u6761\u4ef6");
            return rspBO;
        }
        Long finalDedIntegral = canDedTotalMoney.divide(moneyValue, 5, 5).longValue() * needIntegral;
        if (usedIntegral.compareTo(finalDedIntegral) > 0) {
            canUserIntegral = finalDedIntegral;
            rspBO.setTargetValue(canUserIntegral + "");
        } else {
            canUserIntegral = usedIntegral / needIntegral * needIntegral;
            rspBO.setTargetValue(canUserIntegral + "");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u53ef\u4f7f\u7528\u79ef\u5206\u8ba1\u7b97\u6210\u529f");
        return rspBO;
    }
}

