/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.atom.unicall.impl;

import com.tydic.umc.atom.unicall.UmcRuleCalcStrategyService;
import com.tydic.umc.atom.unicall.bo.UmcRuleCalcStrategyReqBO;
import com.tydic.umc.atom.unicall.bo.UmcRuleCalcStrategyRspBO;
import com.tydic.umc.dao.MemberMapper;
import com.tydic.umc.po.MemberPO;
import java.math.BigDecimal;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcSelfReceiveGiveIntegralService")
public class UmcSelfReceiveGiveIntegralServiceImpl
implements UmcRuleCalcStrategyService {
    private static final String SPLIT_ONE = ",";
    private static final String SPLIT_TWO = ":";
    private static final String SPLIT_THREE = "=";
    private MemberMapper memberMapper;

    @Autowired
    public UmcSelfReceiveGiveIntegralServiceImpl(MemberMapper memberMapper) {
        this.memberMapper = memberMapper;
    }

    @Override
    public UmcRuleCalcStrategyRspBO ruleCalc(UmcRuleCalcStrategyReqBO umcRuleCalcStrategyReqBO) {
        UmcRuleCalcStrategyRspBO rspBO = new UmcRuleCalcStrategyRspBO();
        String targetValue = umcRuleCalcStrategyReqBO.getTargetValue();
        if (targetValue == null) {
            rspBO.setRespCode("1901");
            rspBO.setRespDesc("\u5230\u5e97\u9886\u53d6\u8d60\u9001\u79ef\u5206\u7b56\u7565\u6267\u884c\u5931\u8d25\uff1a\u89c4\u5219[" + umcRuleCalcStrategyReqBO.getRuleId() + "]\u8fd8\u672a\u914d\u7f6e\u89c4\u5219\u5bf9\u5e94\u7684\u76ee\u6807\u503c");
            return rspBO;
        }
        if (!targetValue.contains(SPLIT_ONE) && !targetValue.contains(SPLIT_TWO)) {
            rspBO.setRespCode("1902");
            rspBO.setRespDesc("\u5230\u5e97\u9886\u53d6\u8d60\u9001\u79ef\u5206\u7b56\u7565\u6267\u884c\u5931\u8d25\uff1a\u8bf7\u786e\u8ba4\u89c4\u5219[" + umcRuleCalcStrategyReqBO.getRuleId() + "\u76ee\u6807\u503c\u683c\u5f0f\u662f\u5426\u4e3a[vipLevel1:payAmount1=I1,vipLevel2:payAmount2=I2]\u7684\u683c\u5f0f!");
            return rspBO;
        }
        String[] splitRuleDefine = targetValue.split(SPLIT_ONE);
        HashMap<String, String> ruleDefineMap = new HashMap<String, String>(splitRuleDefine.length);
        for (String ruleDefine : splitRuleDefine) {
            String[] levelAndIntegral = ruleDefine.split(SPLIT_TWO);
            ruleDefineMap.put(levelAndIntegral[0].trim(), levelAndIntegral[1].trim());
        }
        MemberPO memberModel = new MemberPO();
        memberModel.setMemId(umcRuleCalcStrategyReqBO.getMemId());
        MemberPO memberPO = this.memberMapper.getModelByCondition(memberModel);
        if (memberPO == null || memberPO.getMemLevel() == null) {
            rspBO.setRespCode("1901");
            rspBO.setRespDesc("\u4f1a\u5458\u5f53\u524d\u7b49\u7ea7\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u6652\u5355\u540e\u7684\u8d60\u9001\u79ef\u5206\u64cd\u4f5c");
            return rspBO;
        }
        String incomingVipLevel = memberPO.getMemLevel() + "";
        if (ruleDefineMap.get(incomingVipLevel) == null) {
            rspBO.setRespCode("1901");
            rspBO.setRespDesc("\u5230\u5e97\u9886\u53d6\u8d60\u9001\u79ef\u5206\u7b56\u7565\u6267\u884c\u5931\u8d25\uff1a\u89c4\u5219[" + umcRuleCalcStrategyReqBO.getRuleId() + "]\u7684\u76ee\u6807\u503c\u4e2d\u8fd8\u672a\u914d\u7f6e\u7b49\u7ea7[" + incomingVipLevel + "]\u6240\u5bf9\u5e94\u7684\u8d60\u9001\u79ef\u5206\u6570");
            return rspBO;
        }
        String giveIntegralCondition = (String)ruleDefineMap.get(incomingVipLevel);
        String[] payAndIntegral = giveIntegralCondition.split(SPLIT_THREE);
        if (StringUtils.isEmpty((CharSequence)payAndIntegral[0])) {
            rspBO.setRespCode("1901");
            rspBO.setRespDesc("\u5230\u5e97\u9886\u53d6\u8d60\u9001\u79ef\u5206\u7b56\u7565\u6267\u884c\u5931\u8d25\uff1a\u89c4\u5219[" + umcRuleCalcStrategyReqBO.getRuleId() + "]\u7684\u76ee\u6807\u503c\u4e2d\u8fd8\u672a\u914d\u7f6e\u91d1\u989d\u6ee1\u8db3\u6761\u4ef6");
            return rspBO;
        }
        if (StringUtils.isEmpty((CharSequence)payAndIntegral[1])) {
            rspBO.setRespCode("1901");
            rspBO.setRespDesc("\u5230\u5e97\u9886\u53d6\u8d60\u9001\u79ef\u5206\u7b56\u7565\u6267\u884c\u5931\u8d25\uff1a\u89c4\u5219[" + umcRuleCalcStrategyReqBO.getRuleId() + "]\u7684\u76ee\u6807\u503c\u4e2d\u8fd8\u672a\u914d\u7f6e\u8d60\u9001\u79ef\u5206");
            return rspBO;
        }
        BigDecimal configPayAmount = new BigDecimal(payAndIntegral[0]);
        String configGiveIntegral = payAndIntegral[1];
        BigDecimal incomingPayAmount = new BigDecimal(String.valueOf(umcRuleCalcStrategyReqBO.getRuleParamsMap().get("payAmount")));
        if (configPayAmount.compareTo(incomingPayAmount) > 0) {
            rspBO.setTargetValue("0");
            rspBO.setRespDesc("\u5f53\u524d\u4f1a\u5458\u7b49\u7ea7[" + incomingVipLevel + "]\u8d2d\u7269\u91d1\u989d\u4e0d\u6ee1\u8db3\u5355\u6b21\u8d2d\u7269[" + configPayAmount + "]\u5143\u53ca\u4ee5\u4e0a\u624d\u80fd\u8d60\u9001\u79ef\u5206\u7684\u6761\u4ef6!");
        } else {
            rspBO.setTargetValue(configGiveIntegral);
            rspBO.setRespDesc("\u5230\u5e97\u9886\u53d6\u79ef\u5206\u83b7\u53d6\u6210\u529f");
        }
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

