/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.atom.unicall.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.umc.atom.unicall.UmcRuleCalcStrategyService;
import com.tydic.umc.atom.unicall.bo.UmcRuleCalcStrategyReqBO;
import com.tydic.umc.atom.unicall.bo.UmcRuleCalcStrategyRspBO;
import com.tydic.umc.busi.bo.UmcQryGrowChgLogBusiReqBO;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.GrowChgLogMapper;
import com.tydic.umc.po.GrowChgLogPO;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcShaOrEltOrAnsGrowValueService")
public class UmcShaOrEltOrAnsGrowValueServiceImpl
implements UmcRuleCalcStrategyService {
    private static final String PARAM_ONE = "totalGrowValue";
    private static final String PARAM_TWO = "giveGrowValue";
    private static final String SPLIT_ONE = ",";
    private static final String SPLIT_TWO = ":";
    private GrowChgLogMapper growChgLogMapper;

    @Autowired
    public UmcShaOrEltOrAnsGrowValueServiceImpl(GrowChgLogMapper growChgLogMapper) {
        this.growChgLogMapper = growChgLogMapper;
    }

    @Override
    public UmcRuleCalcStrategyRspBO ruleCalc(UmcRuleCalcStrategyReqBO umcRuleCalcStrategyReqBO) {
        UmcRuleCalcStrategyRspBO rsp = new UmcRuleCalcStrategyRspBO();
        String memIdStr = String.valueOf(umcRuleCalcStrategyReqBO.getRuleParamsMap().get("memId"));
        Long memId = Long.valueOf(memIdStr);
        String targetValue = umcRuleCalcStrategyReqBO.getTargetValue();
        if (targetValue == null) {
            rsp.setRespCode("1901");
            rsp.setRespDesc("\u8bc4\u4ef7/\u56de\u7b54/\u5206\u4eab\u6210\u957f\u503c\u8ba1\u7b97\u7b56\u7565\u670d\u52a1\u5931\u8d25\uff1a\u89c4\u5219[" + umcRuleCalcStrategyReqBO.getRuleId() + "]\u8fd8\u672a\u914d\u7f6e\u89c4\u5219\u5bf9\u5e94\u7684\u76ee\u6807\u503c");
            return rsp;
        }
        if (!targetValue.contains(SPLIT_ONE) && !targetValue.contains(SPLIT_TWO)) {
            rsp.setRespCode("1902");
            rsp.setRespDesc("\u8bc4\u4ef7/\u56de\u7b54/\u5206\u4eab\u6210\u957f\u503c\u8ba1\u7b97\u7b56\u7565\u670d\u52a1\u5931\u8d25\uff1a\u8bf7\u786e\u8ba4\u89c4\u5219[" + umcRuleCalcStrategyReqBO.getRuleId() + "\u76ee\u6807\u503c\u683c\u5f0f\u662f\u5426\u4e3aA:V1,B:V2,C:V3\u4ee5\u6b64\u7c7b\u63a8\u7684\u683c\u5f0f!");
            return rsp;
        }
        String[] splitRuleDefine = targetValue.split(SPLIT_ONE);
        HashMap<String, String> ruleDefineMap = new HashMap<String, String>(splitRuleDefine.length);
        for (String ruleDefine : splitRuleDefine) {
            String[] levelAndIntegral = ruleDefine.split(SPLIT_TWO);
            ruleDefineMap.put(levelAndIntegral[0].trim(), levelAndIntegral[1].trim());
        }
        String totalGrowValue = String.valueOf(ruleDefineMap.get(PARAM_ONE));
        if (StringUtils.isBlank((CharSequence)totalGrowValue)) {
            rsp.setRespCode("1901");
            rsp.setRespDesc("\u8bc4\u4ef7/\u56de\u7b54/\u5206\u4eab\u6210\u957f\u503c\u8ba1\u7b97\u7b56\u7565\u670d\u52a1\u5931\u8d25\uff1a\u89c4\u5219[" + umcRuleCalcStrategyReqBO.getRuleId() + "]\u7684\u76ee\u6807\u503c\u4e2d\u8fd8\u672a\u914d\u7f6e\u6bcf\u65e5\u6210\u957f\u503c\u589e\u957f\u4e0a\u9650\u53c2\u6570totalGrowValue");
            return rsp;
        }
        String giveGrowValue = String.valueOf(ruleDefineMap.get(PARAM_TWO));
        if (StringUtils.isBlank((CharSequence)giveGrowValue)) {
            rsp.setRespCode("1901");
            rsp.setRespDesc("\u8bc4\u4ef7/\u56de\u7b54/\u5206\u4eab\u6210\u957f\u503c\u8ba1\u7b97\u7b56\u7565\u670d\u52a1\u5931\u8d25\uff1a\u89c4\u5219[" + umcRuleCalcStrategyReqBO.getRuleId() + "]\u7684\u76ee\u6807\u503c\u4e2d\u8fd8\u672a\u914d\u7f6e\u6bcf\u6b21\u589e\u52a0\u6210\u957f\u503c\u53c2\u6570giveGrowValue");
            return rsp;
        }
        Long dayAlready = this.totalDayAlreadyGrow(memId);
        try {
            Long totalGrowValue2 = Long.valueOf(totalGrowValue);
            if (totalGrowValue2 <= dayAlready) {
                rsp.setRespCode("0000");
                rsp.setRespDesc("\u5f53\u5929\u6210\u957f\u503c\u589e\u52a0\u5df2\u8fbe\u3010" + totalGrowValue2 + "\u3011\u7684\u4e0a\u9650\uff01");
                rsp.setTargetValue(String.valueOf(0));
                return rsp;
            }
        }
        catch (Exception e) {
            rsp.setRespCode("1907");
            rsp.setRespDesc("\u6bcf\u65e5\u6210\u957f\u503c\u589e\u957f\u4e0a\u9650\u53c2\u6570totalGrowValue\u7c7b\u578b\u8f6c\u6362\u5931\u8d25\uff1a" + e);
            return rsp;
        }
        try {
            Long.valueOf(giveGrowValue);
        }
        catch (Exception e) {
            rsp.setRespCode("1907");
            rsp.setRespDesc("\u6bcf\u6b21\u589e\u52a0\u6210\u957f\u503c\u53c2\u6570giveGrowValue\u7c7b\u578b\u8f6c\u6362\u5931\u8d25\uff1a" + e);
            return rsp;
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u8bc4\u4ef7/\u56de\u7b54/\u5206\u4eab\u6210\u957f\u503c\u8ba1\u7b97\u7b56\u7565\u670d\u52a1\u6210\u529f\uff01");
        rsp.setTargetValue(giveGrowValue);
        return rsp;
    }

    private Long totalDayAlreadyGrow(Long memId) {
        UmcQryGrowChgLogBusiReqBO umcQryGrowChgLogBusiReqBO = new UmcQryGrowChgLogBusiReqBO();
        umcQryGrowChgLogBusiReqBO.setMemId(memId);
        umcQryGrowChgLogBusiReqBO.setOperCode(UmcEnumConstant.AddGrowOperCode.EVALUATE_ANSWER_SHARE.getCode());
        Date currentSystemTime = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String currentMinDate = dateFormat.format(currentSystemTime) + " 00:00:00";
        String currentMaxDate = dateFormat.format(currentSystemTime) + " 23:59:59";
        umcQryGrowChgLogBusiReqBO.setStartTime(DateUtils.strToDateLong((String)currentMinDate));
        umcQryGrowChgLogBusiReqBO.setEndTime(DateUtils.strToDateLong((String)currentMaxDate));
        Page page = new Page(1, Integer.MAX_VALUE);
        List<GrowChgLogPO> growChgLogPOS = this.growChgLogMapper.getListPageByConditionAndSort(umcQryGrowChgLogBusiReqBO, (Page<GrowChgLogPO>)page);
        Long totalDayAlreadyGrow = 0L;
        if (growChgLogPOS != null && !growChgLogPOS.isEmpty()) {
            for (GrowChgLogPO growChgLogPO : growChgLogPOS) {
                totalDayAlreadyGrow = totalDayAlreadyGrow + growChgLogPO.getGrowValue();
            }
        }
        return totalDayAlreadyGrow;
    }
}

