/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.atom.unicall.impl;

import com.tydic.umc.atom.unicall.UmcRuleCalcStrategyService;
import com.tydic.umc.atom.unicall.bo.UmcRuleCalcStrategyReqBO;
import com.tydic.umc.atom.unicall.bo.UmcRuleCalcStrategyRspBO;
import java.math.BigDecimal;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="umcShoppingGiveIntegralService")
public class UmcShoppingGiveIntegralServiceImpl
implements UmcRuleCalcStrategyService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcShoppingGiveIntegralServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final boolean IS_INFO_ENABLED = LOGGER.isInfoEnabled();
    private static final String PARAM_ONE = "giveCondition";
    private static final String PARAM_TWO = "calcPercent";
    private static final String PARAM_THREE = "integralLimit";
    private static final String SPLIT_ONE = ",";
    private static final String SPLIT_TWO = ":";

    @Override
    public UmcRuleCalcStrategyRspBO ruleCalc(UmcRuleCalcStrategyReqBO umcRuleCalcStrategyReqBO) {
        UmcRuleCalcStrategyRspBO rspBO = new UmcRuleCalcStrategyRspBO();
        String targetValue = umcRuleCalcStrategyReqBO.getTargetValue();
        if (targetValue == null) {
            rspBO.setRespCode("1901");
            rspBO.setRespDesc("\u8d2d\u7269\u56de\u9988\u8d60\u9001\u79ef\u5206\u7b56\u7565\u6267\u884c\u5931\u8d25\uff1a\u89c4\u5219[" + umcRuleCalcStrategyReqBO.getRuleId() + "]\u8fd8\u672a\u914d\u7f6e\u89c4\u5219\u5bf9\u5e94\u7684\u76ee\u6807\u503c");
            return rspBO;
        }
        if (!targetValue.contains(SPLIT_ONE) && !targetValue.contains(SPLIT_TWO)) {
            rspBO.setRespCode("1902");
            rspBO.setRespDesc("\u8d2d\u7269\u56de\u9988\u8d60\u9001\u79ef\u5206\u7b56\u7565\u6267\u884c\u5931\u8d25\uff1a\u8bf7\u786e\u8ba4\u89c4\u5219[" + umcRuleCalcStrategyReqBO.getRuleId() + "\u76ee\u6807\u503c\u683c\u5f0f\u662f\u5426\u4e3a[giveCondition:V1,calcPercent:V2,integralLimit:V3]\u7684\u683c\u5f0f!");
            return rspBO;
        }
        String[] splitRuleDefine = targetValue.split(SPLIT_ONE);
        HashMap<String, String> ruleDefineMap = new HashMap<String, String>(splitRuleDefine.length);
        for (String ruleDefine : splitRuleDefine) {
            String[] levelAndIntegral = ruleDefine.split(SPLIT_TWO);
            ruleDefineMap.put(levelAndIntegral[0].trim(), levelAndIntegral[1].trim());
        }
        BigDecimal incomingPayAmount = new BigDecimal(String.valueOf(umcRuleCalcStrategyReqBO.getRuleParamsMap().get("payAmount")));
        if (ruleDefineMap.get(PARAM_ONE) == null) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u8d2d\u7269\u56de\u9988\u8d60\u9001\u79ef\u5206\u7b56\u7565\u6267\u884c\u5931\u8d25\uff1a\u89c4\u5219[{}]\u7684\u76ee\u6807\u503c\u4e2d\u8fd8\u672a\u914d\u7f6e\u79ef\u5206\u603b\u9001\u6ee1\u8db3\u6761\u4ef6", (Object)umcRuleCalcStrategyReqBO.getRuleId());
            }
            rspBO.setRespCode("1901");
            rspBO.setRespDesc("\u8d2d\u7269\u56de\u9988\u8d60\u9001\u79ef\u5206\u7b56\u7565\u6267\u884c\u5931\u8d25\uff1a\u89c4\u5219[" + umcRuleCalcStrategyReqBO.getRuleId() + "]\u7684\u76ee\u6807\u503c\u4e2d\u8fd8\u672a\u914d\u7f6e\u79ef\u5206\u603b\u9001\u6ee1\u8db3\u6761\u4ef6");
            return rspBO;
        }
        BigDecimal configGiveCondition = new BigDecimal((String)ruleDefineMap.get(PARAM_ONE));
        if (incomingPayAmount.compareTo(configGiveCondition) < 0) {
            if (IS_INFO_ENABLED) {
                LOGGER.info("\u5f53\u524d\u8d2d\u7269\u91d1\u989d\u4e0d\u6ee1\u8db3\u5355\u6b21\u8d2d\u7269[{}]\u5143\u53ca\u4ee5\u4e0a\u624d\u80fd\u8d60\u9001\u79ef\u5206\u7684\u6761\u4ef6!", (Object)configGiveCondition);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5f53\u524d\u8d2d\u7269\u91d1\u989d\u4e0d\u6ee1\u8db3\u5355\u6b21\u8d2d\u7269[" + configGiveCondition + "]\u5143\u53ca\u4ee5\u4e0a\u624d\u80fd\u8d60\u9001\u79ef\u5206\u7684\u6761\u4ef6!");
            rspBO.setTargetValue("0");
            return rspBO;
        }
        if (ruleDefineMap.get(PARAM_TWO) == null) {
            rspBO.setRespCode("1901");
            rspBO.setRespDesc("\u8d2d\u7269\u56de\u9988\u8d60\u9001\u79ef\u5206\u7b56\u7565\u6267\u884c\u5931\u8d25\uff1a\u89c4\u5219[" + umcRuleCalcStrategyReqBO.getRuleId() + "]\u7684\u76ee\u6807\u503c\u4e2d\u8fd8\u672a\u914d\u7f6e\u8ba1\u7b97\u6bd4\u4f8b\u6761\u4ef6");
            return rspBO;
        }
        if (ruleDefineMap.get(PARAM_THREE) == null) {
            rspBO.setRespCode("1901");
            rspBO.setRespDesc("\u8d2d\u7269\u56de\u9988\u8d60\u9001\u79ef\u5206\u7b56\u7565\u6267\u884c\u5931\u8d25\uff1a\u89c4\u5219[" + umcRuleCalcStrategyReqBO.getRuleId() + "]\u7684\u76ee\u6807\u503c\u4e2d\u8fd8\u672a\u914d\u7f6e\u6700\u9ad8\u8d60\u9001\u79ef\u5206\u9650\u989d");
            return rspBO;
        }
        BigDecimal configCalcPercent = new BigDecimal((String)ruleDefineMap.get(PARAM_TWO));
        BigDecimal configIntegralLimit = new BigDecimal((String)ruleDefineMap.get(PARAM_THREE));
        BigDecimal calcIntegral = incomingPayAmount.multiply(configCalcPercent);
        Long finalGiveIntegral = calcIntegral.compareTo(configIntegralLimit) > 0 ? Long.valueOf(configIntegralLimit.longValue()) : Long.valueOf(calcIntegral.longValue());
        rspBO.setTargetValue(String.valueOf(finalGiveIntegral));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8d2d\u7269\u56de\u9988\u8d60\u9001\u79ef\u5206\u6570\u4e3a[" + finalGiveIntegral + "].");
        return rspBO;
    }
}

