/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.atom.unicall.impl;

import com.tydic.umc.atom.unicall.UmcRuleCalcStrategyService;
import com.tydic.umc.atom.unicall.bo.UmcRuleCalcStrategyReqBO;
import com.tydic.umc.atom.unicall.bo.UmcRuleCalcStrategyRspBO;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.MemberMapper;
import com.tydic.umc.po.MemberPO;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcShowOrderGiveIntegralService")
public class UmcShowOrderGiveIntegralServiceImpl
implements UmcRuleCalcStrategyService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcShowOrderGiveIntegralServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final boolean IS_INFO_ENABLED = LOGGER.isInfoEnabled();
    private static final String SPLIT_ONE = ",";
    private static final String SPLIT_TWO = ":";
    private MemberMapper memberMapper;

    @Autowired
    public UmcShowOrderGiveIntegralServiceImpl(MemberMapper memberMapper) {
        this.memberMapper = memberMapper;
    }

    @Override
    public UmcRuleCalcStrategyRspBO ruleCalc(UmcRuleCalcStrategyReqBO umcRuleCalcStrategyReqBO) {
        UmcRuleCalcStrategyRspBO rspBO = new UmcRuleCalcStrategyRspBO();
        String targetValue = umcRuleCalcStrategyReqBO.getTargetValue();
        if (targetValue == null) {
            rspBO.setRespCode("1901");
            rspBO.setRespDesc("\u6652\u5355\u8d60\u9001\u79ef\u5206\u7b56\u7565\u6267\u884c\u5931\u8d25\uff1a\u89c4\u5219[" + umcRuleCalcStrategyReqBO.getRuleId() + "]\u8fd8\u672a\u914d\u7f6e\u89c4\u5219\u5bf9\u5e94\u7684\u76ee\u6807\u503c");
            return rspBO;
        }
        if (!targetValue.contains(SPLIT_ONE) && !targetValue.contains(SPLIT_TWO)) {
            rspBO.setRespCode("1902");
            rspBO.setRespDesc("\u6652\u5355\u8d60\u9001\u79ef\u5206\u7b56\u7565\u6267\u884c\u5931\u8d25\uff1a\u8bf7\u786e\u8ba4\u89c4\u5219[" + umcRuleCalcStrategyReqBO.getRuleId() + "\u76ee\u6807\u503c\u683c\u5f0f\u662f\u5426\u4e3aA:V1,B:V2,C:V3\u4ee5\u6b64\u7c7b\u63a8\u7684\u683c\u5f0f!");
            return rspBO;
        }
        String[] splitRuleDefine = targetValue.split(SPLIT_ONE);
        HashMap<String, String> ruleDefineMap = new HashMap<String, String>(splitRuleDefine.length);
        for (String ruleDefine : splitRuleDefine) {
            String[] levelAndIntegral = ruleDefine.split(SPLIT_TWO);
            ruleDefineMap.put(levelAndIntegral[0].trim(), levelAndIntegral[1].trim());
        }
        String type = String.valueOf(umcRuleCalcStrategyReqBO.getRuleParamsMap().get("type"));
        if (UmcEnumConstant.EVALUATE_SHOW_ORDER_TYPE.EVALUATE.getCode().equals(type)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u4e0d\u4e88\u8fdb\u884c\u6652\u5355\u79ef\u5206\u8d60\u9001");
            rspBO.setTargetValue("0");
            return rspBO;
        }
        String incomingIntervalMonth = String.valueOf(umcRuleCalcStrategyReqBO.getRuleParamsMap().get("intervalMonth"));
        if (ruleDefineMap.get(incomingIntervalMonth) == null) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u6652\u5355\u8d60\u9001\u79ef\u5206\u7b56\u7565\u6267\u884c\u5931\u8d25\uff1a\u89c4\u5219[{}]\u7684\u76ee\u6807\u503c\u4e2d\u8fd8\u672a\u914d\u7f6e\u95f4\u9694\u6708\u6570\u53c2\u6570intervalMonth", (Object)umcRuleCalcStrategyReqBO.getRuleId());
            }
            rspBO.setRespCode("1901");
            rspBO.setRespDesc("\u6652\u5355\u8d60\u9001\u79ef\u5206\u7b56\u7565\u6267\u884c\u5931\u8d25\uff1a\u89c4\u5219[" + umcRuleCalcStrategyReqBO.getRuleId() + "]\u7684\u76ee\u6807\u503c\u4e2d\u8fd8\u672a\u914d\u7f6e\u95f4\u9694\u6708\u6570\u53c2\u6570intervalMonth");
            return rspBO;
        }
        String configIntervalMonth = String.valueOf(ruleDefineMap.get("intervalMonth"));
        if (Integer.valueOf(incomingIntervalMonth) > Integer.valueOf(configIntervalMonth)) {
            if (IS_INFO_ENABLED) {
                LOGGER.info("\u5f53\u524d\u6652\u5355\u65f6\u95f4\u8d85\u51fa\u89c4\u5b9a\u65f6\u95f4[{}]\u4e2a\u6708\u5185\uff0c\u8d60\u9001\u79ef\u5206\u503c\u4e3a0", (Object)configIntervalMonth);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5f53\u524d\u6652\u5355\u65f6\u95f4\u8d85\u51fa\u89c4\u5b9a\u65f6\u95f4[" + incomingIntervalMonth + "]\u4e2a\u6708\u5185\uff0c\u8d60\u9001\u79ef\u5206\u503c\u4e3a0");
            rspBO.setTargetValue("0");
            return rspBO;
        }
        MemberPO memberModel = new MemberPO();
        memberModel.setMemId(umcRuleCalcStrategyReqBO.getMemId());
        MemberPO memberPO = this.memberMapper.getModelByCondition(memberModel);
        if (memberPO == null || memberPO.getMemLevel() == null) {
            rspBO.setRespCode("1901");
            rspBO.setRespDesc("\u4f1a\u5458\u5f53\u524d\u7b49\u7ea7\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u8d60\u9001\u79ef\u5206\u64cd\u4f5c");
            return rspBO;
        }
        String incomingVipLevel = memberPO.getMemLevel() + "";
        if (ruleDefineMap.get(incomingVipLevel) == null) {
            rspBO.setRespCode("1901");
            rspBO.setRespDesc("\u8bc4\u4ef7\u8d60\u9001\u79ef\u5206\u7b56\u7565\u6267\u884c\u5931\u8d25\uff1a\u89c4\u5219[" + umcRuleCalcStrategyReqBO.getRuleId() + "]\u7684\u76ee\u6807\u503c\u4e2d\u8fd8\u672a\u914d\u7f6e\u7b49\u7ea7[" + incomingVipLevel + "]\u6240\u5bf9\u5e94\u7684\u8d60\u9001\u79ef\u5206\u6570");
            return rspBO;
        }
        String configGiveIntegral = (String)ruleDefineMap.get(incomingVipLevel);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u79ef\u5206\u83b7\u53d6\u6210\u529f");
        rspBO.setTargetValue(configGiveIntegral);
        return rspBO;
    }
}

