/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.umc.busi.UmcAddInvoiceInfoBusiService;
import com.tydic.umc.busi.UmcEditInvoiceInfoBusiService;
import com.tydic.umc.busi.UmcMemDetailQueryBusiService;
import com.tydic.umc.busi.UmcQryInvoiceListBusiService;
import com.tydic.umc.busi.bo.UmcAddInvoiceInfoBusiReqBO;
import com.tydic.umc.busi.bo.UmcAddInvoiceInfoBusiRspBO;
import com.tydic.umc.busi.bo.UmcEditInvoiceInfoBusiReqBO;
import com.tydic.umc.busi.bo.UmcEditInvoiceInfoBusiRspBO;
import com.tydic.umc.busi.bo.UmcMemDetailQueryBusiReqBO;
import com.tydic.umc.busi.bo.UmcMemDetailQueryBusiRspBO;
import com.tydic.umc.busi.bo.UmcQryInvoiceListBusiReqBO;
import com.tydic.umc.busi.bo.UmcQryInvoiceListBusiRspBO;
import com.tydic.umc.common.UmcOriginOrderInfoBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.ConfInvoiceTitleMapper;
import com.tydic.umc.dao.InvoiceInfoDAO;
import com.tydic.umc.dao.LogisticsRelaMapper;
import com.tydic.umc.dao.MemberWalletImpLogMapper;
import com.tydic.umc.external.fsc.bo.UmcExternalPushInvoiceInfoBO;
import com.tydic.umc.external.fsc.bo.UmcExternalPushOrderInfoBO;
import com.tydic.umc.external.fsc.bo.UmcExternalPushOrderInfoItemBO;
import com.tydic.umc.external.fsc.bo.UmcExternalPushOrderInfoReqBO;
import com.tydic.umc.external.fsc.bo.UmcExternalPushOrderInfoRspBO;
import com.tydic.umc.facde.FscServiceHolder;
import com.tydic.umc.po.ConfInvoiceTitlePO;
import com.tydic.umc.po.InvoiceInfoPO;
import com.tydic.umc.po.LogisticsRelaPO;
import com.tydic.umc.po.MemberWalletImpLogPO;
import com.tydic.umc.util.UmcBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="umcAddInvoiceInfoBusiService")
public class UmcAddInvoiceInfoBusiServiceImpl
implements UmcAddInvoiceInfoBusiService {
    @Autowired
    private InvoiceInfoDAO invoiceInfoDAO;
    @Autowired
    private ConfInvoiceTitleMapper confInvoiceTitleMapper;
    @Autowired
    private UmcQryInvoiceListBusiService umcQryInvoiceListBusiService;
    @Autowired
    private UmcEditInvoiceInfoBusiService umcEditInvoiceInfoBusiService;
    @Autowired
    private LogisticsRelaMapper logisticsRelaMapper;
    @Autowired
    private MemberWalletImpLogMapper memberWalletImpLogMapper;
    @Autowired
    private FscServiceHolder fscServiceHolder;
    @Autowired
    private UmcMemDetailQueryBusiService umcMemDetailQueryBusiService;

    public UmcAddInvoiceInfoBusiRspBO addInvoiceInfo(UmcAddInvoiceInfoBusiReqBO reqBO) {
        InvoiceInfoPO invoiceInfoPO = new InvoiceInfoPO();
        ConfInvoiceTitlePO confInvoiceTitlePO = new ConfInvoiceTitlePO();
        confInvoiceTitlePO.setInvoiceTitleId(reqBO.getInvoiceTitleId());
        confInvoiceTitlePO = this.confInvoiceTitleMapper.getModelByConditions(confInvoiceTitlePO);
        if (null == confInvoiceTitlePO) {
            throw new UmcBusinessException("8888", "\u53d1\u7968\u62ac\u5934\u4e0d\u5b58\u5728");
        }
        this.buildInvoiceInfo(confInvoiceTitlePO, invoiceInfoPO);
        LogisticsRelaPO logisticsRelaPO = new LogisticsRelaPO();
        if (null != reqBO.getInvoiceAddressId()) {
            logisticsRelaPO.setContactId(reqBO.getInvoiceAddressId());
            logisticsRelaPO = this.logisticsRelaMapper.getModelByCondition(logisticsRelaPO);
            if (null == logisticsRelaPO) {
                throw new UmcBusinessException("8888", "\u6536\u8d27\u5730\u5740\u4e0d\u5b58\u5728");
            }
        }
        Long amount = 0L;
        ArrayList<MemberWalletImpLogPO> memberWalletImpLogPOS = new ArrayList<MemberWalletImpLogPO>();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getImpIds())) {
            MemberWalletImpLogPO memberWalletImpLogPO = new MemberWalletImpLogPO();
            memberWalletImpLogPO.setImpIds(reqBO.getImpIds());
            memberWalletImpLogPOS.addAll(this.memberWalletImpLogMapper.qryWalletList(memberWalletImpLogPO));
            if (CollectionUtils.isEmpty(memberWalletImpLogPOS)) {
                throw new UmcBusinessException("8888", "\u5f00\u7968\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            for (MemberWalletImpLogPO po : memberWalletImpLogPOS) {
                amount = amount + po.getSuccessAmount();
            }
        }
        Long memId = null == reqBO.getMemId() ? reqBO.getMemIdIn() : reqBO.getMemId();
        invoiceInfoPO.setRemark(reqBO.getRemark());
        invoiceInfoPO.setInvoiceAddressId(reqBO.getInvoiceAddressId());
        invoiceInfoPO.setAmount(amount);
        invoiceInfoPO.setInvoiceType(reqBO.getInvoiceType());
        invoiceInfoPO.setId(Sequence.getInstance().nextId());
        if (null != reqBO.getAdmOrgIdWeb()) {
            invoiceInfoPO.setAdmOrgId(reqBO.getAdmOrgIdWeb());
        }
        if (null == reqBO.getCreateTime()) {
            invoiceInfoPO.setCreateTime(new Date());
        }
        if (null == reqBO.getBusiType()) {
            invoiceInfoPO.setBusiType(0);
        }
        if (null == reqBO.getInvoiceStatus()) {
            invoiceInfoPO.setInvoiceStatus(0);
        }
        invoiceInfoPO.setIsDefault(this.getIsDefault(memId, reqBO.getIsDefault()));
        invoiceInfoPO.setMemId(memId);
        invoiceInfoPO.setCreateNo(String.valueOf(memId));
        invoiceInfoPO.setDelStatus(UmcEnumConstant.DelFlag.NOT_DELETE.getCode());
        int result = this.invoiceInfoDAO.insert(invoiceInfoPO);
        if (result < 1) {
            throw new UmcBusinessException("8888", "\u65b0\u589e\u53d1\u7968\u5931\u8d25");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getImpIds())) {
            MemberWalletImpLogPO memberWalletImpLogPO = new MemberWalletImpLogPO();
            memberWalletImpLogPO.setImpIds(reqBO.getImpIds());
            memberWalletImpLogPO.setInvoiceId(invoiceInfoPO.getId());
            int value = this.memberWalletImpLogMapper.updateInvoiceByIds(memberWalletImpLogPO);
            if (value < reqBO.getImpIds().size()) {
                throw new UmcBusinessException("8888", "\u7ed1\u5b9a\u53d1\u7968\u5931\u8d25");
            }
        }
        this.pushInvoiceInfo(invoiceInfoPO, memberWalletImpLogPOS, confInvoiceTitlePO.getTitleType(), reqBO, logisticsRelaPO);
        UmcAddInvoiceInfoBusiRspBO rspBO = new UmcAddInvoiceInfoBusiRspBO();
        rspBO.setId(invoiceInfoPO.getId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Integer getIsDefault(Long memId, Integer isDefault) {
        if (null == isDefault) {
            return UmcCommConstant.InvoiceIsDefault.IS_DEFAULT_NO;
        }
        UmcQryInvoiceListBusiReqBO reqBO = new UmcQryInvoiceListBusiReqBO();
        reqBO.setMemId(memId);
        reqBO.setIsDefault(UmcCommConstant.InvoiceIsDefault.IS_DEFAULT_YES);
        UmcQryInvoiceListBusiRspBO rspBO = this.umcQryInvoiceListBusiService.qryInvoiceList(reqBO);
        if (CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            return UmcCommConstant.InvoiceIsDefault.IS_DEFAULT_YES;
        }
        if (UmcCommConstant.InvoiceIsDefault.IS_DEFAULT_YES.equals(isDefault)) {
            UmcEditInvoiceInfoBusiReqBO umcEditInvoiceInfoBusiReqBO = new UmcEditInvoiceInfoBusiReqBO();
            BeanUtils.copyProperties(rspBO.getRows().get(0), (Object)umcEditInvoiceInfoBusiReqBO);
            umcEditInvoiceInfoBusiReqBO.setIsDefault(UmcCommConstant.InvoiceIsDefault.IS_DEFAULT_NO);
            umcEditInvoiceInfoBusiReqBO.setOperType("UPDATE");
            UmcEditInvoiceInfoBusiRspBO umcEditInvoiceInfoBusiRspBO = this.umcEditInvoiceInfoBusiService.editInvoiceInfo(umcEditInvoiceInfoBusiReqBO);
            if (!"0000".equals(umcEditInvoiceInfoBusiRspBO.getRespCode())) {
                throw new UmcBusinessException("8888", umcEditInvoiceInfoBusiRspBO.getRespDesc());
            }
            return UmcCommConstant.InvoiceIsDefault.IS_DEFAULT_YES;
        }
        return UmcCommConstant.InvoiceIsDefault.IS_DEFAULT_NO;
    }

    private void buildInvoiceInfo(ConfInvoiceTitlePO confInvoiceTitlePO, InvoiceInfoPO invoiceInfoPO) {
        invoiceInfoPO.setBankAccount(confInvoiceTitlePO.getBankAccount());
        invoiceInfoPO.setBuyerName(confInvoiceTitlePO.getBuyerName());
        invoiceInfoPO.setDepositBank(confInvoiceTitlePO.getDepositBank());
        invoiceInfoPO.setFixPhone(confInvoiceTitlePO.getFixPhone());
        invoiceInfoPO.setCompanyAddress(confInvoiceTitlePO.getCompanyAddress());
        invoiceInfoPO.setInvoiceNo(confInvoiceTitlePO.getInvoiceNo());
    }

    private void pushInvoiceInfo(InvoiceInfoPO invoiceInfoPO, List<MemberWalletImpLogPO> memberWalletImpLogPOS, Integer invoiceTitleType, UmcAddInvoiceInfoBusiReqBO reqBO, LogisticsRelaPO logisticsRelaPO) {
        BigDecimal zero = new BigDecimal(0);
        UmcExternalPushOrderInfoReqBO umcExternalPushOrderInfoReqBO = new UmcExternalPushOrderInfoReqBO();
        umcExternalPushOrderInfoReqBO.setOrderType(Integer.valueOf(2));
        umcExternalPushOrderInfoReqBO.setUserId(invoiceInfoPO.getCreateNo());
        umcExternalPushOrderInfoReqBO.setInvoiceMemo(invoiceInfoPO.getRemark());
        UmcExternalPushOrderInfoBO umcExternalPushOrderInfoBO = new UmcExternalPushOrderInfoBO();
        if (null != invoiceInfoPO.getAdmOrgId()) {
            umcExternalPushOrderInfoBO.setSupplierId(String.valueOf(invoiceInfoPO.getAdmOrgId()));
            umcExternalPushOrderInfoBO.setSupplierShopId(String.valueOf(invoiceInfoPO.getAdmOrgId()));
        }
        try {
            umcExternalPushOrderInfoBO.setOrderAmt(MoneyUtils.Long2BigDecimal((Long)invoiceInfoPO.getAmount()));
            umcExternalPushOrderInfoBO.setTotalAmt(MoneyUtils.Long2BigDecimal((Long)invoiceInfoPO.getAmount()));
            umcExternalPushOrderInfoBO.setDisAmt(zero);
        }
        catch (Exception e) {
            throw new UmcBusinessException("8888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
        }
        umcExternalPushOrderInfoBO.setInvoiceFlag(invoiceInfoPO.getInvoiceType());
        umcExternalPushOrderInfoBO.setSource(Integer.valueOf(1));
        umcExternalPushOrderInfoBO.setOrderDate(DateUtils.dateToStrLong((Date)invoiceInfoPO.getCreateTime()));
        umcExternalPushOrderInfoBO.setPurchaserId(invoiceInfoPO.getCreateNo());
        if (!StringUtils.isBlank((CharSequence)invoiceInfoPO.getCreateNo())) {
            UmcMemDetailQueryBusiReqBO umcMemDetailQueryBusiReqBO = new UmcMemDetailQueryBusiReqBO();
            umcMemDetailQueryBusiReqBO.setMemId(Long.valueOf(Long.parseLong(invoiceInfoPO.getCreateNo())));
            UmcMemDetailQueryBusiRspBO umcMemDetailQueryBusiRspBO = this.umcMemDetailQueryBusiService.memDetailQuery(umcMemDetailQueryBusiReqBO);
            if (null != umcMemDetailQueryBusiRspBO.getUmcMemDetailInfoBusiRspBO()) {
                umcExternalPushOrderInfoBO.setPurchaseName(umcMemDetailQueryBusiRspBO.getUmcMemDetailInfoBusiRspBO().getMemName2());
                umcExternalPushOrderInfoBO.setPurchaseNo(String.valueOf(umcMemDetailQueryBusiRspBO.getUmcMemDetailInfoBusiRspBO().getOrgId()));
                umcExternalPushOrderInfoBO.setPurchaseName(umcMemDetailQueryBusiRspBO.getUmcMemDetailInfoBusiRspBO().getOrgName());
                umcExternalPushOrderInfoReqBO.setUserName(umcMemDetailQueryBusiRspBO.getUmcMemDetailInfoBusiRspBO().getMemName2());
                umcExternalPushOrderInfoReqBO.setUserDeptId(String.valueOf(umcMemDetailQueryBusiRspBO.getUmcMemDetailInfoBusiRspBO().getOrgId()));
                umcExternalPushOrderInfoReqBO.setUserDeptName(umcMemDetailQueryBusiRspBO.getUmcMemDetailInfoBusiRspBO().getOrgName());
            }
        }
        umcExternalPushOrderInfoReqBO.setUmcExternalPushOrderInfoBO(umcExternalPushOrderInfoBO);
        ArrayList umcExternalPushOrderInfoItemBOS = new ArrayList();
        ArrayList originOrderInfo = new ArrayList();
        memberWalletImpLogPOS.forEach(memberWalletImpLogPO -> {
            if (null != memberWalletImpLogPO.getSuccessAmount() && memberWalletImpLogPO.getSuccessAmount() > 0L) {
                UmcExternalPushOrderInfoItemBO umcExternalPushOrderInfoItemBO = new UmcExternalPushOrderInfoItemBO();
                umcExternalPushOrderInfoItemBO.setQuantity(new BigDecimal(memberWalletImpLogPO.getSuccessCount()));
                try {
                    umcExternalPushOrderInfoItemBO.setSaleUnitPrice(MoneyUtils.Long2BigDecimal((Long)(memberWalletImpLogPO.getSuccessAmount() / (long)memberWalletImpLogPO.getSuccessCount().intValue())));
                    umcExternalPushOrderInfoItemBO.setTotalAmt(MoneyUtils.Long2BigDecimal((Long)memberWalletImpLogPO.getSuccessAmount()));
                }
                catch (Exception e) {
                    throw new UmcBusinessException("8888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                }
                umcExternalPushOrderInfoItemBO.setRedEnvelopeFee(zero);
                umcExternalPushOrderInfoItemBO.setReduceFee(zero);
                umcExternalPushOrderInfoItemBO.setActFee(zero);
                umcExternalPushOrderInfoItemBO.setItemNo(String.valueOf(memberWalletImpLogPO.getImpId()));
                umcExternalPushOrderInfoItemBO.setSkuName(memberWalletImpLogPO.getGrantTypeName());
                umcExternalPushOrderInfoItemBOS.add(umcExternalPushOrderInfoItemBO);
                UmcOriginOrderInfoBO umcOriginOrderInfoBO = new UmcOriginOrderInfoBO();
                umcOriginOrderInfoBO.setCreateTime(DateUtils.dateToStrLong((Date)memberWalletImpLogPO.getUpdateTime()));
                umcOriginOrderInfoBO.setQuantity(String.valueOf(memberWalletImpLogPO.getSuccessCount()));
                umcOriginOrderInfoBO.setTotalAmt(String.valueOf(memberWalletImpLogPO.getSuccessAmount()));
                umcOriginOrderInfoBO.setWelfareName(memberWalletImpLogPO.getRemark());
                umcOriginOrderInfoBO.setWelfareType(memberWalletImpLogPO.getGrantTypeName());
                originOrderInfo.add(JSON.toJSONString((Object)umcOriginOrderInfoBO));
            }
        });
        umcExternalPushOrderInfoReqBO.setOriginOrderInfo(originOrderInfo);
        umcExternalPushOrderInfoReqBO.setUmcExternalPushOrderInfoItemBOS(umcExternalPushOrderInfoItemBOS);
        UmcExternalPushInvoiceInfoBO umcExternalPushInvoiceInfoBO = new UmcExternalPushInvoiceInfoBO();
        umcExternalPushInvoiceInfoBO.setInvoiceType(invoiceInfoPO.getInvoiceType());
        umcExternalPushInvoiceInfoBO.setTaxNo(invoiceInfoPO.getInvoiceNo());
        umcExternalPushInvoiceInfoBO.setInvoiceName(invoiceInfoPO.getBuyerName());
        umcExternalPushInvoiceInfoBO.setInvoiceNameType(invoiceTitleType);
        umcExternalPushInvoiceInfoBO.setAddr(invoiceInfoPO.getCompanyAddress());
        umcExternalPushInvoiceInfoBO.setPhone(invoiceInfoPO.getFixPhone());
        umcExternalPushInvoiceInfoBO.setBankName(invoiceInfoPO.getDepositBank());
        umcExternalPushInvoiceInfoBO.setBankAcctNo(invoiceInfoPO.getBankAccount());
        umcExternalPushInvoiceInfoBO.setReceiveInvoiceEmail(reqBO.getReceiveInvoiceEmail());
        umcExternalPushInvoiceInfoBO.setReceiveInvoicePhone(reqBO.getReceiveInvoicePhone());
        if (null != logisticsRelaPO) {
            umcExternalPushInvoiceInfoBO.setName(logisticsRelaPO.getContactName());
            umcExternalPushInvoiceInfoBO.setProvince(logisticsRelaPO.getContactProvinceName());
            umcExternalPushInvoiceInfoBO.setCity(logisticsRelaPO.getContactCityName());
            umcExternalPushInvoiceInfoBO.setCounty(logisticsRelaPO.getContactCountyName());
            umcExternalPushInvoiceInfoBO.setTown(logisticsRelaPO.getContactTown());
            umcExternalPushInvoiceInfoBO.setAddrDesc(logisticsRelaPO.getContactAddress());
            umcExternalPushInvoiceInfoBO.setPostCode(logisticsRelaPO.getZipCode());
            umcExternalPushInvoiceInfoBO.setMobile(logisticsRelaPO.getContactMobile());
            umcExternalPushInvoiceInfoBO.setTel(logisticsRelaPO.getContactFixPhone());
            umcExternalPushInvoiceInfoBO.setRemark(logisticsRelaPO.getRemark());
        }
        umcExternalPushOrderInfoReqBO.setUmcExternalPushInvoiceInfoBO(umcExternalPushInvoiceInfoBO);
        UmcExternalPushOrderInfoRspBO umcExternalPushOrderInfoRspBO = this.fscServiceHolder.getUmcExternalPushOrderInfoService().pushOrderInfo(umcExternalPushOrderInfoReqBO);
        if (!"0000".equals(umcExternalPushOrderInfoRspBO.getRespCode())) {
            throw new UmcBusinessException(umcExternalPushOrderInfoRspBO.getRespCode(), umcExternalPushOrderInfoRspBO.getRespDesc());
        }
    }
}

