/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.umc.busi.UmcBestPayCertCacheCheckBusiService;
import com.tydic.umc.dao.EnterpriseOrgExtMapMapper;
import com.tydic.umc.po.EnterpriseOrgExtMapPO;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="umcBestPayCertCacheCheckBusiService")
public class UmcBestPayCertCacheCheckBusiServiceImpl
implements UmcBestPayCertCacheCheckBusiService {
    private static final Logger log = LoggerFactory.getLogger(UmcBestPayCertCacheCheckBusiServiceImpl.class);
    @Autowired
    private FileClient fileClient;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private EnterpriseOrgExtMapMapper enterpriseOrgExtMapMapper;
    @Value(value="${BEST_PAY_CERT_DIR}")
    private String BEST_PAY_CERT_DIR;

    public void certCacheCheck() {
        List<EnterpriseOrgExtMapPO> enterpriseOrgExtMapPOS = this.enterpriseOrgExtMapMapper.getCertOrgExtList();
        if (CollectionUtils.isEmpty(enterpriseOrgExtMapPOS)) {
            log.info("\u65e0\u6613\u652f\u4ed8\u521d\u59cb\u5316\u6570\u636e");
            return;
        }
        Integer expire = 604800;
        enterpriseOrgExtMapPOS.stream().forEach(enterpriseOrgExtMapPO -> {
            if ("BEST_PAY_CERT_PWD".equals(enterpriseOrgExtMapPO.getFieldCode())) {
                this.cacheClient.set(enterpriseOrgExtMapPO.getOrgId() + "_" + "BEST_PAY_CERT_PWD", (Object)enterpriseOrgExtMapPO.getFieldValue(), expire.intValue());
            }
            if ("BEST_PAY_AES_IV".equals(enterpriseOrgExtMapPO.getFieldCode())) {
                this.cacheClient.set(enterpriseOrgExtMapPO.getOrgId() + "_" + "BEST_PAY_AES_IV", (Object)enterpriseOrgExtMapPO.getFieldValue(), expire.intValue());
            }
            if ("BEST_PAY_MERCHANT_CODE".equals(enterpriseOrgExtMapPO.getFieldCode())) {
                this.cacheClient.set(enterpriseOrgExtMapPO.getOrgId() + "_" + "BEST_PAY_MERCHANT_CODE", (Object)enterpriseOrgExtMapPO.getFieldValue(), expire.intValue());
                this.setFileCache(this.BEST_PAY_CERT_DIR + "payCenter_3178033356440155_1.P12", enterpriseOrgExtMapPO.getOrgId() + "_" + "BEST_PAY_CERT_P12");
                this.setFileCache(this.BEST_PAY_CERT_DIR + "payCenter_3178033356440155_2.cer", enterpriseOrgExtMapPO.getOrgId() + "_" + "BEST_PAY_CERT_CER");
            }
            log.info("\u5bc6\u7801:[{}]", this.cacheClient.get(enterpriseOrgExtMapPO.getOrgId() + "_" + "BEST_PAY_CERT_PWD"));
        });
    }

    public void setFileCache(String filePath, String key) {
        File file = this.fileClient.downloadToFile(filePath);
        this.cacheClient.set(key, (Object)file);
    }
}

