/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.tydic.umc.busi.UmcChangeIntegralStateBusiService;
import com.tydic.umc.busi.bo.UmcChangeIntegralStateBusiReqBO;
import com.tydic.umc.busi.bo.UmcChangeIntegralStateBusiRspBO;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.IntegralChgLogMapper;
import com.tydic.umc.dao.IntegralMapper;
import com.tydic.umc.po.IntegralChgLogPO;
import com.tydic.umc.po.IntegralPO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcChangeIntegralStateBusiService")
public class UmcChangeIntegralStateBusiServiceImpl
implements UmcChangeIntegralStateBusiService {
    private IntegralMapper integralMapper;
    private IntegralChgLogMapper integralChgLogMapper;

    @Autowired
    public UmcChangeIntegralStateBusiServiceImpl(IntegralMapper integralMapper, IntegralChgLogMapper integralChgLogMapper) {
        this.integralMapper = integralMapper;
        this.integralChgLogMapper = integralChgLogMapper;
    }

    public UmcChangeIntegralStateBusiRspBO changeState(UmcChangeIntegralStateBusiReqBO busiReqBO) {
        UmcChangeIntegralStateBusiRspBO rsp = new UmcChangeIntegralStateBusiRspBO();
        IntegralPO integralPO = new IntegralPO();
        integralPO.setIntId(busiReqBO.getIntId());
        integralPO.setMemId(busiReqBO.getMemId());
        IntegralPO integral = this.integralMapper.getModelByCondition(integralPO);
        if (null == integral) {
            rsp.setRespCode("8888");
            rsp.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u6761\u79ef\u5206\u7ec6\u9879\uff01");
            return rsp;
        }
        if (integral.getState().equals(busiReqBO.getState())) {
            rsp.setRespCode("8888");
            rsp.setRespDesc("\u8be5\u6761\u79ef\u5206\u72b6\u6001\u5df2\u7ecf\u662f\u5c06\u53d8\u5316\u7684\u72b6\u6001\uff01");
            return rsp;
        }
        integral.setState(busiReqBO.getState());
        int isUpdate = this.integralMapper.updateByCondition(integral);
        if (isUpdate < 1) {
            throw new UmcBusinessException("6014", "\u66f4\u65b0\u79ef\u5206\u72b6\u6001\u5931\u8d25\uff01");
        }
        IntegralChgLogPO integralChgLogPO = new IntegralChgLogPO();
        BeanUtils.copyProperties((Object)integralPO, (Object)integralChgLogPO);
        integralChgLogPO.setOperResult(busiReqBO.getOperResult());
        integralChgLogPO.setOperDesc(busiReqBO.getOperDesc());
        integralChgLogPO.setOperTime(new Date());
        integralChgLogPO.setAction(UmcEnumConstant.IntegralOperCode.LOSE_EFFICACY_INTEGRAL.getCode());
        integralChgLogPO.setIntegral(integral.getIntegral());
        int isInsert = this.integralChgLogMapper.insert(integralChgLogPO);
        if (isInsert < 1) {
            throw new UmcBusinessException("6014", "\u63d2\u5165\u79ef\u5206\u65e5\u5fd7\u8868\u5931\u8d25\uff01");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4f1a\u5458\u4e2d\u5fc3\u79ef\u5206\u72b6\u6001\u6539\u53d8\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }
}

