/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.tydic.umc.atom.UmcCouponUsedRecAtomService;
import com.tydic.umc.atom.bo.UmcCouponUsedRecAtomReqBO;
import com.tydic.umc.atom.bo.UmcCouponUsedRecAtomRspBO;
import com.tydic.umc.busi.UmcCouponDedBuyBackBusiService;
import com.tydic.umc.busi.bo.UmcCouponDedBuyBackBusiReqBO;
import com.tydic.umc.busi.bo.UmcCouponDedBuyBackBusiRspBO;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.MemCouponMapper;
import com.tydic.umc.dao.MemCouponRecMapper;
import com.tydic.umc.external.act.bo.UmcExternalActCouponNoBO;
import com.tydic.umc.external.act.bo.UmcExternalCouponDedBuyBackReqBO;
import com.tydic.umc.external.act.bo.UmcExternalCouponDedBuyBackRspBO;
import com.tydic.umc.facde.AtcServiceHolder;
import com.tydic.umc.po.MemCouponPO;
import com.tydic.umc.po.MemCouponRecPO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcCouponDedBuyBackBusiService")
public class UmcCouponDedBuyBackBusiServiceImpl
implements UmcCouponDedBuyBackBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcCouponDedBuyBackBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private MemCouponMapper memCouponMapper;
    private MemCouponRecMapper memCouponRecMapper;
    private UmcCouponUsedRecAtomService umcCouponUsedRecAtomService;
    private AtcServiceHolder atcServiceHolder;

    @Autowired
    public UmcCouponDedBuyBackBusiServiceImpl(MemCouponMapper memCouponMapper, MemCouponRecMapper memCouponRecMapper, UmcCouponUsedRecAtomService umcCouponUsedRecAtomService, AtcServiceHolder atcServiceHolder) {
        this.memCouponMapper = memCouponMapper;
        this.memCouponRecMapper = memCouponRecMapper;
        this.umcCouponUsedRecAtomService = umcCouponUsedRecAtomService;
        this.atcServiceHolder = atcServiceHolder;
    }

    public UmcCouponDedBuyBackBusiRspBO couponDedBuyBack(UmcCouponDedBuyBackBusiReqBO umcCouponDedBuyBackBusiReqBO) {
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u4f1a\u5458\u4e2d\u5fc3\u4f1a\u5458\u4f18\u60e0\u5238\u62b5\u6263\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + umcCouponDedBuyBackBusiReqBO.toString());
        }
        UmcCouponDedBuyBackBusiRspBO rspBO = new UmcCouponDedBuyBackBusiRspBO();
        List<MemCouponRecPO> isBuyBackRecs = this.qryCouponRecByUsedAct(umcCouponDedBuyBackBusiReqBO, UmcEnumConstant.CouponUsedAct.BUY_BACK.getCode());
        if (isBuyBackRecs != null && isBuyBackRecs.size() > 0) {
            rspBO.setRespCode("2023");
            rspBO.setRespDesc("\u6d41\u6c34\u53f7[" + umcCouponDedBuyBackBusiReqBO.getUsedSn() + "]\u5df2\u8fd4\u9500\uff0c\u4e0d\u80fd\u518d\u6b21\u8fd4\u9500");
            return rspBO;
        }
        List<MemCouponRecPO> couponRecPOS = this.qryCouponRecByUsedAct(umcCouponDedBuyBackBusiReqBO, UmcEnumConstant.CouponUsedAct.USED.getCode());
        if (couponRecPOS == null || couponRecPOS.isEmpty()) {
            rspBO.setRespCode("2023");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6d41\u6c34\u53f7[" + umcCouponDedBuyBackBusiReqBO.getUsedSn() + "]\u7684\u4f18\u60e0\u5377\u4f7f\u7528\u8bb0\u5f55");
            return rspBO;
        }
        ArrayList<UmcExternalActCouponNoBO> umcExternalActCouponNoBOS = new ArrayList<UmcExternalActCouponNoBO>();
        rspBO = this.dealCouponBuyBack(couponRecPOS, umcExternalActCouponNoBOS);
        UmcExternalCouponDedBuyBackReqBO mcExternalCouponDedBuyBackReqBO = new UmcExternalCouponDedBuyBackReqBO();
        mcExternalCouponDedBuyBackReqBO.setCouponNoList(umcExternalActCouponNoBOS);
        mcExternalCouponDedBuyBackReqBO.setMemId(umcCouponDedBuyBackBusiReqBO.getMemId());
        mcExternalCouponDedBuyBackReqBO.setUsedSn(umcCouponDedBuyBackBusiReqBO.getUsedSn());
        mcExternalCouponDedBuyBackReqBO.setUsedSystem(umcCouponDedBuyBackBusiReqBO.getUsedSystem());
        UmcExternalCouponDedBuyBackRspBO umcExternalCouponDedBuyBackRspBO = this.atcServiceHolder.getUmcExternalCouponDedBuyBackService().couponDedBuyBack(mcExternalCouponDedBuyBackReqBO);
        if (!"0000".equals(umcExternalCouponDedBuyBackRspBO.getRespCode())) {
            throw new UmcBusinessException("2023", umcExternalCouponDedBuyBackRspBO.getRespDesc());
        }
        return rspBO;
    }

    private List<MemCouponRecPO> qryCouponRecByUsedAct(UmcCouponDedBuyBackBusiReqBO reqBO, Integer usedAct) {
        MemCouponRecPO memCouponRecModel = new MemCouponRecPO();
        memCouponRecModel.setMemId(reqBO.getMemId());
        memCouponRecModel.setUsedSystem(reqBO.getUsedSystem());
        memCouponRecModel.setUsedSn(reqBO.getUsedSn());
        memCouponRecModel.setUsedAct(usedAct);
        memCouponRecModel.setCouponNos(reqBO.getCouponNoList());
        return this.memCouponRecMapper.getListByCondition(memCouponRecModel);
    }

    private UmcCouponDedBuyBackBusiRspBO dealCouponBuyBack(List<MemCouponRecPO> couponRecPOS, List<UmcExternalActCouponNoBO> umcExternalActCouponNoBOS) {
        UmcCouponDedBuyBackBusiRspBO rspBO = new UmcCouponDedBuyBackBusiRspBO();
        for (MemCouponRecPO memCouponRecPO : couponRecPOS) {
            MemCouponPO memCouponPO = this.qryCoupon(memCouponRecPO.getMemId(), memCouponRecPO.getCouponNo());
            if (memCouponPO == null) {
                rspBO.setRespCode("2023");
                rspBO.setRespDesc("\u8fd4\u9500\u65f6\u672a\u67e5\u8be2\u5230\u4f18\u60e0\u5377[" + memCouponRecPO.getCouponNo() + "]\u7684\u4fe1\u606f");
                return rspBO;
            }
            if (UmcEnumConstant.CouponType.DEDUCTION.getCode().equals(memCouponPO.getCouponType())) {
                Integer newCouponBalance = Math.abs(memCouponRecPO.getCouponUsed()) + memCouponPO.getCouponBalance();
                if (memCouponPO.getCouponValue().compareTo(newCouponBalance) < 0) {
                    rspBO.setRespCode("2023");
                    rspBO.setRespDesc("\u8fd4\u9500\u91d1\u989d\u4e0e\u5269\u4f59\u91d1\u989d\u4e4b\u548c\u5927\u4e8e\u4f18\u60e0\u5377\u9762\u503c");
                    return rspBO;
                }
                if (memCouponPO.getCouponValue().compareTo(newCouponBalance) > 0) {
                    memCouponPO.setUsedState(UmcEnumConstant.CouponUsedState.LITTLE_USE.getCode());
                    memCouponPO.setCouponBalance(newCouponBalance);
                } else {
                    memCouponPO.setUsedState(UmcEnumConstant.CouponUsedState.NOT_USE.getCode());
                    memCouponPO.setCouponBalance(newCouponBalance);
                }
            } else {
                memCouponPO.setUsedState(UmcEnumConstant.CouponUsedState.NOT_USE.getCode());
            }
            int updateResult = this.memCouponMapper.updateByCondition(memCouponPO);
            if (updateResult < 1) {
                throw new UmcBusinessException("2020", "\u4f18\u60e0\u5377\u4f7f\u7528\u72b6\u51b5\u66f4\u65b0\u5931\u8d25");
            }
            UmcCouponUsedRecAtomRspBO umcCouponUsedRecAtomRspBO = this.addCouponUseRec(memCouponRecPO, memCouponPO);
            if (!"0000".equals(umcCouponUsedRecAtomRspBO.getRespCode())) {
                throw new UmcBusinessException(umcCouponUsedRecAtomRspBO.getRespCode(), umcCouponUsedRecAtomRspBO.getRespDesc());
            }
            UmcExternalActCouponNoBO umcExternalActCouponNoBO = new UmcExternalActCouponNoBO();
            umcExternalActCouponNoBO.setCouponNo(memCouponPO.getCouponNo());
            umcExternalActCouponNoBO.setFmId(memCouponPO.getFmId());
            umcExternalActCouponNoBOS.add(umcExternalActCouponNoBO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4f18\u60e0\u5377\u8fd4\u9500\u5904\u7406\u6210\u529f");
        return rspBO;
    }

    private MemCouponPO qryCoupon(Long memId, String couponNo) {
        MemCouponPO memCouponModel = new MemCouponPO();
        memCouponModel.setMemId(memId);
        memCouponModel.setCouponNo(couponNo);
        return this.memCouponMapper.getModelByCondition(memCouponModel);
    }

    private UmcCouponUsedRecAtomRspBO addCouponUseRec(MemCouponRecPO memCouponRecPO, MemCouponPO memCouponPO) {
        UmcCouponUsedRecAtomReqBO umcCouponUsedRecAtomReqBO = new UmcCouponUsedRecAtomReqBO();
        BeanUtils.copyProperties((Object)memCouponRecPO, (Object)umcCouponUsedRecAtomReqBO);
        umcCouponUsedRecAtomReqBO.setUsedAct(UmcEnumConstant.CouponUsedAct.BUY_BACK.getCode());
        if (memCouponRecPO.getCouponUsed() != null) {
            umcCouponUsedRecAtomReqBO.setCouponUsed(Math.abs(memCouponRecPO.getCouponUsed()));
        }
        umcCouponUsedRecAtomReqBO.setCouponBalance(memCouponPO.getCouponBalance());
        umcCouponUsedRecAtomReqBO.setUsedTime(new Date());
        umcCouponUsedRecAtomReqBO.setFmId(memCouponPO.getFmId());
        return this.umcCouponUsedRecAtomService.receiveCoupon(umcCouponUsedRecAtomReqBO);
    }
}

