/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.umc.atom.UmcCouponUsedRecAtomService;
import com.tydic.umc.atom.bo.UmcCouponUsedRecAtomReqBO;
import com.tydic.umc.atom.bo.UmcCouponUsedRecAtomRspBO;
import com.tydic.umc.busi.UmcCouponDeductionBusiService;
import com.tydic.umc.busi.bo.UmcCouponDeductionBusiReqBO;
import com.tydic.umc.busi.bo.UmcCouponDeductionBusiRspBO;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.MemCouponMapper;
import com.tydic.umc.external.act.bo.UmcExternalActCouponNoBO;
import com.tydic.umc.external.act.bo.UmcExternalCouponDeductionReqBO;
import com.tydic.umc.external.act.bo.UmcExternalCouponDeductionRspBO;
import com.tydic.umc.facde.AtcServiceHolder;
import com.tydic.umc.po.MemCouponPO;
import com.tydic.umc.util.UmcBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="umcCouponDeductionBusiService")
public class UmcCouponDeductionBusiServiceImpl
implements UmcCouponDeductionBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcCouponDeductionBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private MemCouponMapper memCouponMapper;
    private UmcCouponUsedRecAtomService umcCouponUsedRecAtomService;
    private AtcServiceHolder atcServiceHolder;

    @Autowired
    public UmcCouponDeductionBusiServiceImpl(MemCouponMapper memCouponMapper, UmcCouponUsedRecAtomService umcCouponUsedRecAtomService, AtcServiceHolder atcServiceHolder) {
        this.memCouponMapper = memCouponMapper;
        this.umcCouponUsedRecAtomService = umcCouponUsedRecAtomService;
        this.atcServiceHolder = atcServiceHolder;
    }

    public UmcCouponDeductionBusiRspBO couponDeduction(UmcCouponDeductionBusiReqBO umcCouponDeductionBusiReqBO) {
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u4f1a\u5458\u4e2d\u5fc3\u4f1a\u5458\u4f18\u60e0\u5238\u62b5\u6263\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + umcCouponDeductionBusiReqBO.toString());
        }
        UmcCouponDeductionBusiRspBO rspBO = new UmcCouponDeductionBusiRspBO();
        List<MemCouponPO> memCouponPOS = this.qryCoupon(umcCouponDeductionBusiReqBO);
        if (CollectionUtils.isEmpty(memCouponPOS) || memCouponPOS.size() != umcCouponDeductionBusiReqBO.getCouponNoList().size()) {
            rspBO.setRespCode("2020");
            rspBO.setRespDesc("\u4f18\u60e0\u5238\u4e0d\u5b58\u6216\u8005\u5df2\u8fc7\u671f");
            return rspBO;
        }
        ArrayList umcExternalActCouponNoBOS = new ArrayList();
        ArrayList<Integer> oldUsedStateList = new ArrayList<Integer>();
        oldUsedStateList.add(UmcEnumConstant.CouponUsedState.NOT_USE.getCode());
        oldUsedStateList.add(UmcEnumConstant.CouponUsedState.LITTLE_USE.getCode());
        memCouponPOS.forEach(memCouponPO -> {
            memCouponPO.setOldUsedStateList(oldUsedStateList);
            UmcCouponDeductionBusiRspBO umcCouponDeductionBusiRspBO = this.usedCoupon((MemCouponPO)memCouponPO, umcCouponDeductionBusiReqBO);
            if (!"0000".equals(umcCouponDeductionBusiRspBO.getRespCode())) {
                throw new UmcBusinessException("2020", umcCouponDeductionBusiRspBO.getRespDesc());
            }
            UmcExternalActCouponNoBO umcExternalActCouponNoBO = new UmcExternalActCouponNoBO();
            umcExternalActCouponNoBO.setCouponNo(memCouponPO.getCouponNo());
            umcExternalActCouponNoBO.setFmId(memCouponPO.getFmId());
            umcExternalActCouponNoBOS.add(umcExternalActCouponNoBO);
        });
        UmcExternalCouponDeductionReqBO umcExternalCouponDeductionReqBO = new UmcExternalCouponDeductionReqBO();
        umcExternalCouponDeductionReqBO.setCouponNoList(umcExternalActCouponNoBOS);
        umcExternalCouponDeductionReqBO.setDeductionMoney(umcCouponDeductionBusiReqBO.getDeductionMoney().toString());
        umcExternalCouponDeductionReqBO.setMemId(umcCouponDeductionBusiReqBO.getMemId());
        umcExternalCouponDeductionReqBO.setUsedSn(umcCouponDeductionBusiReqBO.getUsedSn());
        umcExternalCouponDeductionReqBO.setUsedSystem(umcCouponDeductionBusiReqBO.getUsedSystem());
        umcExternalCouponDeductionReqBO.setUsedTime(umcCouponDeductionBusiReqBO.getUsedTime());
        UmcExternalCouponDeductionRspBO umcExternalCouponDeductionRspBO = this.atcServiceHolder.getUmcExternalCouponDeductionService().couponDeduction(umcExternalCouponDeductionReqBO);
        if (!"0000".equals(umcExternalCouponDeductionRspBO.getRespCode())) {
            throw new UmcBusinessException("2020", umcExternalCouponDeductionRspBO.getRespDesc());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<MemCouponPO> qryCoupon(UmcCouponDeductionBusiReqBO reqBO) {
        MemCouponPO memCouponPO = new MemCouponPO();
        memCouponPO.setMemId(reqBO.getMemId());
        memCouponPO.setCouponNoList(reqBO.getCouponNoList());
        return this.memCouponMapper.getListByDeduction(memCouponPO);
    }

    private UmcCouponDeductionBusiRspBO validCouponState(MemCouponPO memCouponPO) {
        UmcCouponDeductionBusiRspBO rspBO = new UmcCouponDeductionBusiRspBO();
        Date currentSystemTime = new Date();
        if (currentSystemTime.compareTo(memCouponPO.getExpTime()) > 0 || !UmcEnumConstant.CouponUsedState.NOT_USE.getCode().equals(memCouponPO.getUsedState()) && !UmcEnumConstant.CouponUsedState.LITTLE_USE.getCode().equals(memCouponPO.getUsedState())) {
            rspBO.setRespCode("2020");
            rspBO.setRespDesc("\u4f18\u60e0\u5377[" + memCouponPO.getCouponNo() + "]\u4e0d\u53ef\u7528");
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u4f18\u60e0\u5377\u53ef\u7528\u4f7f\u7528");
        }
        return rspBO;
    }

    private UmcCouponDeductionBusiRspBO usedCoupon(MemCouponPO memCouponPO, UmcCouponDeductionBusiReqBO reqBO) {
        UmcCouponDeductionBusiRspBO rspBO = new UmcCouponDeductionBusiRspBO();
        if (UmcEnumConstant.CouponType.DEDUCTION.getCode().equals(memCouponPO.getCouponType())) {
            Integer deductionMoney;
            if (reqBO.getDeductionMoney() == null) {
                rspBO.setRespCode("2020");
                rspBO.setRespDesc("\u6298\u6263\u7c7b\u578b\u4f18\u60e0\u5377\u7684\u5f53\u524d\u62b5\u6263\u91d1\u989d\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            try {
                deductionMoney = MoneyUtils.BigDecimal2Long((BigDecimal)reqBO.getDeductionMoney()).intValue();
            }
            catch (Exception e) {
                LOGGER.error("\u4f18\u60e0\u5377\u62b5\u6263\u91d1\u989d\u8f6c\u6362\u51fa\u9519");
                rspBO.setRespCode("2020");
                rspBO.setRespDesc("\u4f18\u60e0\u5377\u62b5\u6263\u91d1\u989d\u8f6c\u6362\u51fa\u9519");
                return rspBO;
            }
            Integer remainMoney = memCouponPO.getCouponBalance() - deductionMoney;
            if (remainMoney < 0) {
                rspBO.setRespCode("2020");
                rspBO.setRespDesc("\u4f18\u60e0\u5377\u5269\u4f59\u62b5\u6263\u91d1\u989d\u4e0d\u8db3\u4ee5\u62b5\u6263\u5f53\u524d\u91d1\u989d");
                return rspBO;
            }
            if (remainMoney > 0) {
                memCouponPO.setUsedState(UmcEnumConstant.CouponUsedState.LITTLE_USE.getCode());
                memCouponPO.setCouponBalance(remainMoney);
            } else {
                memCouponPO.setUsedState(UmcEnumConstant.CouponUsedState.USED.getCode());
                memCouponPO.setCouponBalance(remainMoney);
            }
        } else {
            memCouponPO.setUsedState(UmcEnumConstant.CouponUsedState.USED.getCode());
        }
        int updateResult = this.memCouponMapper.updateByCondition(memCouponPO);
        if (updateResult < 1) {
            rspBO.setRespCode("2020");
            rspBO.setRespDesc("\u4f18\u60e0\u5377\u4f7f\u7528\u72b6\u51b5\u66f4\u65b0\u5931\u8d25");
            return rspBO;
        }
        UmcCouponUsedRecAtomRspBO umcCouponUsedRecAtomRspBO = this.addCouponUseRec(reqBO, memCouponPO);
        if (!"0000".equals(umcCouponUsedRecAtomRspBO.getRespCode())) {
            BeanUtils.copyProperties((Object)((Object)umcCouponUsedRecAtomRspBO), (Object)rspBO);
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4f18\u60e0\u5377\u4f7f\u7528\u6210\u529f");
        return rspBO;
    }

    private UmcCouponUsedRecAtomRspBO addCouponUseRec(UmcCouponDeductionBusiReqBO reqBO, MemCouponPO memCouponPO) {
        UmcCouponUsedRecAtomReqBO umcCouponUsedRecAtomReqBO = new UmcCouponUsedRecAtomReqBO();
        umcCouponUsedRecAtomReqBO.setMemId(reqBO.getMemId());
        umcCouponUsedRecAtomReqBO.setCouponNo(memCouponPO.getCouponNo());
        if (reqBO.getDeductionMoney() != null) {
            try {
                umcCouponUsedRecAtomReqBO.setCouponUsed(-MoneyUtils.BigDecimal2Long((BigDecimal)reqBO.getDeductionMoney()).intValue());
            }
            catch (Exception e) {
                throw new UmcBusinessException("2020", "\u8f6c\u6362\u4f18\u60e0\u5377\u4f7f\u7528\u91cf\u65f6\u51fa\u9519");
            }
        }
        umcCouponUsedRecAtomReqBO.setCouponBalance(memCouponPO.getCouponBalance());
        umcCouponUsedRecAtomReqBO.setUsedAct(UmcEnumConstant.CouponUsedAct.USED.getCode());
        umcCouponUsedRecAtomReqBO.setUsedSn(reqBO.getUsedSn());
        umcCouponUsedRecAtomReqBO.setUsedSystem(reqBO.getUsedSystem());
        umcCouponUsedRecAtomReqBO.setOrderId(reqBO.getOrderId());
        umcCouponUsedRecAtomReqBO.setFmId(memCouponPO.getFmId());
        if (null != reqBO.getOrderFee()) {
            try {
                umcCouponUsedRecAtomReqBO.setOrderFee(MoneyUtils.BigDecimal2Long((BigDecimal)reqBO.getOrderFee()).intValue());
            }
            catch (Exception e) {
                throw new UmcBusinessException("2020", "\u8f6c\u6362\u4f18\u60e0\u5377\u8ba2\u5355\u603b\u91d1\u989d\u51fa\u9519");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getUsedTime())) {
            umcCouponUsedRecAtomReqBO.setUsedTime(DateUtils.strToDateLong((String)reqBO.getUsedTime()));
        }
        return this.umcCouponUsedRecAtomService.receiveCoupon(umcCouponUsedRecAtomReqBO);
    }
}

