/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.tydic.umc.busi.UmcCreateQrBusiService;
import com.tydic.umc.busi.bo.UmcCreateQrBusiReqBO;
import com.tydic.umc.busi.bo.UmcCreateQrBusiRspBO;
import com.tydic.umc.dao.LoginQrMapper;
import com.tydic.umc.po.LoginQrPO;
import com.tydic.umc.util.HexadecimalUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="umcCreateQrBusiService")
public class UmcCreateQrBusiServiceImpl
implements UmcCreateQrBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(UmcCreateQrBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOG.isDebugEnabled();
    private Date createTime;
    private Date expTime;
    @Value(value="${qrExpTime}")
    private Integer effectiveTime;
    @Autowired
    private LoginQrMapper loginQrMapper;

    public UmcCreateQrBusiRspBO createQr(UmcCreateQrBusiReqBO reqBO) {
        UmcCreateQrBusiRspBO rspBO = new UmcCreateQrBusiRspBO();
        this.createTime = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.createTime);
        calendar.add(12, this.effectiveTime);
        this.expTime = calendar.getTime();
        String expStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.expTime);
        String unencryptedQrStr = reqBO.getMemId() + "#" + expStr;
        String encryptedQrStr = HexadecimalUtils.stringToFixHex16String(unencryptedQrStr);
        if (StringUtils.isBlank((CharSequence)encryptedQrStr)) {
            rspBO.setRespCode("2051");
            rspBO.setRespDesc("\u4e8c\u7ef4\u7801\u4fe1\u606f\u751f\u6210\u5931\u8d25");
            return rspBO;
        }
        LoginQrPO loginQrPO = new LoginQrPO();
        loginQrPO.setCreateTime(this.createTime);
        loginQrPO.setExpTime(this.expTime);
        loginQrPO.setQrCode(encryptedQrStr);
        loginQrPO.setMemId(reqBO.getMemId());
        int result = this.loginQrMapper.insert(loginQrPO);
        if (result < 1) {
            if (IS_DEBUGABLE) {
                LOG.debug("\u4e8c\u7ef4\u7801\u4fe1\u606f\u5165\u5e93\u65f6\uff0c\u6570\u636e\u5e93\u5f02\u5e38");
            }
            rspBO.setRespCode("2052");
            rspBO.setRespDesc("\u4e8c\u7ef4\u7801\u4fe1\u606f\u5165\u5e93\u5931\u8d25");
        }
        rspBO.setQrStr(encryptedQrStr);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4e8c\u7ef4\u7801\u751f\u6210\u6210\u529f");
        return rspBO;
    }
}

