/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.umc.busi.UmcEnterpriseBalanceSummaryBusiService;
import com.tydic.umc.busi.bo.UmcEnterpriseBalanceSummaryBusiReqBO;
import com.tydic.umc.busi.bo.UmcEnterpriseBalanceSummaryBusiRspBO;
import com.tydic.umc.common.UmcEnterpriseOrgBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.dao.EnterpriseAccountBalanceMapper;
import com.tydic.umc.dao.EnterpriseOrgMapper;
import com.tydic.umc.dao.MemberWalletChngLogMapper;
import com.tydic.umc.dao.MemberWalletMapper;
import com.tydic.umc.po.EnterpriseAccountBalancePO;
import com.tydic.umc.po.EnterpriseOrgPO;
import com.tydic.umc.po.MemberWalletChngLogPO;
import com.tydic.umc.po.MemberWalletPO;
import com.tydic.umc.util.UmcBusinessException;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcEnterpriseBalanceSummaryBusiService")
public class UmcEnterpriseBalanceSummaryBusiServiceImpl
implements UmcEnterpriseBalanceSummaryBusiService {
    private static final Logger log = LoggerFactory.getLogger(UmcEnterpriseBalanceSummaryBusiServiceImpl.class);
    @Autowired
    private EnterpriseOrgMapper enterpriseOrgMapper;
    @Autowired
    private EnterpriseAccountBalanceMapper enterpriseAccountBalanceMapper;
    @Autowired
    private MemberWalletChngLogMapper memberWalletChngLogMapper;
    @Autowired
    private MemberWalletMapper memberWalletMapper;

    public UmcEnterpriseBalanceSummaryBusiRspBO orgBalanceSummary(UmcEnterpriseBalanceSummaryBusiReqBO reqBO) {
        UmcEnterpriseBalanceSummaryBusiRspBO rspBO = new UmcEnterpriseBalanceSummaryBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        EnterpriseOrgPO enterpriseOrgPO = new EnterpriseOrgPO();
        enterpriseOrgPO.setOrgCode(reqBO.getOrgCode());
        UmcEnterpriseOrgBO umcEnterpriseOrgBO = this.enterpriseOrgMapper.getModelBy(enterpriseOrgPO);
        if (null == umcEnterpriseOrgBO) {
            throw new UmcBusinessException("8888", "\u673a\u6784\u4e0d\u5b58\u5728");
        }
        BigDecimal balance = new BigDecimal(0);
        EnterpriseAccountBalancePO enterpriseAccountBalancePO = new EnterpriseAccountBalancePO();
        enterpriseAccountBalancePO.setOrgId(umcEnterpriseOrgBO.getOrgId());
        enterpriseAccountBalancePO.setBalanceType(UmcCommConstant.EnterpriseBalanceType.ADVANCE_DEPOSIT);
        enterpriseAccountBalancePO = this.enterpriseAccountBalanceMapper.getModelBy(enterpriseAccountBalancePO);
        if (null == enterpriseAccountBalancePO || null == enterpriseAccountBalancePO.getBalance()) {
            rspBO.setBalance(balance);
            rspBO.setUsedAmout(balance);
            rspBO.setNotUsedAmount(balance);
            return rspBO;
        }
        try {
            rspBO.setBalance(MoneyUtils.Long2BigDecimal((Long)enterpriseAccountBalancePO.getBalance()));
        }
        catch (Exception e) {
            log.error("\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
            throw new UmcBusinessException("8888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
        }
        MemberWalletChngLogPO memberWalletChngLogPO = new MemberWalletChngLogPO();
        memberWalletChngLogPO.setAdmOrgId(umcEnterpriseOrgBO.getOrgId());
        memberWalletChngLogPO.setWalletType(UmcCommConstant.WALLET_TYPE.BALANCE);
        memberWalletChngLogPO = this.memberWalletChngLogMapper.qryChngSumByOrg(memberWalletChngLogPO);
        if (null == memberWalletChngLogPO || null == memberWalletChngLogPO.getChngAmount()) {
            rspBO.setUsedAmout(balance);
            rspBO.setNotUsedAmount(balance);
            return rspBO;
        }
        try {
            rspBO.setUsedAmout(MoneyUtils.Long2BigDecimal((Long)memberWalletChngLogPO.getChngAmount()));
        }
        catch (Exception e) {
            log.error("\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
            throw new UmcBusinessException("8888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
        }
        MemberWalletPO memberWalletPO = new MemberWalletPO();
        memberWalletPO.setAdmOrgId(umcEnterpriseOrgBO.getOrgId());
        memberWalletPO.setWalletType(UmcCommConstant.WALLET_TYPE.BALANCE);
        memberWalletPO = this.memberWalletMapper.qryOrgWalletBalanceSum(memberWalletPO);
        if (null == memberWalletPO || null == memberWalletPO.getBalanceSum()) {
            rspBO.setNotUsedAmount(balance);
            return rspBO;
        }
        try {
            rspBO.setNotUsedAmount(MoneyUtils.Long2BigDecimal((Long)memberWalletPO.getBalanceSum()));
        }
        catch (Exception e) {
            log.error("\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
            throw new UmcBusinessException("8888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
        }
        return rspBO;
    }
}

