/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.umc.busi.UmcAddEnterpriseAccountBalanceChngLogBusiService;
import com.tydic.umc.busi.UmcEnterpriseRechargeBusiService;
import com.tydic.umc.busi.bo.UmcAddEnterpriseAccountBalanceChngLogBusiReqBO;
import com.tydic.umc.busi.bo.UmcAddEnterpriseAccountBalanceChngLogBusiRspBO;
import com.tydic.umc.busi.bo.UmcEnterpriseRechargeBusiReqBO;
import com.tydic.umc.busi.bo.UmcEnterpriseRechargeBusiRspBO;
import com.tydic.umc.common.UmcEnterpriseOrgBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.EnterpriseAccountBalanceChngLogDAO;
import com.tydic.umc.dao.EnterpriseAccountBalanceMapper;
import com.tydic.umc.dao.EnterpriseOrgMapper;
import com.tydic.umc.external.pay.bo.UmcExternalPayCenterQryStatusEncryptReqBO;
import com.tydic.umc.external.pay.bo.UmcExternalPayCenterQryStatusEncryptRspBO;
import com.tydic.umc.external.pay.bo.UmcExternalPayCenterUniOrderEncryptReqBO;
import com.tydic.umc.external.pay.bo.UmcExternalPayCenterUniOrderEncryptRspBO;
import com.tydic.umc.facde.PayServiceHolder;
import com.tydic.umc.po.EnterpriseAccountBalanceChngLogPO;
import com.tydic.umc.po.EnterpriseAccountBalancePO;
import com.tydic.umc.util.UmcBusinessException;
import com.tydic.umc.util.Utils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="umcEnterpriseRechargeBusiService")
public class UmcEnterpriseRechargeBusiServiceImpl
implements UmcEnterpriseRechargeBusiService {
    private static final Logger log = LoggerFactory.getLogger(UmcEnterpriseRechargeBusiServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcEnterpriseRechargeBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Autowired
    private EnterpriseAccountBalanceMapper enterpriseAccountBalanceMapper;
    @Autowired
    private EnterpriseAccountBalanceChngLogDAO enterpriseAccountBalanceChngLogMapper;
    @Autowired
    private UmcAddEnterpriseAccountBalanceChngLogBusiService umcAddEnterpriseAccountBalanceChngLogBusiService;
    @Autowired
    private EnterpriseOrgMapper enterpriseOrgMapper;
    @Autowired
    private PayServiceHolder payServiceHolder;

    public UmcEnterpriseRechargeBusiRspBO enterpriseRecharge(UmcEnterpriseRechargeBusiReqBO reqBO) {
        Long accountId;
        String paySn;
        UmcEnterpriseRechargeBusiRspBO rspBO = new UmcEnterpriseRechargeBusiRspBO();
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        Long amount = null;
        try {
            amount = MoneyUtils.BigDecimal2Long((BigDecimal)reqBO.getAmount());
        }
        catch (Exception e) {
            LOGGER.error("\u91d1\u94b1\u8f6c\u6362\u5f02\u5e38:{}", (Object)e.getMessage());
            throw new UmcBusinessException("8888", "\u91d1\u94b1\u8f6c\u6362\u5f02\u5e38");
        }
        List<EnterpriseAccountBalancePO> enterpriseAccountBalancePOS = null;
        if (!UmcCommConstant.OrgRechargeServiceOperType.CALL_BACK_RECHARGE_UPDATE_STATUS.equals(reqBO.getOperType())) {
            EnterpriseAccountBalancePO enterpriseAccountBalancePO = new EnterpriseAccountBalancePO();
            enterpriseAccountBalancePO.setOrgId(reqBO.getOrgId());
            enterpriseAccountBalancePO.setBalanceType(reqBO.getBalanceType());
            enterpriseAccountBalancePOS = this.enterpriseAccountBalanceMapper.getList(enterpriseAccountBalancePO);
        }
        if (UmcCommConstant.OrgRechargeServiceOperType.CERATE_CODE.equals(reqBO.getOperType())) {
            boolean isReOrder = false;
            paySn = reqBO.getPaySn();
            if (!StringUtils.isBlank((CharSequence)paySn)) {
                EnterpriseAccountBalanceChngLogPO orgPayLogPO = this.getOrgPayLog(reqBO.getPaySn(), reqBO.getOrgId());
                if (null == orgPayLogPO || StringUtils.isBlank((CharSequence)orgPayLogPO.getPaySn())) {
                    paySn = String.valueOf(Sequence.getInstance().nextId());
                } else {
                    if (null == orgPayLogPO.getPayStatus() || !UmcCommConstant.PayStatus.DEALING.equals(orgPayLogPO.getPayStatus())) {
                        throw new UmcBusinessException("8888", "\u8ba2\u5355\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355\u5145\u503c");
                    }
                    paySn = orgPayLogPO.getPaySn();
                    isReOrder = true;
                }
            } else {
                paySn = String.valueOf(Sequence.getInstance().nextId());
            }
            UmcExternalPayCenterUniOrderEncryptReqBO umcExternalPayCenterUniOrderEncryptReqBO = new UmcExternalPayCenterUniOrderEncryptReqBO();
            umcExternalPayCenterUniOrderEncryptReqBO.setDetail("\u4f01\u4e1a\u5145\u503c:{orgId:\"" + reqBO.getOrgId() + "\"}");
            try {
                BigDecimal bd = new BigDecimal("100");
                umcExternalPayCenterUniOrderEncryptReqBO.setPayAmount(String.valueOf(reqBO.getAmount().multiply(bd).longValue()));
            }
            catch (Exception var3) {
                throw new UmcBusinessException("8888", "\u91d1\u94b1\u8f6c\u6362\u5f02\u5e38");
            }
            umcExternalPayCenterUniOrderEncryptReqBO.setPaySn(paySn);
            umcExternalPayCenterUniOrderEncryptReqBO.setReqWay("1");
            umcExternalPayCenterUniOrderEncryptReqBO.setIp(reqBO.getIp());
            umcExternalPayCenterUniOrderEncryptReqBO.setOrgId(reqBO.getOrgId().toString());
            umcExternalPayCenterUniOrderEncryptReqBO.setRedirectUrl(reqBO.getRedirectUrl() + "&paySn=" + paySn);
            UmcExternalPayCenterUniOrderEncryptRspBO umcExternalPayCenterUniOrderEncryptRspBO = this.payServiceHolder.getUmcExternalPayCenterUniOrderEncryptService().payCenterUniOrder(umcExternalPayCenterUniOrderEncryptReqBO);
            if (!"0000".equals(umcExternalPayCenterUniOrderEncryptRspBO.getRespCode()) || StringUtils.isBlank((CharSequence)umcExternalPayCenterUniOrderEncryptRspBO.getQrCodeUrl())) {
                throw new UmcBusinessException("8888", "\u652f\u4ed8\u4e2d\u5fc3\u83b7\u53d6\u652f\u4ed8\u7801\u5f02\u5e38");
            }
            Long accountId2 = null;
            if (CollectionUtils.isEmpty(enterpriseAccountBalancePOS)) {
                accountId2 = Sequence.getInstance().nextId();
                this.addEnterpriseBalance(accountId2, 0L, reqBO);
            } else {
                accountId2 = enterpriseAccountBalancePOS.get(0).getAccountId();
            }
            reqBO.setPaySn(paySn);
            reqBO.setBusiType(UmcCommConstant.OrgRechargeBusiType.RECHARGE);
            if (!isReOrder) {
                this.writeChngLog(accountId2, amount, reqBO, UmcCommConstant.PayStatus.DEALING);
            }
            rspBO.setCodeUrl(umcExternalPayCenterUniOrderEncryptRspBO.getQrCodeUrl());
            rspBO.setPaySn(paySn);
            rspBO.setPayStatus(UmcCommConstant.PayStatus.DEALING);
            reqBO.setPaySn(paySn);
        }
        if (UmcCommConstant.OrgRechargeServiceOperType.BANK_TRANSFER.equals(reqBO.getOperType())) {
            accountId = null;
            if (CollectionUtils.isEmpty(enterpriseAccountBalancePOS)) {
                accountId = Sequence.getInstance().nextId();
                this.addEnterpriseBalance(accountId, 0L, reqBO);
            } else {
                accountId = enterpriseAccountBalancePOS.get(0).getAccountId();
            }
            paySn = String.valueOf(Sequence.getInstance().nextId());
            reqBO.setBusiType(UmcCommConstant.OrgRechargeBusiType.RECHARGE);
            reqBO.setPayType(UmcCommConstant.PayType.BANK);
            rspBO.setPaySn(paySn);
            reqBO.setPaySn(paySn);
            this.writeChngLog(accountId, amount, reqBO, UmcCommConstant.PayStatus.WAIT_APPROVE);
        }
        if (UmcCommConstant.OrgRechargeServiceOperType.RECHARGE.equals(reqBO.getOperType())) {
            reqBO.setPayStatus(UmcCommConstant.PayStatus.FINISH);
            reqBO.setPaySn(String.valueOf(Sequence.getInstance().nextId()));
            if (CollectionUtils.isEmpty(enterpriseAccountBalancePOS)) {
                accountId = Sequence.getInstance().nextId();
                this.addEnterpriseBalance(accountId, amount, reqBO);
                this.writeChngLog(accountId, amount, reqBO, UmcCommConstant.PayStatus.FINISH);
                rspBO.setPaySn(reqBO.getPaySn());
                return rspBO;
            }
            this.updateEnterpriseBalance(amount, enterpriseAccountBalancePOS.get(0), reqBO);
            this.writeChngLog(enterpriseAccountBalancePOS.get(0).getAccountId(), amount, reqBO, UmcCommConstant.PayStatus.FINISH);
            rspBO.setPayStatus(UmcCommConstant.PayStatus.FINISH);
        }
        if (UmcCommConstant.OrgRechargeServiceOperType.RECHARGE_UPDATE_STATUS.equals(reqBO.getOperType()) || UmcCommConstant.OrgRechargeServiceOperType.CALL_BACK_RECHARGE_UPDATE_STATUS.equals(reqBO.getOperType()) || UmcCommConstant.OrgRechargeServiceOperType.APPROVED_PASS.equals(reqBO.getOperType())) {
            EnterpriseAccountBalanceChngLogPO orgPayLogPO = this.getOrgPayLog(reqBO.getPaySn(), reqBO.getOrgId());
            if (null == orgPayLogPO || StringUtils.isBlank((CharSequence)orgPayLogPO.getPaySn())) {
                throw new UmcBusinessException("8888", "\u652f\u4ed8\u6d41\u6c34\u53f7\u4e0d\u5b58\u5728");
            }
            if (UmcCommConstant.PayStatus.FINISH.equals(orgPayLogPO.getPayStatus()) || UmcCommConstant.PayStatus.FAIL.equals(orgPayLogPO.getPayStatus())) {
                rspBO.setPayStatus(orgPayLogPO.getPayStatus());
                rspBO.setPaySn(orgPayLogPO.getPaySn());
                rspBO.setPayType(orgPayLogPO.getPayType());
                rspBO.setPayNotifyTransId(orgPayLogPO.getPayNotifyTransId());
                return rspBO;
            }
            if (UmcCommConstant.PayStatus.DEALING.equals(orgPayLogPO.getPayStatus())) {
                if (UmcCommConstant.OrgRechargeServiceOperType.RECHARGE_UPDATE_STATUS.equals(reqBO.getOperType())) {
                    UmcExternalPayCenterQryStatusEncryptReqBO umcExternalPayCenterQryStatusEncryptReqBO = new UmcExternalPayCenterQryStatusEncryptReqBO();
                    umcExternalPayCenterQryStatusEncryptReqBO.setPaySn(orgPayLogPO.getPaySn());
                    UmcExternalPayCenterQryStatusEncryptRspBO umcExternalPayCenterQryStatusEncryptRspBO = this.payServiceHolder.getUmcExternalPayCenterQryStatusEncryptService().payCenterQryStatus(umcExternalPayCenterQryStatusEncryptReqBO);
                    if (!"0000".equals(umcExternalPayCenterQryStatusEncryptRspBO.getRespCode())) {
                        throw new UmcBusinessException("8888", "\u652f\u4ed8\u4e2d\u5fc3\u8fd4\u56de\u5931\u8d25");
                    }
                    String payStatus = umcExternalPayCenterQryStatusEncryptRspBO.getPayStatus();
                    if (!UmcEnumConstant.PayCenterPayStatus.SUCCESS.getCode().equals(payStatus)) {
                        if (UmcEnumConstant.PayCenterPayStatus.FAIL.getCode().equals(payStatus)) {
                            rspBO.setPayStatus(UmcCommConstant.PayStatus.DEALING);
                        }
                        if (UmcEnumConstant.PayCenterPayStatus.PAYING.getCode().equals(payStatus)) {
                            rspBO.setPayStatus(UmcCommConstant.PayStatus.DEALING);
                        }
                        if (UmcEnumConstant.PayCenterPayStatus.CLOSED.getCode().equals(payStatus)) {
                            orgPayLogPO.setPayStatus(UmcCommConstant.PayStatus.FAIL);
                            orgPayLogPO.setPayType(Utils.getPayType(umcExternalPayCenterQryStatusEncryptRspBO.getPayMethod()));
                            this.updatePayStatus(orgPayLogPO);
                            rspBO.setPayStatus(UmcCommConstant.PayStatus.FAIL);
                        }
                        rspBO.setPaySn(orgPayLogPO.getPaySn());
                        rspBO.setRespDesc(umcExternalPayCenterQryStatusEncryptRspBO.getPayStatusMsg());
                        rspBO.setRespCode("0000");
                        return rspBO;
                    }
                    orgPayLogPO.setPayNotifyTransId(umcExternalPayCenterQryStatusEncryptRspBO.getPayNotifyTransId());
                    orgPayLogPO.setPayType(Utils.getPayType(umcExternalPayCenterQryStatusEncryptRspBO.getPayMethod()));
                    orgPayLogPO.setPayStatus(UmcCommConstant.PayStatus.FINISH);
                }
                if (UmcCommConstant.OrgRechargeServiceOperType.CALL_BACK_RECHARGE_UPDATE_STATUS.equals(reqBO.getOperType())) {
                    orgPayLogPO.setPayType(reqBO.getPayType());
                    orgPayLogPO.setPayStatus(reqBO.getPayStatus());
                    orgPayLogPO.setPayNotifyTransId(reqBO.getPayNotifyTransId());
                    EnterpriseAccountBalancePO enterpriseAccountBalancePO = new EnterpriseAccountBalancePO();
                    enterpriseAccountBalancePO.setOrgId(orgPayLogPO.getOrgId());
                    enterpriseAccountBalancePO.setBalanceType(orgPayLogPO.getBalanceType());
                    enterpriseAccountBalancePOS = this.enterpriseAccountBalanceMapper.getList(enterpriseAccountBalancePO);
                }
                if (CollectionUtils.isEmpty(enterpriseAccountBalancePOS)) {
                    Long accountId3 = Sequence.getInstance().nextId();
                    this.addEnterpriseBalance(accountId3, amount, reqBO);
                } else {
                    this.updateEnterpriseBalance(amount, enterpriseAccountBalancePOS.get(0), reqBO);
                }
                orgPayLogPO.setPayTime(reqBO.getPayTime());
                this.updatePayStatus(orgPayLogPO);
            }
            if (UmcCommConstant.PayStatus.WAIT_APPROVE.equals(orgPayLogPO.getPayStatus())) {
                if (UmcCommConstant.PayStatus.FINISH.equals(reqBO.getPayStatus())) {
                    reqBO.setRechargeType(Integer.valueOf(1));
                    this.updateEnterpriseBalance(orgPayLogPO.getChngAmount(), enterpriseAccountBalancePOS.get(0), reqBO);
                }
                orgPayLogPO.setPayStatus(reqBO.getPayStatus());
                this.updatePayStatus(orgPayLogPO);
                rspBO.setPayStatus(orgPayLogPO.getPayStatus());
                rspBO.setPaySn(orgPayLogPO.getPaySn());
            }
            if (UmcCommConstant.PayStatus.FINISH.equals(orgPayLogPO.getPayStatus())) {
                rspBO.setPayStatus(UmcCommConstant.PayStatus.FINISH);
                rspBO.setPaySn(orgPayLogPO.getPaySn());
                rspBO.setPayType(orgPayLogPO.getPayType());
                rspBO.setPayNotifyTransId(orgPayLogPO.getPayNotifyTransId());
            }
        }
        return rspBO;
    }

    private void addEnterpriseBalance(Long accountId, Long balance, UmcEnterpriseRechargeBusiReqBO reqBO) {
        EnterpriseAccountBalancePO enterpriseAccountBalancePO = new EnterpriseAccountBalancePO();
        enterpriseAccountBalancePO.setOrgId(reqBO.getOrgId());
        enterpriseAccountBalancePO.setAccountId(accountId);
        enterpriseAccountBalancePO.setBalance(balance);
        enterpriseAccountBalancePO.setUsedAmount(0L);
        enterpriseAccountBalancePO.setCreateTime(new Date());
        enterpriseAccountBalancePO.setBalanceType(reqBO.getBalanceType());
        enterpriseAccountBalancePO.setBalanceMini(0L);
        enterpriseAccountBalancePO.setWarnFlag(0);
        int result = this.enterpriseAccountBalanceMapper.insert(enterpriseAccountBalancePO);
        if (result < 1) {
            throw new UmcBusinessException("8888", "\u4f01\u4e1a\u5145\u503c\u5931\u8d25");
        }
    }

    private void updateEnterpriseBalance(Long balance, EnterpriseAccountBalancePO po, UmcEnterpriseRechargeBusiReqBO reqBO) {
        int result;
        EnterpriseAccountBalancePO enterpriseAccountBalancePO = new EnterpriseAccountBalancePO();
        enterpriseAccountBalancePO.setOrgId(po.getOrgId());
        enterpriseAccountBalancePO.setBalance(balance);
        enterpriseAccountBalancePO.setNewBalance(po.getBalance() + balance);
        enterpriseAccountBalancePO.setAccountId(po.getAccountId());
        enterpriseAccountBalancePO.setUpdateTime(new Date());
        enterpriseAccountBalancePO.setBalanceType(reqBO.getBalanceType());
        if (!reqBO.getRechargeType().equals(1)) {
            enterpriseAccountBalancePO.setUsedAmount(balance);
        }
        if ((result = this.enterpriseAccountBalanceMapper.rechargeBalance(enterpriseAccountBalancePO)) < 1) {
            throw new UmcBusinessException("8888", "\u4f01\u4e1a\u5145\u503c\u5931\u8d25");
        }
    }

    private void writeChngLog(Long accountId, Long amount, UmcEnterpriseRechargeBusiReqBO umcEnterpriseRechargeBusiReqBO, Integer payStaus) {
        UmcEnterpriseOrgBO umcEnterpriseOrgBO = this.enterpriseOrgMapper.getModelById(umcEnterpriseRechargeBusiReqBO.getOrgId());
        if (null == umcEnterpriseOrgBO) {
            throw new UmcBusinessException("8888", "\u673a\u6784\u4e0d\u5b58\u5728");
        }
        UmcAddEnterpriseAccountBalanceChngLogBusiReqBO reqBO = new UmcAddEnterpriseAccountBalanceChngLogBusiReqBO();
        reqBO.setAccountId(accountId);
        reqBO.setChngType(UmcCommConstant.WALLET_CHNG_TYPE.INCOME);
        reqBO.setOrgId(umcEnterpriseOrgBO.getOrgId());
        reqBO.setCreaterId(umcEnterpriseRechargeBusiReqBO.getMemIdIn());
        reqBO.setChngAmount(amount);
        reqBO.setPayStatus(payStaus);
        reqBO.setPaySn(umcEnterpriseRechargeBusiReqBO.getPaySn());
        reqBO.setBusiType(UmcCommConstant.OrgRechargeBusiType.RECHARGE);
        reqBO.setPayType(umcEnterpriseRechargeBusiReqBO.getPayType());
        reqBO.setPayAccount(umcEnterpriseRechargeBusiReqBO.getPayAccount());
        reqBO.setPayAccountName(umcEnterpriseRechargeBusiReqBO.getPayAccountName());
        reqBO.setPayTime(umcEnterpriseRechargeBusiReqBO.getPayTime());
        reqBO.setState(UmcEnumConstant.State.EFFECTIVE.getCode());
        reqBO.setTenantOrgId(umcEnterpriseOrgBO.getTenantId());
        reqBO.setBalanceType(umcEnterpriseRechargeBusiReqBO.getBalanceType());
        try {
            reqBO.setPayAmount(MoneyUtils.BigDecimal2Long((BigDecimal)umcEnterpriseRechargeBusiReqBO.getPayAmount()));
        }
        catch (Exception e) {
            log.error("\u91d1\u989d\u8f6c\u6362\u5f02\u5e38:{}", (Throwable)e);
            throw new UmcBusinessException("8888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
        }
        if (StringUtils.isBlank((CharSequence)umcEnterpriseRechargeBusiReqBO.getDetail())) {
            reqBO.setDetail("\u4f01\u4e1a\u5145\u503c");
        } else {
            reqBO.setDetail(umcEnterpriseRechargeBusiReqBO.getDetail());
        }
        if (StringUtils.isBlank((CharSequence)umcEnterpriseRechargeBusiReqBO.getTitle())) {
            reqBO.setTitle("\u4f01\u4e1a\u5145\u503c");
        } else {
            reqBO.setTitle(umcEnterpriseRechargeBusiReqBO.getTitle());
        }
        UmcAddEnterpriseAccountBalanceChngLogBusiRspBO rspBO = this.umcAddEnterpriseAccountBalanceChngLogBusiService.addChngLog(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UmcBusinessException(rspBO.getRespCode(), rspBO.getRespDesc());
        }
    }

    private void updatePayStatus(EnterpriseAccountBalanceChngLogPO po) {
        EnterpriseAccountBalanceChngLogPO enterpriseAccountBalanceChngLogPO = new EnterpriseAccountBalanceChngLogPO();
        enterpriseAccountBalanceChngLogPO.setLogId(po.getLogId());
        enterpriseAccountBalanceChngLogPO.setOrgId(po.getOrgId());
        enterpriseAccountBalanceChngLogPO.setPaySn(po.getPaySn());
        enterpriseAccountBalanceChngLogPO.setPayType(po.getPayType());
        enterpriseAccountBalanceChngLogPO.setPayTime(po.getPayTime());
        enterpriseAccountBalanceChngLogPO.setPayStatus(po.getPayStatus());
        enterpriseAccountBalanceChngLogPO.setPayNotifyTransId(po.getPayNotifyTransId());
        int result = this.enterpriseAccountBalanceChngLogMapper.updateByPay(enterpriseAccountBalanceChngLogPO);
        if (result < 1) {
            throw new UmcBusinessException("8888", "\u652f\u4ed8\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
        }
    }

    private EnterpriseAccountBalanceChngLogPO getOrgPayLog(String paySn, Long orgId) {
        EnterpriseAccountBalanceChngLogPO enterpriseAccountBalanceChngLogPO = new EnterpriseAccountBalanceChngLogPO();
        enterpriseAccountBalanceChngLogPO.setOrgId(orgId);
        enterpriseAccountBalanceChngLogPO.setPaySn(paySn);
        enterpriseAccountBalanceChngLogPO = this.enterpriseAccountBalanceChngLogMapper.selectModel(enterpriseAccountBalanceChngLogPO);
        if (null == enterpriseAccountBalanceChngLogPO || StringUtils.isBlank((CharSequence)enterpriseAccountBalanceChngLogPO.getPaySn())) {
            throw new UmcBusinessException("8888", "\u652f\u4ed8\u6d41\u6c34\u4e0d\u5b58\u5728");
        }
        return enterpriseAccountBalanceChngLogPO;
    }
}

