/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.tydic.umc.busi.UmcFaceInfoAddBusiService;
import com.tydic.umc.busi.bo.FaceInfoBusiBO;
import com.tydic.umc.busi.bo.UmcFaceInfoAddBusiReqBO;
import com.tydic.umc.busi.bo.UmcFaceInfoAddBusiRspBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.dao.MemFaceMapper;
import com.tydic.umc.po.MemFacePO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcFaceInfoAddBusiService")
public class UmcFaceInfoAddBusiServiceImpl
implements UmcFaceInfoAddBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcFaceInfoAddBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Autowired
    private MemFaceMapper memFaceMapper;

    public UmcFaceInfoAddBusiRspBO addFaceInfo(UmcFaceInfoAddBusiReqBO busiReqBO) {
        UmcFaceInfoAddBusiRspBO rsp = new UmcFaceInfoAddBusiRspBO();
        MemFacePO memFacePO2 = new MemFacePO();
        memFacePO2.setMemId(busiReqBO.getMemId());
        memFacePO2.setState(UmcCommConstant.MenFaceState.EFFECTIVE);
        List<MemFacePO> memFacePO2List = this.memFaceMapper.getListByCondition(memFacePO2);
        if (null != memFacePO2List && memFacePO2List.size() > 0) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u8be5\u4f1a\u5458Id\u5df2\u7ed1\u5b9a\u4eba\u8138\u4fe1\u606f\uff01");
            }
            throw new UmcBusinessException("6003", "\u8be5\u4f1a\u5458Id\u5df2\u7ed1\u5b9a\u4eba\u8138\u4fe1\u606f\uff01");
        }
        for (FaceInfoBusiBO bo : busiReqBO.getFaceInfoList()) {
            MemFacePO memFacePO = new MemFacePO();
            BeanUtils.copyProperties((Object)bo, (Object)memFacePO);
            memFacePO.setFaceId(bo.getFaceId());
            memFacePO.setMemId(busiReqBO.getMemId());
            memFacePO.setState(UmcCommConstant.MenFaceState.EFFECTIVE);
            memFacePO.setCreateTime(new Date());
            int isInsert = this.memFaceMapper.insert(memFacePO);
            if (isInsert >= 1) continue;
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u4f1a\u5458\u4e2d\u5fc3\u4eba\u8138\u4fe1\u606f\u65b0\u589e\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4eba\u8138\u4fe1\u606f\u8868\u5931\u8d25\uff01");
            }
            throw new UmcBusinessException("6003", "\u4f1a\u5458\u4e2d\u5fc3\u4eba\u8138\u4fe1\u606f\u65b0\u589e\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4eba\u8138\u4fe1\u606f\u8868\u5931\u8d25\uff01");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4f1a\u5458\u4e2d\u5fc3\u4eba\u8138\u4fe1\u606f\u63d2\u5165\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }
}

