/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.tydic.umc.busi.UmcFaceInfoDeleteBusiService;
import com.tydic.umc.busi.bo.FaceInfoBusiBO;
import com.tydic.umc.busi.bo.UmcFaceInfoDeleteBusiReqBO;
import com.tydic.umc.busi.bo.UmcFaceInfoDeleteBusiRspBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.dao.MemFaceMapper;
import com.tydic.umc.po.MemFacePO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcFaceInfoDeleteBusiService")
public class UmcFaceInfoDeleteBusiServiceImpl
implements UmcFaceInfoDeleteBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcFaceInfoDeleteBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Autowired
    private MemFaceMapper memFaceMapper;

    public UmcFaceInfoDeleteBusiRspBO deleteFaceInfo(UmcFaceInfoDeleteBusiReqBO busiReqBO) {
        MemFacePO memFacePO;
        UmcFaceInfoDeleteBusiRspBO rsp = new UmcFaceInfoDeleteBusiRspBO();
        ArrayList<MemFacePO> menFaceLists = new ArrayList<MemFacePO>();
        for (FaceInfoBusiBO bo : busiReqBO.getFaceInfoList()) {
            memFacePO = new MemFacePO();
            memFacePO.setFaceId(bo.getFaceId());
            memFacePO.setMemId(busiReqBO.getMemId());
            memFacePO.setWhereString("AND UPDATE_TIME is null");
            List<MemFacePO> menFace = this.memFaceMapper.getListByCondition(memFacePO);
            menFaceLists.addAll(menFace);
        }
        for (MemFacePO po : menFaceLists) {
            memFacePO = new MemFacePO();
            memFacePO.setId(po.getId());
            memFacePO.setMemId(busiReqBO.getMemId());
            memFacePO.setState(UmcCommConstant.MenFaceState.INVALID);
            memFacePO.setUpdateTime(new Date());
            int isUpdate = this.memFaceMapper.updateByCondition(memFacePO);
            if (isUpdate >= 1) continue;
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u4f1a\u5458\u4e2d\u5fc3\u4eba\u8138\u4fe1\u606f\u5220\u9664\u4e1a\u52a1\u670d\u52a1\u66f4\u65b0\u4eba\u8138\u4fe1\u606f\u8868\u5931\u8d25\uff01");
            }
            throw new UmcBusinessException("6002", "\u4f1a\u5458\u4e2d\u5fc3\u4eba\u8138\u4fe1\u606f\u5220\u9664\u4e1a\u52a1\u670d\u52a1\u66f4\u65b0\u4eba\u8138\u4fe1\u606f\u8868\u5931\u8d25\uff01");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4f1a\u5458\u4e2d\u5fc3\u4eba\u8138\u4fe1\u606f\u5220\u9664\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }
}

