/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.tydic.umc.busi.UmcFaceInfoUpdateBusiService;
import com.tydic.umc.busi.bo.FaceInfoBusiBO;
import com.tydic.umc.busi.bo.UmcFaceInfoUpdateBusiReqBO;
import com.tydic.umc.busi.bo.UmcFaceInfoUpdateBusiRspBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.dao.MemFaceMapper;
import com.tydic.umc.po.MemFacePO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcFaceInfoUpdateBusiService")
public class UmcFaceInfoUpdateBusiServiceImpl
implements UmcFaceInfoUpdateBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcFaceInfoUpdateBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Autowired
    private MemFaceMapper memFaceMapper;

    public UmcFaceInfoUpdateBusiRspBO updateFaceInfo(UmcFaceInfoUpdateBusiReqBO busiReqBO) {
        UmcFaceInfoUpdateBusiRspBO rsp = new UmcFaceInfoUpdateBusiRspBO();
        MemFacePO memFacePO = new MemFacePO();
        memFacePO.setMemId(busiReqBO.getMemId());
        memFacePO.setState(UmcCommConstant.MenFaceState.EFFECTIVE);
        MemFacePO memFace = this.memFaceMapper.getModelByCondition(memFacePO);
        if (null == memFace) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u4f1a\u5458\u4e2d\u5fc3\u4eba\u8138\u4fe1\u606f\u4fee\u6539\u4e1a\u52a1\u670d\u52a1\u67e5\u8be2\u4eba\u8138\u4fe1\u606f\u8868\u4e3a\u7a7a\uff01");
            }
            throw new UmcBusinessException("6001", "\u4f1a\u5458\u4e2d\u5fc3\u4eba\u8138\u4fe1\u606f\u4fee\u6539\u4e1a\u52a1\u670d\u52a1\u67e5\u8be2\u4eba\u8138\u4fe1\u606f\u8868\u4e3a\u7a7a\uff01");
        }
        memFace.setState(UmcCommConstant.MenFaceState.INVALID);
        memFace.setUpdateTime(new Date());
        int isUpdate = this.memFaceMapper.updateByCondition(memFace);
        if (isUpdate < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u4f1a\u5458\u4e2d\u5fc3\u4eba\u8138\u4fe1\u606f\u4fee\u6539\u4e1a\u52a1\u670d\u52a1\u66f4\u65b0\u4eba\u8138\u4fe1\u606f\u8868\u5931\u8d25\uff01");
            }
            throw new UmcBusinessException("6001", "\u4f1a\u5458\u4e2d\u5fc3\u4eba\u8138\u4fe1\u606f\u4fee\u6539\u4e1a\u52a1\u670d\u52a1\u66f4\u65b0\u4eba\u8138\u4fe1\u606f\u8868\u5931\u8d25\uff01");
        }
        for (FaceInfoBusiBO bo : busiReqBO.getFaceInfoList()) {
            MemFacePO memFacePO2 = new MemFacePO();
            BeanUtils.copyProperties((Object)bo, (Object)memFacePO2);
            memFacePO2.setFaceId(bo.getFaceId());
            memFacePO2.setMemId(busiReqBO.getMemId());
            memFacePO2.setState(UmcCommConstant.MenFaceState.EFFECTIVE);
            memFacePO2.setCreateTime(new Date());
            int isInsert = this.memFaceMapper.insert(memFacePO2);
            if (isInsert >= 1) continue;
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u4f1a\u5458\u4e2d\u5fc3\u4eba\u8138\u4fe1\u606f\u4fee\u6539\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4eba\u8138\u4fe1\u606f\u8868\u5931\u8d25\uff01");
            }
            throw new UmcBusinessException("6003", "\u4f1a\u5458\u4e2d\u5fc3\u4eba\u8138\u4fe1\u606f\u4fee\u6539\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4eba\u8138\u4fe1\u606f\u8868\u5931\u8d25\uff01");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4f1a\u5458\u4e2d\u5fc3\u4eba\u8138\u4fe1\u606f\u4fee\u6539\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }
}

