/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.tydic.umc.atom.UmcGrowValueDeductAtomService;
import com.tydic.umc.atom.UmcIntegralAddAtomService;
import com.tydic.umc.atom.UmcRuleCalculateAtomService;
import com.tydic.umc.atom.bo.UmcGrowValueDeductAtomReqBO;
import com.tydic.umc.atom.bo.UmcGrowValueDeductAtomRspBO;
import com.tydic.umc.atom.bo.UmcIntegralAddAtomReqBO;
import com.tydic.umc.atom.bo.UmcIntegralAddAtomRspBO;
import com.tydic.umc.atom.bo.UmcRuleCalculateAtomReqBO;
import com.tydic.umc.atom.bo.UmcRuleCalculateAtomRspBO;
import com.tydic.umc.busi.UmcGrowExchangeIntegralBusiService;
import com.tydic.umc.busi.bo.UmcGrowExchangeIntegralBusiReqBO;
import com.tydic.umc.busi.bo.UmcGrowExchangeIntegralBusiRspBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.OperRuleMapper;
import com.tydic.umc.po.OperRulePO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcGrowExchangeIntegralBusiService")
public class UmcGrowExchangeIntegralBusiServiceImpl
implements UmcGrowExchangeIntegralBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcGrowExchangeIntegralBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private OperRuleMapper operRuleMapper;
    private UmcRuleCalculateAtomService umcRuleCalculateAtomService;
    private UmcGrowValueDeductAtomService umcGrowValueDeductAtomService;
    private UmcIntegralAddAtomService umcIntegralAddAtomService;

    @Autowired
    public UmcGrowExchangeIntegralBusiServiceImpl(OperRuleMapper operRuleMapper, UmcRuleCalculateAtomService umcRuleCalculateAtomService, UmcGrowValueDeductAtomService umcGrowValueDeductAtomService, UmcIntegralAddAtomService umcIntegralAddAtomService) {
        this.operRuleMapper = operRuleMapper;
        this.umcRuleCalculateAtomService = umcRuleCalculateAtomService;
        this.umcGrowValueDeductAtomService = umcGrowValueDeductAtomService;
        this.umcIntegralAddAtomService = umcIntegralAddAtomService;
    }

    public UmcGrowExchangeIntegralBusiRspBO growExchangeIntegral(UmcGrowExchangeIntegralBusiReqBO busiReqBO) {
        UmcGrowExchangeIntegralBusiRspBO rsp = new UmcGrowExchangeIntegralBusiRspBO();
        OperRulePO operRulePO = new OperRulePO();
        operRulePO.setOperCode(UmcEnumConstant.AddGrowOperCode.GROW_EXCHANGE_INTEGRAL.getCode());
        operRulePO.setRuleType(UmcCommConstant.RuleType.EXCHANGE_SCALE);
        OperRulePO operRule = this.operRuleMapper.getModelByCondition(operRulePO);
        if (null == operRule) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u4e1a\u52a1\u89c4\u5219\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
            }
            throw new UmcBusinessException("6011", "\u4e1a\u52a1\u89c4\u5219\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Object> ruleParamsMap = new HashMap<String, Object>(1);
        ruleParamsMap.put("memLevel", busiReqBO.getMemLevel());
        UmcRuleCalculateAtomReqBO umcRuleCalculateAtomReqBO = new UmcRuleCalculateAtomReqBO();
        umcRuleCalculateAtomReqBO.setRuleId(operRule.getRuleId());
        umcRuleCalculateAtomReqBO.setRuleParamsMap(ruleParamsMap);
        umcRuleCalculateAtomReqBO.setRuleType(UmcCommConstant.RuleType.EXCHANGE_SCALE);
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u89c4\u5219\u8ba1\u7b97\u539f\u5b50\u670d\u52a1\u5165\u53c2\uff1a" + umcRuleCalculateAtomReqBO.toString());
        }
        UmcRuleCalculateAtomRspBO umcRuleCalculateAtomRspBO = this.umcRuleCalculateAtomService.ruleCalculate(umcRuleCalculateAtomReqBO);
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u89c4\u5219\u8ba1\u7b97\u539f\u5b50\u670d\u52a1\u51fa\u53c2\uff1a" + umcRuleCalculateAtomRspBO.toString());
        }
        if (!"0000".equals(umcRuleCalculateAtomRspBO.getRespCode())) {
            throw new UmcBusinessException(umcRuleCalculateAtomRspBO.getRespCode(), umcRuleCalculateAtomRspBO.getRespDesc());
        }
        UmcGrowValueDeductAtomReqBO umcGrowValueDeductAtomReqBO = new UmcGrowValueDeductAtomReqBO();
        umcGrowValueDeductAtomReqBO.setMemId(busiReqBO.getMemId());
        umcGrowValueDeductAtomReqBO.setGrowValue(busiReqBO.getExchangeIntegral() * Long.parseLong(umcRuleCalculateAtomRspBO.getTargetValue()));
        umcGrowValueDeductAtomReqBO.setOperCode(UmcEnumConstant.AddGrowOperCode.GROW_EXCHANGE_INTEGRAL.getCode());
        umcGrowValueDeductAtomReqBO.setOperResult("\u64cd\u4f5c\u4e1a\u52a1\u7f16\u7801[" + UmcEnumConstant.AddGrowOperCode.GROW_EXCHANGE_INTEGRAL.getCode() + "]\u5c06\u6210\u957f\u503c\u5151\u6362\u4e3a\u79ef\u5206");
        umcGrowValueDeductAtomReqBO.setOperDesc("\u64cd\u4f5c\u4e1a\u52a1\u7f16\u7801[" + UmcEnumConstant.AddGrowOperCode.GROW_EXCHANGE_INTEGRAL.getCode() + "]\u5c06\u6210\u957f\u503c\u5151\u6362\u4e3a\u79ef\u5206");
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u6210\u957f\u503c\u6263\u51cf\u539f\u5b50\u670d\u52a1\u5165\u53c2\uff1a" + umcGrowValueDeductAtomReqBO.toString());
        }
        UmcGrowValueDeductAtomRspBO umcGrowValueDeductAtomRspBO = this.umcGrowValueDeductAtomService.deductGroupValue(umcGrowValueDeductAtomReqBO);
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u6210\u957f\u503c\u6263\u51cf\u539f\u5b50\u670d\u52a1\u51fa\u53c2\uff1a" + umcGrowValueDeductAtomRspBO.toString());
        }
        if (!"0000".equals(umcGrowValueDeductAtomRspBO.getRespCode())) {
            throw new UmcBusinessException(umcGrowValueDeductAtomRspBO.getRespCode(), umcGrowValueDeductAtomRspBO.getRespDesc());
        }
        UmcIntegralAddAtomReqBO umcIntegralAddAtomReqBO = new UmcIntegralAddAtomReqBO();
        umcIntegralAddAtomReqBO.setMemId(busiReqBO.getMemId());
        umcIntegralAddAtomReqBO.setIntegral(busiReqBO.getExchangeIntegral());
        umcIntegralAddAtomReqBO.setOperCode(UmcEnumConstant.AddGrowOperCode.GROW_EXCHANGE_INTEGRAL.getCode());
        umcIntegralAddAtomReqBO.setState(UmcEnumConstant.IntegralState.EFFECTIVE.getCode());
        umcIntegralAddAtomReqBO.setOperResult("\u64cd\u4f5c\u4e1a\u52a1\u7f16\u7801[" + UmcEnumConstant.AddGrowOperCode.GROW_EXCHANGE_INTEGRAL.getCode() + "]\u5c06\u6210\u957f\u503c\u5151\u6362\u4e3a\u79ef\u5206");
        umcIntegralAddAtomReqBO.setOperDesc("\u64cd\u4f5c\u4e1a\u52a1\u7f16\u7801[" + UmcEnumConstant.AddGrowOperCode.GROW_EXCHANGE_INTEGRAL.getCode() + "]\u5c06\u6210\u957f\u503c\u5151\u6362\u4e3a\u79ef\u5206");
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u4f1a\u5458\u79ef\u5206\u65b0\u589e\u539f\u5b50\u670d\u52a1\u5165\u53c2\uff1a" + umcIntegralAddAtomReqBO.toString());
        }
        UmcIntegralAddAtomRspBO umcIntegralAddAtomRspBO = this.umcIntegralAddAtomService.insertIntegral(umcIntegralAddAtomReqBO);
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u4f1a\u5458\u79ef\u5206\u65b0\u589e\u539f\u5b50\u670d\u52a1\u51fa\u53c2\uff1a" + umcIntegralAddAtomRspBO.toString());
        }
        if (!"0000".equals(umcIntegralAddAtomRspBO.getRespCode())) {
            throw new UmcBusinessException(umcIntegralAddAtomRspBO.getRespCode(), umcIntegralAddAtomRspBO.getRespDesc());
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4f1a\u5458\u4e2d\u5fc3\u6210\u957f\u503c\u5151\u6362\u79ef\u5206\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }
}

