/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.tydic.umc.atom.UmcGrowValueDeductAtomService;
import com.tydic.umc.atom.bo.UmcGrowValueDeductAtomReqBO;
import com.tydic.umc.atom.bo.UmcGrowValueDeductAtomRspBO;
import com.tydic.umc.busi.UmcGrowValueGetReturnSaleBusiService;
import com.tydic.umc.busi.bo.UmcGrowValueGetReturnSaleBusiReqBO;
import com.tydic.umc.busi.bo.UmcGrowValueGetReturnSaleBusiRspBO;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.GrowChgLogMapper;
import com.tydic.umc.po.GrowChgLogPO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcGrowValueGetReturnSaleBusiService")
public class UmcGrowValueGetReturnSaleBusiServiceImpl
implements UmcGrowValueGetReturnSaleBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcGrowValueGetReturnSaleBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private GrowChgLogMapper growChgLogMapper;
    private UmcGrowValueDeductAtomService umcGrowValueDeductAtomService;

    @Autowired
    public UmcGrowValueGetReturnSaleBusiServiceImpl(GrowChgLogMapper growChgLogMapper, UmcGrowValueDeductAtomService umcGrowValueDeductAtomService) {
        this.growChgLogMapper = growChgLogMapper;
        this.umcGrowValueDeductAtomService = umcGrowValueDeductAtomService;
    }

    public UmcGrowValueGetReturnSaleBusiRspBO getGrowValueReturnSale(UmcGrowValueGetReturnSaleBusiReqBO busiReqBO) {
        UmcGrowValueGetReturnSaleBusiRspBO rsp = new UmcGrowValueGetReturnSaleBusiRspBO();
        Long returnSaleGrowValue = this.getReturnSaleGrowValue(busiReqBO);
        if (returnSaleGrowValue == 0L) {
            throw new UmcBusinessException("6013", "\u5f85\u8fd4\u9500\u6210\u957f\u503c\u4e3a0\uff01");
        }
        UmcGrowValueDeductAtomReqBO umcGrowValueDeductAtomReqBO = new UmcGrowValueDeductAtomReqBO();
        BeanUtils.copyProperties((Object)busiReqBO, (Object)umcGrowValueDeductAtomReqBO);
        umcGrowValueDeductAtomReqBO.setGrowValue(returnSaleGrowValue);
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u6210\u957f\u503c\u6263\u51cf\u539f\u5b50\u670d\u52a1\u5165\u53c2\uff1a" + umcGrowValueDeductAtomReqBO.toString());
        }
        UmcGrowValueDeductAtomRspBO umcGrowValueDeductAtomRspBO = this.umcGrowValueDeductAtomService.deductGroupValue(umcGrowValueDeductAtomReqBO);
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u6210\u957f\u503c\u6263\u51cf\u539f\u5b50\u670d\u52a1\u51fa\u53c2\uff1a" + umcGrowValueDeductAtomRspBO.toString());
        }
        if (!"0000".equals(umcGrowValueDeductAtomRspBO.getRespCode())) {
            throw new UmcBusinessException(umcGrowValueDeductAtomRspBO.getRespCode(), umcGrowValueDeductAtomRspBO.getRespDesc());
        }
        GrowChgLogPO growChgLogPO = new GrowChgLogPO();
        growChgLogPO.setMemId(busiReqBO.getMemId());
        growChgLogPO.setOperSystem(busiReqBO.getOperSystem());
        growChgLogPO.setOperSn(busiReqBO.getOperSn());
        growChgLogPO.setAction(UmcEnumConstant.GrowChgLogAction.DEDUCT_GROW_VALUE.getCode());
        GrowChgLogPO growChgLog = this.growChgLogMapper.getModelByConditions(growChgLogPO);
        if (null == growChgLog) {
            throw new UmcBusinessException("6013", "\u8be5\u4f1a\u5458Id[" + busiReqBO.getMemId() + "]\u7684\u5bf9\u5e94\u64cd\u4f5c\u7cfb\u7edf:" + busiReqBO.getOperSystem() + ",\u5bf9\u5e94\u6d41\u6c34\u53f7\uff1a" + busiReqBO.getOperSn() + "\u7684\u6210\u957f\u503c\u65e5\u5fd7\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        GrowChgLogPO growChgLogPO2 = new GrowChgLogPO();
        growChgLogPO2.setId(growChgLog.getId());
        growChgLogPO2.setMemId(growChgLog.getMemId());
        growChgLogPO2.setAction(UmcEnumConstant.GrowChgLogAction.RETURN_SALE_GROW_VALUE.getCode());
        int isUpdate = this.growChgLogMapper.updateByConditions(growChgLogPO2);
        if (isUpdate < 1) {
            throw new UmcBusinessException("6013", "\u6210\u957f\u503c\u65e5\u5fd7\u8868\u66f4\u65b0\u5931\u8d25\uff01");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4f1a\u5458\u4e2d\u5fc3\u6210\u957f\u503c\u83b7\u53d6\u8fd4\u9500\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }

    private Long getReturnSaleGrowValue(UmcGrowValueGetReturnSaleBusiReqBO busiReqBO) {
        Long returnSaleGrowValue = 0L;
        GrowChgLogPO growChgLogPO = new GrowChgLogPO();
        growChgLogPO.setMemId(busiReqBO.getMemId());
        growChgLogPO.setOperSystem(busiReqBO.getOperSystem());
        growChgLogPO.setOperSn(busiReqBO.getOperSn());
        growChgLogPO.setAction(UmcEnumConstant.GrowChgLogAction.RETURN_SALE_GROW_VALUE.getCode());
        List<GrowChgLogPO> growChgLogPOList = this.growChgLogMapper.getListByConditions(growChgLogPO);
        if (null != growChgLogPOList && growChgLogPOList.size() > 0) {
            throw new UmcBusinessException("6013", "\u8be5\u4f1a\u5458Id[" + busiReqBO.getMemId() + "]\u7684\u5bf9\u5e94\u64cd\u4f5c\u7cfb\u7edf:" + busiReqBO.getOperSystem() + ",\u5bf9\u5e94\u6d41\u6c34\u53f7\uff1a" + busiReqBO.getOperSn() + "\u5df2\u7ecf\u8fd4\u9500\uff01");
        }
        growChgLogPO.setAction(UmcEnumConstant.GrowChgLogAction.ADD_GROW_VALUE.getCode());
        List<GrowChgLogPO> growChgLogPOList2 = this.growChgLogMapper.getListByConditions(growChgLogPO);
        if (null == growChgLogPOList2 || growChgLogPOList2.size() <= 0) {
            throw new UmcBusinessException("6013", "\u8be5\u4f1a\u5458Id[" + busiReqBO.getMemId() + "]\u7684\u5bf9\u5e94\u64cd\u4f5c\u7cfb\u7edf:" + busiReqBO.getOperSystem() + ",\u5bf9\u5e94\u6d41\u6c34\u53f7\uff1a" + busiReqBO.getOperSn() + "\u7684\u6210\u957f\u503c\u65e5\u5fd7\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        for (GrowChgLogPO po : growChgLogPOList2) {
            returnSaleGrowValue = returnSaleGrowValue + Math.abs(po.getGrowValue());
        }
        return returnSaleGrowValue;
    }
}

