/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.tydic.umc.atom.UmcRuleCalculateAtomService;
import com.tydic.umc.atom.bo.UmcRuleCalculateAtomReqBO;
import com.tydic.umc.atom.bo.UmcRuleCalculateAtomRspBO;
import com.tydic.umc.busi.UmcIntegralDedBusiService;
import com.tydic.umc.busi.bo.UmcIntegralDedBusiReqBO;
import com.tydic.umc.busi.bo.UmcIntegralDedBusiRspBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.OperRuleMapper;
import com.tydic.umc.po.OperRulePO;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcIntegralDedBusiService")
public class UmcIntegralDedBusiServiceImpl
implements UmcIntegralDedBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcIntegralDedBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private OperRuleMapper operRuleMapper;
    private UmcRuleCalculateAtomService umcRuleCalculateAtomService;

    @Autowired
    public UmcIntegralDedBusiServiceImpl(OperRuleMapper operRuleMapper, UmcRuleCalculateAtomService umcRuleCalculateAtomService) {
        this.operRuleMapper = operRuleMapper;
        this.umcRuleCalculateAtomService = umcRuleCalculateAtomService;
    }

    public UmcIntegralDedBusiRspBO integralDed(UmcIntegralDedBusiReqBO umcIntegralDedBusiReqBO) {
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u4f1a\u5458\u4e2d\u5fc3\u79ef\u5206\u62b5\u6263\u8ba1\u7b97\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u4e3a\uff1a" + umcIntegralDedBusiReqBO.toString());
        }
        UmcIntegralDedBusiRspBO rspBO = new UmcIntegralDedBusiRspBO();
        UmcRuleCalculateAtomRspBO calcCanUseIntegralRspBO = this.calcCanUseIntegral(umcIntegralDedBusiReqBO);
        if (!"0000".equals(calcCanUseIntegralRspBO.getRespCode())) {
            rspBO.setRespCode(calcCanUseIntegralRspBO.getRespCode());
            rspBO.setRespDesc(calcCanUseIntegralRspBO.getRespDesc());
            return rspBO;
        }
        UmcRuleCalculateAtomRspBO calcDedMoneyRspBO = this.calcDedMoney(Long.valueOf(calcCanUseIntegralRspBO.getTargetValue()));
        if (!"0000".equals(calcDedMoneyRspBO.getRespCode())) {
            rspBO.setRespCode(calcDedMoneyRspBO.getRespCode());
            rspBO.setRespDesc(calcDedMoneyRspBO.getRespDesc());
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u79ef\u5206\u62b5\u6263\u8ba1\u7b97\u6210\u529f");
        rspBO.setUsedIntegral(Long.valueOf(calcCanUseIntegralRspBO.getTargetValue()));
        rspBO.setUnusedIntegral(Long.valueOf(umcIntegralDedBusiReqBO.getUsedIntegral() - Long.valueOf(calcCanUseIntegralRspBO.getTargetValue())));
        rspBO.setDeductionMoney(new BigDecimal(calcDedMoneyRspBO.getTargetValue()));
        return rspBO;
    }

    private UmcRuleCalculateAtomRspBO calcCanUseIntegral(UmcIntegralDedBusiReqBO umcIntegralDedBusiReqBO) {
        UmcRuleCalculateAtomRspBO rspBO = new UmcRuleCalculateAtomRspBO();
        OperRulePO operRulePO = this.qryOperRule(UmcCommConstant.RuleType.EXCHANGE_SCALE);
        if (operRulePO == null) {
            rspBO.setRespCode("2016");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u7f16\u7801[" + UmcEnumConstant.AddIntegralOperCode.INTEGRAL_DEDUCTION.getCode() + "]\u4e14\u7c7b\u578b\u4e3a[" + UmcCommConstant.RuleType.EXCHANGE_SCALE + "]\u6240\u5bf9\u5e94\u7684\u89c4\u5219\u4fe1\u606f");
            return rspBO;
        }
        HashMap<String, Object> ruleParamsMap = new HashMap<String, Object>(2);
        ruleParamsMap.put("totalMoney", umcIntegralDedBusiReqBO.getTotalMoney());
        ruleParamsMap.put("usedIntegral", umcIntegralDedBusiReqBO.getUsedIntegral());
        UmcRuleCalculateAtomRspBO umcRuleCalculateAtomRspBO = this.ruleCalculate(operRulePO.getRuleId(), operRulePO.getRuleType(), ruleParamsMap);
        if (!"0000".equals(umcRuleCalculateAtomRspBO.getRespCode())) {
            rspBO.setRespCode(umcRuleCalculateAtomRspBO.getRespCode());
            rspBO.setRespDesc(umcRuleCalculateAtomRspBO.getRespDesc());
            return rspBO;
        }
        if (StringUtils.isEmpty((CharSequence)umcRuleCalculateAtomRspBO.getTargetValue())) {
            rspBO.setRespCode("2014");
            rspBO.setRespDesc("\u79ef\u5206\u62b5\u6263\u8ba1\u7b97\u5931\u8d25,\u672a\u6210\u529f\u8ba1\u7b97\u5230\u53ef\u62b5\u6263\u79ef\u5206");
            return rspBO;
        }
        return umcRuleCalculateAtomRspBO;
    }

    private UmcRuleCalculateAtomRspBO calcDedMoney(Long canUseIntegral) {
        UmcRuleCalculateAtomRspBO rspBO = new UmcRuleCalculateAtomRspBO();
        OperRulePO operRulePO = this.qryOperRule(UmcCommConstant.RuleType.OTHER);
        if (operRulePO == null) {
            rspBO.setRespCode("2016");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u7f16\u7801[" + UmcEnumConstant.AddIntegralOperCode.INTEGRAL_DEDUCTION.getCode() + "]\u4e14\u7c7b\u578b\u4e3a[" + UmcCommConstant.RuleType.OTHER + "]\u6240\u5bf9\u5e94\u7684\u89c4\u5219\u4fe1\u606f");
            return rspBO;
        }
        HashMap<String, Object> ruleParamsMap = new HashMap<String, Object>(1);
        ruleParamsMap.put("deductionIntegral", canUseIntegral);
        UmcRuleCalculateAtomRspBO umcRuleCalculateAtomRspBO = this.ruleCalculate(operRulePO.getRuleId(), operRulePO.getRuleType(), ruleParamsMap);
        if (!"0000".equals(umcRuleCalculateAtomRspBO.getRespCode())) {
            rspBO.setRespCode(umcRuleCalculateAtomRspBO.getRespCode());
            rspBO.setRespDesc(umcRuleCalculateAtomRspBO.getRespDesc());
            return rspBO;
        }
        if (StringUtils.isEmpty((CharSequence)umcRuleCalculateAtomRspBO.getTargetValue())) {
            rspBO.setRespCode("2015");
            rspBO.setRespDesc("\u79ef\u5206\u62b5\u6263\u8ba1\u7b97\u5931\u8d25,\u672a\u6210\u529f\u8ba1\u7b97\u5230\u62b5\u6263\u91d1\u989d");
            return rspBO;
        }
        return umcRuleCalculateAtomRspBO;
    }

    private OperRulePO qryOperRule(Integer ruleType) {
        OperRulePO operRuleModel = new OperRulePO();
        operRuleModel.setRuleType(ruleType);
        operRuleModel.setOperCode(UmcEnumConstant.AddIntegralOperCode.INTEGRAL_DEDUCTION.getCode());
        return this.operRuleMapper.getModelByCondition(operRuleModel);
    }

    private UmcRuleCalculateAtomRspBO ruleCalculate(Long ruleId, Integer ruleType, Map<String, Object> ruleParamsMap) {
        UmcRuleCalculateAtomReqBO umcRuleCalculateAtomReqBO = new UmcRuleCalculateAtomReqBO();
        umcRuleCalculateAtomReqBO.setRuleId(ruleId);
        umcRuleCalculateAtomReqBO.setRuleType(ruleType);
        umcRuleCalculateAtomReqBO.setRuleParamsMap(ruleParamsMap);
        return this.umcRuleCalculateAtomService.ruleCalculate(umcRuleCalculateAtomReqBO);
    }
}

