/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.tydic.umc.busi.UmcIntegralDeductReturnSaleBusiService;
import com.tydic.umc.busi.bo.UmcIntegralDeductReturnSaleBusiReqBO;
import com.tydic.umc.busi.bo.UmcIntegralDeductReturnSaleBusiRspBO;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.IntegralChgLogMapper;
import com.tydic.umc.dao.IntegralMapper;
import com.tydic.umc.po.IntegralChgLogPO;
import com.tydic.umc.po.IntegralPO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcIntegralDeductReturnSaleBusiService")
public class UmcIntegralDeductReturnSaleBusiServiceImpl
implements UmcIntegralDeductReturnSaleBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(UmcIntegralDeductReturnSaleBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOG.isDebugEnabled();
    private IntegralMapper integralMapper;
    private IntegralChgLogMapper integralChgLogMapper;

    @Autowired
    public UmcIntegralDeductReturnSaleBusiServiceImpl(IntegralMapper integralMapper, IntegralChgLogMapper integralChgLogMapper) {
        this.integralMapper = integralMapper;
        this.integralChgLogMapper = integralChgLogMapper;
    }

    public UmcIntegralDeductReturnSaleBusiRspBO deductIntegralReturnSale(UmcIntegralDeductReturnSaleBusiReqBO busiReqBO) {
        UmcIntegralDeductReturnSaleBusiRspBO rsp = new UmcIntegralDeductReturnSaleBusiRspBO();
        IntegralChgLogPO integralChgLogPO = new IntegralChgLogPO();
        integralChgLogPO.setMemId(busiReqBO.getMemId());
        integralChgLogPO.setOperSystem(busiReqBO.getOperSystem());
        integralChgLogPO.setOperSn(busiReqBO.getOperSn());
        List<IntegralChgLogPO> integralChgLogPOList = this.integralChgLogMapper.getListByCondition(integralChgLogPO);
        if (null == integralChgLogPOList || integralChgLogPOList.size() <= 0) {
            throw new UmcBusinessException("6010", "\u67e5\u8be2\u79ef\u5206\u65e5\u5fd7\u8868\u4e3a\u7a7a\uff01");
        }
        for (IntegralChgLogPO po : integralChgLogPOList) {
            if (!UmcEnumConstant.IntegralOperCode.RETURN_SALE_INTEGRAL.getCode().equals(po.getAction())) continue;
            if (IS_DEBUG_ENABLED) {
                LOG.debug("\u8be5\u4f1a\u5458Id\u3010" + busiReqBO.getMemId() + "\u3011,\u64cd\u4f5c\u7cfb\u7edf\u3010" + busiReqBO.getOperSystem() + "\u3011,\u64cd\u4f5c\u6d41\u6c34\u3010" + busiReqBO.getOperSn() + "\u3011\u5df2\u7ecf\u8fd4\u9500\u8fc7\u4e86\uff01");
            }
            rsp.setRespCode("2006");
            rsp.setRespDesc("\u8be5\u4f1a\u5458Id\u3010" + busiReqBO.getMemId() + "\u3011,\u64cd\u4f5c\u7cfb\u7edf\u3010" + busiReqBO.getOperSystem() + "\u3011,\u64cd\u4f5c\u6d41\u6c34\u3010" + busiReqBO.getOperSn() + "\u3011\u5df2\u7ecf\u8fd4\u9500\u8fc7\u4e86\uff01");
            return rsp;
        }
        for (IntegralChgLogPO po : integralChgLogPOList) {
            if (!UmcEnumConstant.IntegralOperCode.EXPENSE_INTEGRAL.getCode().equals(po.getAction())) continue;
            int isReturnSale = this.updateIntegral(busiReqBO.getMemId(), po.getIntId(), po.getIntegral());
            if (isReturnSale < 1) {
                if (IS_DEBUG_ENABLED) {
                    LOG.debug("\u66f4\u65b0\u79ef\u5206\u8868\u5931\u8d25!");
                }
                rsp.setRespCode("2006");
                rsp.setRespDesc("\u66f4\u65b0\u79ef\u5206\u8868\u5931\u8d25\uff01");
                return rsp;
            }
            po.setId(null);
            po.setAction(UmcEnumConstant.IntegralOperCode.RETURN_SALE_INTEGRAL.getCode());
            po.setOperTime(new Date());
            po.setOperResult("\u62b5\u6263\u79ef\u5206\u8fd4\u9500");
            po.setOperDesc("\u62b5\u6263\u79ef\u5206\u8fd4\u9500");
            po.setIntegral(Math.abs(po.getIntegral()));
            int isInsert = this.insertIntegralChgLog(po);
            if (isInsert >= 1) continue;
            if (IS_DEBUG_ENABLED) {
                LOG.debug("\u63d2\u5165\u79ef\u5206\u65e5\u5fd7\u8868\u5931\u8d25!");
            }
            rsp.setRespCode("2006");
            rsp.setRespDesc("\u63d2\u5165\u79ef\u5206\u65e5\u5fd7\u8868\u5931\u8d25\uff01");
            return rsp;
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4f1a\u5458\u4e2d\u5fc3\u79ef\u5206\u62b5\u6263\u8fd4\u9500\u4e1a\u52a1\u670d\u52a1");
        return rsp;
    }

    private int insertIntegralChgLog(IntegralChgLogPO integralChgLogPO) {
        return this.integralChgLogMapper.insert(integralChgLogPO);
    }

    private int updateIntegral(Long memId, Long intId, Long integral) {
        IntegralPO integralPO = new IntegralPO();
        integralPO.setIntId(intId);
        integralPO.setMemId(memId);
        integralPO.setIntegral(Math.abs(integral));
        return this.integralMapper.returnSaleIntegral(integralPO);
    }
}

