/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.umc.busi.UmcIntegralQryBusiService;
import com.tydic.umc.busi.bo.IntegralBusiBO;
import com.tydic.umc.busi.bo.UmcIntegralQryBusiReqBO;
import com.tydic.umc.busi.bo.UmcIntegralQryBusiRspBO;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.IntegralMapper;
import com.tydic.umc.po.IntegralPO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcIntegralQryBusiService")
public class UmcIntegralQryBusiServiceImpl
implements UmcIntegralQryBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcIntegralQryBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private IntegralMapper integralMapper;

    @Autowired
    public UmcIntegralQryBusiServiceImpl(IntegralMapper integralMapper) {
        this.integralMapper = integralMapper;
    }

    public UmcIntegralQryBusiRspBO qryIntegral(UmcIntegralQryBusiReqBO umcIntegralQryBusiReqBO) {
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u6267\u884c\u4f1a\u5458\u79ef\u5206\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u4e3a\uff1a" + umcIntegralQryBusiReqBO.toString());
        }
        UmcIntegralQryBusiRspBO rspBO = new UmcIntegralQryBusiRspBO();
        Page page = new Page(umcIntegralQryBusiReqBO.getPageNo().intValue(), umcIntegralQryBusiReqBO.getPageSize().intValue());
        IntegralPO integralModel = new IntegralPO();
        integralModel.setIntId(umcIntegralQryBusiReqBO.getIntId());
        integralModel.setMemId(umcIntegralQryBusiReqBO.getMemId());
        integralModel.setState(umcIntegralQryBusiReqBO.getState());
        integralModel.setOrderBy(umcIntegralQryBusiReqBO.getOrderBy());
        List<IntegralPO> integralPOS = this.integralMapper.getListPageByCondition(integralModel, (Page<IntegralPO>)page);
        if (integralPOS == null || integralPOS.isEmpty()) {
            rspBO.setRows(new ArrayList());
            rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u4f1a\u5458\u7684\u79ef\u5206\u4fe1\u606f");
            return rspBO;
        }
        ArrayList<IntegralBusiBO> integralBusiBOS = new ArrayList<IntegralBusiBO>();
        for (IntegralPO integralPO : integralPOS) {
            IntegralBusiBO integralBusiBO = new IntegralBusiBO();
            BeanUtils.copyProperties((Object)integralPO, (Object)integralBusiBO);
            integralBusiBOS.add(integralBusiBO);
        }
        Long totalEffectiveIntegral = 0L;
        Long totalLoseEfficacyIntegral = 0L;
        IntegralPO qryAllIntegralModel = new IntegralPO();
        qryAllIntegralModel.setIntId(umcIntegralQryBusiReqBO.getIntId());
        qryAllIntegralModel.setMemId(umcIntegralQryBusiReqBO.getMemId());
        qryAllIntegralModel.setState(umcIntegralQryBusiReqBO.getState());
        List<IntegralPO> allIntegralPOS = this.integralMapper.getListByCondition(qryAllIntegralModel);
        for (IntegralPO integralPO : allIntegralPOS) {
            if (UmcEnumConstant.IntegralState.EFFECTIVE.getCode().equals(integralPO.getState())) {
                totalEffectiveIntegral = totalEffectiveIntegral + integralPO.getIntegral();
                continue;
            }
            if (!UmcEnumConstant.IntegralState.LOSE_EFFICACY.getCode().equals(integralPO.getState())) continue;
            totalLoseEfficacyIntegral = totalLoseEfficacyIntegral + integralPO.getIntegral();
        }
        rspBO.setTotalEffecIntegral(totalEffectiveIntegral);
        rspBO.setTotalLoseEffecIntegral(totalLoseEfficacyIntegral);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRows(integralBusiBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u5230\u4f1a\u5458\u7684\u79ef\u5206\u4fe1\u606f\u6210\u529f");
        return rspBO;
    }
}

