/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.umc.busi.UmcLogisticsRelaAddBusiService;
import com.tydic.umc.busi.bo.LogisticsRelaBusiBO;
import com.tydic.umc.busi.bo.UmcLogisticsRelaAddBusiReqBO;
import com.tydic.umc.busi.bo.UmcLogisticsRelaAddBusiRspBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.LogisticsRelaMapper;
import com.tydic.umc.dao.UmcRelationUnionMapper;
import com.tydic.umc.po.LogisticsRelaPO;
import com.tydic.umc.po.UmcRelationUnionPO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="umcLogisticsRelaAddBusiService")
public class UmcLogisticsRelaAddBusiServiceImpl
implements UmcLogisticsRelaAddBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcLogisticsRelaAddBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final String SUCCESS_MSG = "\u65b0\u589e\u6536\u8d27\u5730\u5740\u6210\u529f";
    private static final String ERROR_MSG = "\u65b0\u589e\u6536\u8d27\u5730\u5740\u5931\u8d25,\u6570\u636e\u5e93\u5f02\u5e38";
    private static final String OPERTYPE_ADD = "1";
    private static final String OPERTYPE_ASSIGNMENT = "6";
    @Autowired
    private LogisticsRelaMapper logisticsRelaMapper;
    @Autowired
    private UmcRelationUnionMapper umcRelationUnionMapper;

    public UmcLogisticsRelaAddBusiRspBO addLogisticsRela(UmcLogisticsRelaAddBusiReqBO reqBO) {
        UmcLogisticsRelaAddBusiRspBO rspBO = new UmcLogisticsRelaAddBusiRspBO();
        if (OPERTYPE_ADD.equals(reqBO.getOperType())) {
            for (LogisticsRelaBusiBO logisticsRelaBusiBO : reqBO.getLogisticsRelaList()) {
                int check;
                if (!StringUtils.isBlank((CharSequence)logisticsRelaBusiBO.getContactId())) {
                    LogisticsRelaPO logisticsRelaPO = new LogisticsRelaPO();
                    logisticsRelaPO.setContactId(Long.valueOf(logisticsRelaBusiBO.getContactId()));
                    LogisticsRelaPO relaPO = this.logisticsRelaMapper.getModelByCondition(logisticsRelaPO);
                    if (null != relaPO) {
                        if (IS_DEBUG_ENABLED) {
                            LOGGER.debug("\u6536\u8d27\u5730\u5740ID[" + logisticsRelaBusiBO.getContactId() + "]\u5df2\u5b58\u5728");
                        }
                        throw new UmcBusinessException("6011", "\u65b0\u589e\u6536\u8d27\u5730\u5740\u4fe1\u606f\u5931\u8d25,ID\u5df2\u5b58\u5728");
                    }
                }
                LogisticsRelaPO isHavePO = new LogisticsRelaPO();
                BeanUtils.copyProperties((Object)logisticsRelaBusiBO, (Object)isHavePO);
                isHavePO.setMemId(reqBO.getMemId());
                List<LogisticsRelaPO> isHaveResultPO = this.logisticsRelaMapper.getListByCondition(isHavePO);
                if (!CollectionUtils.isEmpty(isHaveResultPO)) {
                    throw new UmcBusinessException("6011", "\u5df2\u5b58\u5728\u76f8\u540c\u6536\u8d27\u4eba\u4fe1\u606f\uff01");
                }
                if (StringUtils.isBlank((CharSequence)logisticsRelaBusiBO.getIsDefault())) {
                    logisticsRelaBusiBO.setIsDefault(UmcCommConstant.LogisticsRelaIsDefault.IS_DEFAULT_NO + "");
                } else if ((UmcCommConstant.LogisticsRelaIsDefault.IS_DEFAULT_YES + "").equals(logisticsRelaBusiBO.getIsDefault())) {
                    LogisticsRelaPO logisticsRelaPO = new LogisticsRelaPO();
                    logisticsRelaPO.setMemId(reqBO.getMemId());
                    logisticsRelaPO.setIsDefault(UmcCommConstant.InvoiceTitleInfoIsDefault.IS_DEFAULT_YES);
                    check = this.logisticsRelaMapper.getCheckBy(logisticsRelaPO);
                    if (check > 0) {
                        logisticsRelaPO.setIsDefault(UmcCommConstant.InvoiceTitleInfoIsDefault.IS_DEFAULT_NO);
                        int result = this.logisticsRelaMapper.updateByCondition(logisticsRelaPO);
                        if (result < 1) {
                            if (IS_DEBUG_ENABLED) {
                                LOGGER.debug(ERROR_MSG);
                            }
                            throw new UmcBusinessException("6012", ERROR_MSG);
                        }
                    }
                }
                LogisticsRelaPO logisticsRelaPO2 = new LogisticsRelaPO();
                logisticsRelaPO2.setMemId(reqBO.getMemId());
                check = this.logisticsRelaMapper.getCheckBy(logisticsRelaPO2);
                if (0 == check) {
                    logisticsRelaBusiBO.setIsDefault(UmcCommConstant.LogisticsRelaIsDefault.IS_DEFAULT_YES + "");
                }
                LogisticsRelaPO logisticsRelaPO = new LogisticsRelaPO();
                BeanUtils.copyProperties((Object)logisticsRelaBusiBO, (Object)logisticsRelaPO);
                logisticsRelaPO.setMemId(reqBO.getMemId());
                logisticsRelaPO.setAdmOrgId(reqBO.getAdmOrgId());
                logisticsRelaPO.setIsDefault(Integer.valueOf(logisticsRelaBusiBO.getIsDefault()));
                if (StringUtils.isBlank((CharSequence)logisticsRelaBusiBO.getContactId())) {
                    logisticsRelaPO.setContactId(null);
                } else {
                    logisticsRelaPO.setContactId(Long.valueOf(logisticsRelaBusiBO.getContactId()));
                }
                logisticsRelaPO.setContactId(Sequence.getInstance().nextId());
                int result = this.logisticsRelaMapper.insert(logisticsRelaPO);
                if (result >= 1) continue;
                if (IS_DEBUG_ENABLED) {
                    LOGGER.debug(ERROR_MSG);
                }
                throw new UmcBusinessException("6011", ERROR_MSG);
            }
        }
        if (OPERTYPE_ASSIGNMENT.equals(reqBO.getOperType())) {
            ArrayList<Long> memIds = new ArrayList<Long>();
            if (CollectionUtils.isEmpty((Collection)reqBO.getMemIds())) {
                memIds.add(reqBO.getMemId());
            } else {
                memIds.addAll(reqBO.getMemIds());
            }
            ArrayList<Long> contactIds = new ArrayList<Long>();
            reqBO.getLogisticsRelaList().forEach(bo -> contactIds.add(Long.valueOf(bo.getContactId())));
            Integer contactIdSize = reqBO.getLogisticsRelaList().size();
            LogisticsRelaPO logisticsRelaPO = new LogisticsRelaPO();
            logisticsRelaPO.setContactIds(contactIds);
            List<LogisticsRelaPO> logisticsRelaPOS = this.logisticsRelaMapper.getListByCondition(logisticsRelaPO);
            if (CollectionUtils.isEmpty(logisticsRelaPOS) || !contactIdSize.equals(logisticsRelaPOS.size())) {
                throw new UmcBusinessException("6011", "\u5730\u5740\u4e0d\u5b58\u5728");
            }
            UmcRelationUnionPO umcRelationUnionPO = new UmcRelationUnionPO();
            umcRelationUnionPO.setRelationId1List(memIds);
            umcRelationUnionPO.setType(3);
            List<UmcRelationUnionPO> umcRelationUnionPOS = this.umcRelationUnionMapper.getListBy(umcRelationUnionPO);
            List<LogisticsRelaPO> logisticsRelaPOSNew = this.buildPO(memIds, logisticsRelaPOS, umcRelationUnionPOS);
            logisticsRelaPOSNew.forEach(po -> {
                Long seqId = Sequence.getInstance().nextId();
                po.setContactId(seqId);
                int result = this.logisticsRelaMapper.insert((LogisticsRelaPO)po);
                if (result < 1) {
                    throw new UmcBusinessException("6011", ERROR_MSG);
                }
                UmcRelationUnionPO relationUnionPO = new UmcRelationUnionPO();
                relationUnionPO.setId(Sequence.getInstance().nextId());
                relationUnionPO.setRelationId1(po.getMemId());
                relationUnionPO.setRelationId2(po.getContactIdOld());
                relationUnionPO.setType(3);
                relationUnionPO.setDelStatus(UmcEnumConstant.DelFlag.NOT_DELETE.getCode());
                int relationUnionResult = this.umcRelationUnionMapper.insert(relationUnionPO);
                if (relationUnionResult < 1) {
                    throw new UmcBusinessException("6011", "\u65b0\u589e\u7528\u6237\u5206\u914d\u5730\u5740\u5173\u7cfb\u5931\u8d25");
                }
                UmcRelationUnionPO relationUnionPO2 = new UmcRelationUnionPO();
                relationUnionPO2.setId(Sequence.getInstance().nextId());
                relationUnionPO2.setRelationId1(po.getContactIdOld());
                relationUnionPO2.setRelationId2(po.getContactId());
                relationUnionPO2.setType(4);
                relationUnionPO2.setDelStatus(UmcEnumConstant.DelFlag.NOT_DELETE.getCode());
                int relationUnion2Result = this.umcRelationUnionMapper.insert(relationUnionPO2);
                if (relationUnion2Result < 1) {
                    throw new UmcBusinessException("6011", "\u65b0\u589e\u5730\u5740\u5173\u7cfb\u5931\u8d25");
                }
            });
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc(SUCCESS_MSG);
        return rspBO;
    }

    private List<LogisticsRelaPO> buildPO(List<Long> memIds, List<LogisticsRelaPO> logisticsRelaPOS, List<UmcRelationUnionPO> umcRelationUnionPOS) {
        ArrayList<LogisticsRelaPO> logisticsRelaPOSNew = new ArrayList<LogisticsRelaPO>();
        for (Long memId : memIds) {
            for (LogisticsRelaPO logisticsRelaPO : logisticsRelaPOS) {
                boolean exists = true;
                for (UmcRelationUnionPO umcRelationUnionPO : umcRelationUnionPOS) {
                    if (!memId.equals(umcRelationUnionPO.getRelationId1()) || !logisticsRelaPO.getContactId().equals(umcRelationUnionPO.getRelationId2())) continue;
                    if (IS_DEBUG_ENABLED) {
                        LOGGER.debug("1--------memId:{}   2---------contactId:{}", (Object)memId, (Object)logisticsRelaPO.getContactId());
                    }
                    exists = false;
                    break;
                }
                if (!exists) continue;
                LogisticsRelaPO poNew = new LogisticsRelaPO();
                BeanUtils.copyProperties((Object)logisticsRelaPO, (Object)poNew);
                poNew.setMemId(memId);
                poNew.setIsDefault(UmcCommConstant.InvoiceTitleInfoIsDefault.IS_DEFAULT_NO);
                poNew.setContactIdOld(logisticsRelaPO.getContactId());
                poNew.setBusiType(3);
                logisticsRelaPOSNew.add(poNew);
                if (!IS_DEBUG_ENABLED) continue;
                LOGGER.debug("111--------{}", (Object)poNew);
            }
        }
        return logisticsRelaPOSNew;
    }
}

