/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.tydic.umc.busi.UmcMailReadBusiService;
import com.tydic.umc.busi.bo.UmcMailReadBusiReqBO;
import com.tydic.umc.busi.bo.UmcSysMailSendBusiRspBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.dao.MemMsgRecMapper;
import com.tydic.umc.dao.MsgSysMapper;
import com.tydic.umc.po.MemMsgRecPO;
import com.tydic.umc.po.MsgSysPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcMailReadBusiService")
public class UmcMailReadBusiServiceImpl
implements UmcMailReadBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcMailReadBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final String SUCCESS_MSG = "\u7ad9\u5185\u4fe1\u9605\u8bfb\u670d\u52a1\u6210\u529f";
    private static final String ERROR_MSG = "\u7ad9\u5185\u4fe1\u9605\u8bfb\u670d\u52a1\u5931\u8d25,\u6570\u636e\u5e93\u5f02\u5e38";
    @Autowired
    private MsgSysMapper msgSysMapper;
    @Autowired
    private MemMsgRecMapper memMsgRecMapper;

    public UmcSysMailSendBusiRspBO dealReadMail(UmcMailReadBusiReqBO reqBO) {
        UmcSysMailSendBusiRspBO rspBO = new UmcSysMailSendBusiRspBO();
        if ((UmcCommConstant.MsgType.PERSONAL_MSG + "").equals(reqBO.getMsgType())) {
            MemMsgRecPO memMsgRecPO = new MemMsgRecPO();
            memMsgRecPO.setMemId(reqBO.getMemId());
            memMsgRecPO.setId(Long.valueOf(reqBO.getMsgId()));
            memMsgRecPO.setSendState(UmcCommConstant.SendState.READ);
            memMsgRecPO.setReadTime(new Date());
            int result = this.memMsgRecMapper.updateByConditions(memMsgRecPO);
            if (result < 1) {
                if (IS_DEBUG_ENABLED) {
                    LOGGER.debug(ERROR_MSG);
                }
                rspBO.setRespCode("2042");
                rspBO.setRespDesc(ERROR_MSG);
                return rspBO;
            }
        } else if ((UmcCommConstant.MsgType.SYSTEM_MSG + "").equals(reqBO.getMsgType())) {
            MsgSysPO msgSysPO = new MsgSysPO();
            msgSysPO.setMsgId(Long.valueOf(reqBO.getMsgId()));
            msgSysPO = this.msgSysMapper.getModelByConditions(msgSysPO);
            if (null == msgSysPO) {
                if (IS_DEBUG_ENABLED) {
                    LOGGER.debug(ERROR_MSG);
                }
                rspBO.setRespCode("2042");
                rspBO.setRespDesc(ERROR_MSG);
                return rspBO;
            }
            MemMsgRecPO memMsgRecPO = new MemMsgRecPO();
            memMsgRecPO.setMemId(reqBO.getMemId());
            memMsgRecPO.setMsgTitle(msgSysPO.getMsgTitle());
            memMsgRecPO.setMsgContent(msgSysPO.getMsgContent());
            memMsgRecPO.setSendState(UmcCommConstant.SendState.READ);
            memMsgRecPO.setReadTime(new Date());
            memMsgRecPO.setMsgType(UmcCommConstant.MsgType.SYSTEM_MSG);
            memMsgRecPO.setSendId("sys");
            memMsgRecPO.setSendTime(msgSysPO.getCreateTime());
            int result = this.memMsgRecMapper.insert(memMsgRecPO);
            if (result < 1) {
                if (IS_DEBUG_ENABLED) {
                    LOGGER.debug(ERROR_MSG);
                }
                rspBO.setRespCode("2042");
                rspBO.setRespDesc(ERROR_MSG);
                return rspBO;
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc(SUCCESS_MSG);
        return rspBO;
    }
}

