/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.tydic.umc.busi.UmcMemDetailQueryBusiService;
import com.tydic.umc.busi.bo.FaceInfoDetailBusiBO;
import com.tydic.umc.busi.bo.ThirdAuthInfoBusiBO;
import com.tydic.umc.busi.bo.UmcMemDetailInfoBusiRspBO;
import com.tydic.umc.busi.bo.UmcMemDetailQueryBusiReqBO;
import com.tydic.umc.busi.bo.UmcMemDetailQueryBusiRspBO;
import com.tydic.umc.common.UmcEnterpriseOrgBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.dao.EnterpriseOrgMapper;
import com.tydic.umc.dao.IntegralMapper;
import com.tydic.umc.dao.MemCouponMapper;
import com.tydic.umc.dao.MemExtMapMapper;
import com.tydic.umc.dao.MemFaceMapper;
import com.tydic.umc.dao.MemUserMapper;
import com.tydic.umc.dao.MemberMapper;
import com.tydic.umc.dao.ThirdBindMapper;
import com.tydic.umc.po.EnterpriseOrgPO;
import com.tydic.umc.po.IntegralPO;
import com.tydic.umc.po.MemCouponPO;
import com.tydic.umc.po.MemExtMapPO;
import com.tydic.umc.po.MemFacePO;
import com.tydic.umc.po.MemberPO;
import com.tydic.umc.po.ThirdBindPO;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="umcMemDetailQueryBusiService")
public class UmcMemDetailQueryBusiServiceImpl
implements UmcMemDetailQueryBusiService {
    private static final Logger log = LoggerFactory.getLogger(UmcMemDetailQueryBusiServiceImpl.class);
    private static final Integer EFFICTIVE = 1;
    private static final String MEM_NICK_NAME_HEAD = "NR";
    private MemFaceMapper memFaceMapper;
    private MemberMapper memberMapper;
    private ThirdBindMapper thirdBindMapper;
    private IntegralMapper integralMapper;
    private MemCouponMapper memCouponMapper;
    @Autowired
    private MemUserMapper memUserMapper;
    @Autowired
    private EnterpriseOrgMapper enterpriseOrgMapper;
    @Autowired
    private MemExtMapMapper memExtMapMapper;

    @Autowired
    public UmcMemDetailQueryBusiServiceImpl(MemFaceMapper memFaceMapper, MemberMapper memberMapper, ThirdBindMapper thirdBindMapper, IntegralMapper integralMapper, MemCouponMapper memCouponMapper, EnterpriseOrgMapper enterpriseOrgMapper) {
        this.memFaceMapper = memFaceMapper;
        this.memberMapper = memberMapper;
        this.thirdBindMapper = thirdBindMapper;
        this.integralMapper = integralMapper;
        this.memCouponMapper = memCouponMapper;
        this.enterpriseOrgMapper = enterpriseOrgMapper;
    }

    public UmcMemDetailQueryBusiRspBO memDetailQuery(UmcMemDetailQueryBusiReqBO busiReqBO) {
        String memNickNameHead;
        UmcMemDetailQueryBusiRspBO rsp = new UmcMemDetailQueryBusiRspBO();
        UmcMemDetailInfoBusiRspBO umcMemDetailInfoBusiRspBO = new UmcMemDetailInfoBusiRspBO();
        MemberPO memberPO = new MemberPO();
        memberPO.setMemId(busiReqBO.getMemId());
        memberPO.setRegAccount(busiReqBO.getRegAccount());
        memberPO.setUserId(busiReqBO.getUserIdWeb());
        memberPO.setState(UmcCommConstant.MemState.EFFECTIVE);
        MemberPO member = this.memberMapper.getModelByCondition(memberPO);
        if (null == member) {
            rsp.setRespCode("6008");
            rsp.setRespDesc("\u67e5\u8be2\u4f1a\u5458\u8868\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        if (null == busiReqBO.getMemId()) {
            busiReqBO.setMemId(member.getMemId());
        }
        BeanUtils.copyProperties((Object)member, (Object)umcMemDetailInfoBusiRspBO);
        DecimalFormat df = new DecimalFormat("0.0");
        if (null != member.getHeight()) {
            String height = df.format((float)member.getHeight().intValue() / 10.0f);
            umcMemDetailInfoBusiRspBO.setHeight(height);
        }
        if (null != member.getWeight()) {
            String weight = df.format((float)member.getWeight().intValue() / 10.0f);
            umcMemDetailInfoBusiRspBO.setWeight(weight);
        }
        umcMemDetailInfoBusiRspBO.setMemNickNameTrans(member.getMemNickName());
        if (member.getMemNickName() != null && member.getMemNickName().length() > 2 && MEM_NICK_NAME_HEAD.equals(memNickNameHead = member.getMemNickName().substring(0, 2))) {
            umcMemDetailInfoBusiRspBO.setMemNickName("\u4f1a\u5458");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{member.getRegMobile()})) {
                umcMemDetailInfoBusiRspBO.setMemNickName(member.getRegMobile());
            }
        }
        ThirdBindPO thirdBindPO = new ThirdBindPO();
        thirdBindPO.setMemId(busiReqBO.getMemId());
        List<ThirdBindPO> thirdBindList = this.thirdBindMapper.getListByCondition(thirdBindPO);
        EnterpriseOrgPO enterpriseOrgPO = new EnterpriseOrgPO();
        enterpriseOrgPO.setOrgId(member.getOrgId());
        UmcEnterpriseOrgBO enterpriseOrg = this.enterpriseOrgMapper.getModelBy(enterpriseOrgPO);
        if (null == enterpriseOrg) {
            rsp.setRespCode("6008");
            rsp.setRespDesc("\u67e5\u8be2\u4f1a\u5458\u6240\u5c5e\u673a\u6784\u8868\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        if (null != member.getCompanyId()) {
            EnterpriseOrgPO enterpriseOrgPO2 = new EnterpriseOrgPO();
            enterpriseOrgPO2.setOrgId(member.getCompanyId());
            UmcEnterpriseOrgBO enterpriseOrg2 = this.enterpriseOrgMapper.getModelBy(enterpriseOrgPO2);
            if (null == enterpriseOrg2) {
                rsp.setRespCode("6008");
                rsp.setRespDesc("\u67e5\u8be2\u4f1a\u5458\u6240\u5c5e\u673a\u6784\u8868\u7ed3\u679c\u4e3a\u7a7a\uff01");
                return rsp;
            }
            umcMemDetailInfoBusiRspBO.setCompanyName(enterpriseOrg2.getOrgName());
        }
        umcMemDetailInfoBusiRspBO.setTenantId(enterpriseOrg.getTenantId());
        umcMemDetailInfoBusiRspBO.setOrgTreePath(enterpriseOrg.getOrgTreePath());
        umcMemDetailInfoBusiRspBO.setParentOrgId(enterpriseOrg.getParentId());
        umcMemDetailInfoBusiRspBO.setOrgName(enterpriseOrg.getOrgName());
        umcMemDetailInfoBusiRspBO.setOrgCode(enterpriseOrg.getOrgCode());
        umcMemDetailInfoBusiRspBO.setIsShopOrg(enterpriseOrg.getIsShopOrg());
        umcMemDetailInfoBusiRspBO.setAlias(enterpriseOrg.getAlias());
        this.setRootOrgId(umcMemDetailInfoBusiRspBO);
        ArrayList<ThirdAuthInfoBusiBO> thirdAuthInfoBusiList = new ArrayList<ThirdAuthInfoBusiBO>();
        if (null != thirdBindList && thirdBindList.size() > 0) {
            for (ThirdBindPO po : thirdBindList) {
                ThirdAuthInfoBusiBO thirdAuthInfoBusiBO = new ThirdAuthInfoBusiBO();
                BeanUtils.copyProperties((Object)po, (Object)thirdAuthInfoBusiBO);
                thirdAuthInfoBusiList.add(thirdAuthInfoBusiBO);
            }
        }
        if (null != thirdAuthInfoBusiList && thirdAuthInfoBusiList.size() > 0) {
            umcMemDetailInfoBusiRspBO.setThirdAuthInfoBusiList(thirdAuthInfoBusiList);
        }
        MemFacePO memFacePO = new MemFacePO();
        memFacePO.setMemId(busiReqBO.getMemId());
        List<MemFacePO> menFaceList = this.memFaceMapper.getListByCondition(memFacePO);
        ArrayList<FaceInfoDetailBusiBO> faceInfoBusiList2 = new ArrayList<FaceInfoDetailBusiBO>();
        if (null != menFaceList && menFaceList.size() > 0) {
            for (MemFacePO po : menFaceList) {
                FaceInfoDetailBusiBO faceInfoBusiDetailBO = new FaceInfoDetailBusiBO();
                BeanUtils.copyProperties((Object)po, (Object)faceInfoBusiDetailBO);
                faceInfoBusiList2.add(faceInfoBusiDetailBO);
            }
        }
        if (null != faceInfoBusiList2 && faceInfoBusiList2.size() > 0) {
            umcMemDetailInfoBusiRspBO.setFaceInfoBusiList2(faceInfoBusiList2);
        }
        IntegralPO integralPO = new IntegralPO();
        integralPO.setMemId(busiReqBO.getMemId());
        List<IntegralPO> integralList = this.integralMapper.getListByCondition(integralPO);
        Long integralTotal = 0L;
        if (null != integralList && integralList.size() > 0) {
            for (IntegralPO po : integralList) {
                if (!EFFICTIVE.equals(po.getState())) continue;
                integralTotal = integralTotal + po.getIntegral();
            }
        }
        if (null != integralTotal) {
            umcMemDetailInfoBusiRspBO.setIntegralTotal(integralTotal);
        }
        MemCouponPO memCouponPO = new MemCouponPO();
        memCouponPO.setMemId(busiReqBO.getMemId());
        List<MemCouponPO> memCouponPOList = this.memCouponMapper.getListByCondition(memCouponPO);
        if (!CollectionUtils.isEmpty(memCouponPOList)) {
            umcMemDetailInfoBusiRspBO.setTotalCoupon(Integer.valueOf(memCouponPOList.size()));
        } else {
            umcMemDetailInfoBusiRspBO.setTotalCoupon(Integer.valueOf(0));
        }
        MemExtMapPO memExtMapPO = new MemExtMapPO();
        memExtMapPO.setMemId(umcMemDetailInfoBusiRspBO.getMemId());
        List<MemExtMapPO> memExtMapList = this.memExtMapMapper.selectExtendMap(memExtMapPO);
        HashMap<String, String> extendMap = new HashMap<String, String>(8);
        if (!CollectionUtils.isEmpty(memExtMapList)) {
            for (MemExtMapPO memExtMap : memExtMapList) {
                extendMap.put(memExtMap.getFieldCode(), memExtMap.getFieldValue());
            }
        }
        umcMemDetailInfoBusiRspBO.setExtendMap(extendMap);
        rsp.setUmcMemDetailInfoBusiRspBO(umcMemDetailInfoBusiRspBO);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4f1a\u5458\u8be6\u60c5\u4fe1\u606f\u67e5\u8be2\u6210\u529f\uff01");
        return rsp;
    }

    private void setRootOrgId(UmcMemDetailInfoBusiRspBO umcMemDetailInfoBusiRspBO) {
        String orgTreePath = umcMemDetailInfoBusiRspBO.getOrgTreePath();
        if (!StringUtils.isBlank((CharSequence)orgTreePath) && orgTreePath.contains("-")) {
            String[] orgTreeArr = orgTreePath.split("-");
            if (orgTreeArr.length >= 2) {
                umcMemDetailInfoBusiRspBO.setRootOrgId(Long.valueOf(Long.parseLong(orgTreeArr[1])));
            }
            if (null != orgTreeArr && orgTreeArr.length > 0) {
                ArrayList<Long> orgIds = new ArrayList<Long>();
                for (String orgId : orgTreeArr) {
                    orgIds.add(Long.parseLong(orgId));
                }
                if (!CollectionUtils.isEmpty(orgIds)) {
                    EnterpriseOrgPO enterpriseOrgPO = new EnterpriseOrgPO();
                    enterpriseOrgPO.setOrgIds(orgIds);
                    List<UmcEnterpriseOrgBO> umcEnterpriseOrgBOS = this.enterpriseOrgMapper.getListByRecord(enterpriseOrgPO);
                    if (!CollectionUtils.isEmpty(umcEnterpriseOrgBOS)) {
                        ListIterator itOrgIds = orgIds.listIterator(orgIds.size());
                        block1: while (itOrgIds.hasPrevious()) {
                            Long orgIdPrevious = (Long)itOrgIds.previous();
                            if (log.isInfoEnabled()) {
                                log.debug("orgId:{}", (Object)orgIdPrevious);
                            }
                            for (UmcEnterpriseOrgBO umcEnterpriseOrgBO : umcEnterpriseOrgBOS) {
                                log.debug("isShopOrg:{}", (Object)umcEnterpriseOrgBO.getIsShopOrg());
                                if (StringUtils.isBlank((CharSequence)umcEnterpriseOrgBO.getIsShopOrg()) || !umcEnterpriseOrgBO.getIsShopOrg().equals("1") || !umcEnterpriseOrgBO.getOrgId().equals(orgIdPrevious)) continue;
                                umcMemDetailInfoBusiRspBO.setMerchantId(orgIdPrevious);
                                if (!log.isInfoEnabled()) break block1;
                                log.debug("merchantId:{}", (Object)orgIdPrevious);
                                break block1;
                            }
                        }
                    }
                }
            }
        }
    }
}

