/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.tydic.umc.busi.UmcMemLabelInfoQueryBusiService;
import com.tydic.umc.busi.bo.MemLabelInfoBusiBO;
import com.tydic.umc.busi.bo.UmcMemLabelInfoQueryBusiReqBO;
import com.tydic.umc.busi.bo.UmcMemLabelInfoQueryBusiRspBO;
import com.tydic.umc.dao.MemLabelMapper;
import com.tydic.umc.po.MemLabelPO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcMemLabelInfoQueryBusiService")
public class UmcMemLabelInfoQueryBusiServiceImpl
implements UmcMemLabelInfoQueryBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcMemLabelInfoQueryBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final String SUCCESS_MSG = "\u67e5\u8be2\u4f1a\u5458\u6807\u7b7e\u4fe1\u606f\u6210\u529f";
    private static final String ERROR_MSG = "\u67e5\u8be2\u4f1a\u5458\u6807\u7b7e\u4fe1\u606f\u5931\u8d25\uff0c\u6570\u636e\u5e93\u5f02\u5e38";
    @Autowired
    private MemLabelMapper memLabelMapper;

    public UmcMemLabelInfoQueryBusiRspBO queryMemLabelInfo(UmcMemLabelInfoQueryBusiReqBO reqBO) {
        UmcMemLabelInfoQueryBusiRspBO rspBO = new UmcMemLabelInfoQueryBusiRspBO();
        MemLabelPO memLabelPO = new MemLabelPO();
        memLabelPO.setMemId(reqBO.getMemberId());
        List<MemLabelPO> memLabelPOList = this.memLabelMapper.getListByCondition(memLabelPO);
        if (null == memLabelPOList) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug(ERROR_MSG);
            }
            rspBO.setRespCode("2031");
            rspBO.setRespDesc(ERROR_MSG);
            return rspBO;
        }
        ArrayList<MemLabelInfoBusiBO> memLabelInfoBOList = new ArrayList<MemLabelInfoBusiBO>();
        for (MemLabelPO labelPO : memLabelPOList) {
            MemLabelInfoBusiBO memLabelInfoBusiBO = new MemLabelInfoBusiBO();
            BeanUtils.copyProperties((Object)labelPO, (Object)memLabelInfoBusiBO);
            memLabelInfoBOList.add(memLabelInfoBusiBO);
        }
        rspBO.setMemLabelInfoBOList(memLabelInfoBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc(SUCCESS_MSG);
        return rspBO;
    }
}

