/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.umc.base.bo.UmcRspListBO;
import com.tydic.umc.busi.UmcMemUserManageBusiService;
import com.tydic.umc.busi.bo.MemUserBO;
import com.tydic.umc.busi.bo.UmcMemUserBusiReqBO;
import com.tydic.umc.busi.bo.UmcMemUserBusiRspBO;
import com.tydic.umc.dao.MemUserMapper;
import com.tydic.umc.po.MemUserPO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="umcMemUserManageBusiService")
public class UmcMemUserManageBusiServiceImpl
implements UmcMemUserManageBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(UmcMemUserManageBusiServiceImpl.class);
    @Autowired
    private MemUserMapper memUserMapper;

    public UmcMemUserBusiRspBO addMemUser(UmcMemUserBusiReqBO busiReqBO) {
        MemUserPO memUserPO = new MemUserPO();
        Sequence sequence = Sequence.getInstance();
        memUserPO.setId(sequence.nextId());
        memUserPO.setMemId(busiReqBO.getMemId());
        memUserPO.setUsreId(busiReqBO.getUsreIdWeb());
        memUserPO.setStatus("00");
        memUserPO.setMemClassify(busiReqBO.getMemClassify());
        try {
            this.memUserMapper.insert(memUserPO);
        }
        catch (Exception e) {
            LOG.error("\u4f1a\u5458\u4e2d\u5fc3\u65b0\u589e\u4f1a\u5458\u7528\u6237\u5173\u7cfb\u9519\u8bef" + e.getMessage());
            throw new UmcBusinessException("2054", "\u4f1a\u5458\u4e2d\u5fc3\u65b0\u589e\u4f1a\u5458\u7528\u6237\u5173\u7cfb\u9519\u8bef");
        }
        UmcMemUserBusiRspBO rspBO = new UmcMemUserBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4f1a\u5458\u4e2d\u5fc3\u65b0\u589e\u4f1a\u5458\u7528\u6237\u5173\u7cfb\u6210\u529f");
        return rspBO;
    }

    public UmcRspListBO<MemUserBO> queryMemUserList(UmcMemUserBusiReqBO busiReqBO) {
        MemUserPO memUserPO = new MemUserPO();
        UmcRspListBO result = new UmcRspListBO();
        ArrayList<MemUserBO> rows = new ArrayList<MemUserBO>();
        memUserPO.setUsreId(busiReqBO.getUsreIdWeb());
        memUserPO.setMemId(busiReqBO.getMemId());
        memUserPO.setUserIds(busiReqBO.getUserIds());
        try {
            List<MemUserPO> daoList = this.memUserMapper.getList(memUserPO);
            if (!CollectionUtils.isEmpty(daoList)) {
                for (MemUserPO po : daoList) {
                    MemUserBO bo = new MemUserBO();
                    BeanUtils.copyProperties((Object)po, (Object)bo);
                    rows.add(bo);
                }
            }
        }
        catch (Exception e) {
            LOG.error("\u4f1a\u5458\u4e2d\u5fc3\u4f1a\u5458\u7528\u6237\u5173\u7cfb\u67e5\u8be2\u9519\u8bef" + e.getMessage());
            throw new UmcBusinessException("2054", "\u4f1a\u5458\u4e2d\u5fc3\u4f1a\u5458\u7528\u6237\u5173\u7cfb\u67e5\u8be2\u9519\u8bef");
        }
        result.setRespCode("0000");
        result.setRespDesc("\u67e5\u8be2\u6210\u529f");
        result.setRows(rows);
        return result;
    }
}

