/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.umc.busi.UmcMemWalletOnlyRechargeBusiService;
import com.tydic.umc.busi.bo.UmcWalletBalanceChngBusiReqBO;
import com.tydic.umc.busi.bo.UmcWalletBalanceChngBusiRspBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.MemberMapper;
import com.tydic.umc.dao.MemberWalletChngLogMapper;
import com.tydic.umc.dao.MemberWalletMapper;
import com.tydic.umc.po.MemberPO;
import com.tydic.umc.po.MemberWalletChngLogPO;
import com.tydic.umc.po.MemberWalletPO;
import com.tydic.umc.util.UmcBusinessException;
import java.math.BigDecimal;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcMemWalletOnlyRechargeBusiService")
public class UmcMemWalletOnlyRechargeBusiServiceImpl
implements UmcMemWalletOnlyRechargeBusiService {
    @Autowired
    private MemberWalletMapper memberWalletMapper;
    @Autowired
    private MemberMapper memberMapper;
    @Autowired
    private MemberWalletChngLogMapper memberWalletChngLogMapper;

    public UmcWalletBalanceChngBusiRspBO dealMemWalletOnlyRecharge(UmcWalletBalanceChngBusiReqBO reqBO) {
        Long walletId;
        UmcWalletBalanceChngBusiRspBO rspBO = new UmcWalletBalanceChngBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        MemberPO memberPO = new MemberPO();
        memberPO.setMemId(reqBO.getMemId());
        memberPO.setState(UmcEnumConstant.State.EFFECTIVE.getCode());
        memberPO = this.memberMapper.getModelByCondition(memberPO);
        if (null == memberPO) {
            throw new UmcBusinessException("8888", "\u7528\u6237\u4e0d\u5b58\u5728");
        }
        Long chargeAmount = 0L;
        try {
            chargeAmount = MoneyUtils.BigDecimal2Long((BigDecimal)reqBO.getChargeAmount());
        }
        catch (Exception e) {
            throw new UmcBusinessException("8888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        if (chargeAmount <= 0L) {
            throw new UmcBusinessException("8888", "\u5145\u503c\u91d1\u989d\u9700\u5927\u4e8e0");
        }
        MemberWalletPO memberWalletPO = new MemberWalletPO();
        memberWalletPO.setMemId(reqBO.getMemId());
        if (null == reqBO.getWalletType()) {
            reqBO.setWalletType(UmcCommConstant.WALLET_TYPE.BALANCE);
        }
        memberWalletPO.setWalletType(reqBO.getWalletType());
        memberWalletPO = this.memberWalletMapper.getModelBy(memberWalletPO);
        Date currentSysDate = new Date();
        int chargeResult = 0;
        if (null == memberWalletPO) {
            MemberWalletPO memberWalletInsertPO = new MemberWalletPO();
            walletId = Sequence.getInstance().nextId();
            memberWalletInsertPO.setWalletId(walletId);
            memberWalletInsertPO.setAdmOrgId(memberPO.getOrgId());
            memberWalletInsertPO.setMemId(reqBO.getMemId());
            memberWalletInsertPO.setWalletType(reqBO.getWalletType());
            memberWalletInsertPO.setBalance(chargeAmount);
            memberWalletInsertPO.setAvailableBalance(chargeAmount);
            memberWalletInsertPO.setUsedAmount(0L);
            memberWalletInsertPO.setLockAmount(0L);
            memberWalletInsertPO.setCreateTime(currentSysDate);
            memberWalletInsertPO.setUpdateTime(currentSysDate);
            memberWalletInsertPO.setUpdateId(reqBO.getUserId());
            chargeResult = this.memberWalletMapper.insert(memberWalletInsertPO);
        } else {
            walletId = memberWalletPO.getWalletId();
            memberWalletPO.setNewBalance(memberWalletPO.getBalance() + chargeAmount);
            memberWalletPO.setBalance(chargeAmount);
            memberWalletPO.setUpdateId(reqBO.getMemId());
            memberWalletPO.setUpdateTime(currentSysDate);
            chargeResult = this.memberWalletMapper.updateBalanceById(memberWalletPO);
        }
        if (chargeResult < 1) {
            throw new UmcBusinessException("8888", "\u5145\u503c\u5931\u8d25");
        }
        MemberWalletChngLogPO memberWalletChngLogPO = new MemberWalletChngLogPO();
        memberWalletChngLogPO.setLogId(Sequence.getInstance().nextId());
        memberWalletChngLogPO.setAdmOrgId(memberPO.getOrgId());
        memberWalletChngLogPO.setWalletId(walletId);
        memberWalletChngLogPO.setWalletType(reqBO.getWalletType());
        memberWalletChngLogPO.setMemId(memberPO.getMemId());
        memberWalletChngLogPO.setTitle(reqBO.getTitle());
        memberWalletChngLogPO.setDetail(reqBO.getDetail());
        memberWalletChngLogPO.setChngType(UmcCommConstant.WALLET_CHNG_TYPE.INCOME);
        memberWalletChngLogPO.setChngAmount(chargeAmount);
        memberWalletChngLogPO.setLockAmount(0L);
        memberWalletChngLogPO.setOrderId(reqBO.getOrderId());
        if (null == reqBO.getConsumeType()) {
            reqBO.setConsumeType(UmcCommConstant.CONSUME_TYPE.SHOP_WELFARE);
        }
        memberWalletChngLogPO.setConsumeType(reqBO.getConsumeType());
        memberWalletChngLogPO.setRemark(reqBO.getRemark());
        memberWalletChngLogPO.setCreateTime(currentSysDate);
        memberWalletChngLogPO.setCreateId(reqBO.getMemId());
        memberWalletChngLogPO.setRefundOrderId(reqBO.getRefundOrderId());
        int logResult = this.memberWalletChngLogMapper.insert(memberWalletChngLogPO);
        if (logResult < 1) {
            throw new UmcBusinessException("8888", "\u5145\u503c\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25");
        }
        rspBO.setChargeResult("\u6210\u529f");
        rspBO.setChargeAmount(reqBO.getChargeAmount().toString());
        rspBO.setMemName(memberPO.getMemName2());
        rspBO.setLogId(memberWalletChngLogPO.getLogId());
        return rspBO;
    }
}

