/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.tydic.umc.atom.UmcRuleCalculateAtomService;
import com.tydic.umc.atom.bo.UmcRuleCalculateAtomReqBO;
import com.tydic.umc.atom.bo.UmcRuleCalculateAtomRspBO;
import com.tydic.umc.busi.UmcMemberRatingBusiService;
import com.tydic.umc.busi.bo.UmcMemberRatingBusiReqBO;
import com.tydic.umc.busi.bo.UmcMemberRatingBusiRspBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.MemChgLogMapper;
import com.tydic.umc.dao.MemberMapper;
import com.tydic.umc.dao.OperRuleMapper;
import com.tydic.umc.po.MemChgLogPO;
import com.tydic.umc.po.MemberPO;
import com.tydic.umc.po.OperRulePO;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcMemberRatingBusiService")
public class UmcMemberRatingBusiServiceImpl
implements UmcMemberRatingBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcMemberRatingBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private MemberMapper memberMapper;
    private OperRuleMapper operRuleMapper;
    private MemChgLogMapper memChgLogMapper;
    private UmcRuleCalculateAtomService umcRuleCalculateAtomService;

    @Autowired
    public UmcMemberRatingBusiServiceImpl(MemberMapper memberMapper, OperRuleMapper operRuleMapper, UmcRuleCalculateAtomService umcRuleCalculateAtomService, MemChgLogMapper memChgLogMapper) {
        this.memberMapper = memberMapper;
        this.operRuleMapper = operRuleMapper;
        this.memChgLogMapper = memChgLogMapper;
        this.umcRuleCalculateAtomService = umcRuleCalculateAtomService;
    }

    public UmcMemberRatingBusiRspBO memberRating(UmcMemberRatingBusiReqBO umcMemberRatingBusiReqBO) {
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u4f1a\u5458\u4e2d\u5fc3\u4f1a\u5458\u8bc4\u7ea7\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u4e3a\uff1a" + umcMemberRatingBusiReqBO.toString());
        }
        UmcMemberRatingBusiRspBO rspBO = new UmcMemberRatingBusiRspBO();
        MemberPO memberPO = this.qryMember(umcMemberRatingBusiReqBO.getMemId());
        if (memberPO == null) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u672a\u67e5\u8be2\u5230\u4f1a\u5458[" + umcMemberRatingBusiReqBO.getMemId() + "]\u7684\u4fe1\u606f");
            }
            rspBO.setRespCode("2008");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u4f1a\u5458[" + umcMemberRatingBusiReqBO.getMemId() + "]\u7684\u4fe1\u606f");
            return rspBO;
        }
        OperRulePO operRulePO = this.qryOperRule();
        if (operRulePO == null) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u7f16\u7801[" + UmcEnumConstant.AddGrowOperCode.MEMBER_RATING.getCode() + "]\u6240\u5bf9\u5e94\u7684\u89c4\u5219\u4fe1\u606f");
            }
            rspBO.setRespCode("2009");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u7f16\u7801[" + UmcEnumConstant.AddGrowOperCode.MEMBER_RATING.getCode() + "]\u6240\u5bf9\u5e94\u7684\u89c4\u5219\u4fe1\u606f");
            return rspBO;
        }
        HashMap<String, Object> operRuleParams = new HashMap<String, Object>(1);
        operRuleParams.put("growValue", memberPO.getGrowValue());
        UmcRuleCalculateAtomRspBO umcRuleCalculateAtomRspBO = this.ruleCalculate(operRuleParams, operRulePO.getRuleId());
        if (!"0000".equals(umcRuleCalculateAtomRspBO.getRespCode())) {
            rspBO.setRespCode(umcRuleCalculateAtomRspBO.getRespCode());
            rspBO.setRespDesc(umcRuleCalculateAtomRspBO.getRespDesc());
            return rspBO;
        }
        UmcMemberRatingBusiRspBO checkMemRspBO = this.checkMemLevel(memberPO, umcRuleCalculateAtomRspBO);
        if (!"0000".equals(checkMemRspBO.getRespCode())) {
            rspBO.setRespCode(checkMemRspBO.getRespCode());
            rspBO.setRespDesc(checkMemRspBO.getRespDesc());
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4f1a\u5458[" + umcMemberRatingBusiReqBO.getMemId() + "]\u8bc4\u7ea7\u6210\u529f");
        return rspBO;
    }

    private MemberPO qryMember(Long memId) {
        MemberPO memberModel = new MemberPO();
        memberModel.setMemId(memId);
        return this.memberMapper.getModelByCondition(memberModel);
    }

    private OperRulePO qryOperRule() {
        OperRulePO operRuleModel = new OperRulePO();
        operRuleModel.setOperCode(UmcEnumConstant.AddGrowOperCode.MEMBER_RATING.getCode());
        operRuleModel.setRuleType(UmcCommConstant.RuleType.MEM_RATING);
        return this.operRuleMapper.getModelByCondition(operRuleModel);
    }

    private UmcRuleCalculateAtomRspBO ruleCalculate(Map<String, Object> operRuleParams, Long ruleId) {
        UmcRuleCalculateAtomReqBO umcRuleCalculateAtomReqBO = new UmcRuleCalculateAtomReqBO();
        umcRuleCalculateAtomReqBO.setRuleId(ruleId);
        umcRuleCalculateAtomReqBO.setRuleType(UmcCommConstant.RuleType.MEM_RATING);
        umcRuleCalculateAtomReqBO.setRuleParamsMap(operRuleParams);
        return this.umcRuleCalculateAtomService.ruleCalculate(umcRuleCalculateAtomReqBO);
    }

    private UmcMemberRatingBusiRspBO checkMemLevel(MemberPO memberPO, UmcRuleCalculateAtomRspBO umcRuleCalculateAtomRspBO) {
        UmcMemberRatingBusiRspBO rspBO = new UmcMemberRatingBusiRspBO();
        Date systemCurrentTime = new Date();
        if (memberPO.getLevelExpTime() == null) {
            rspBO.setRespCode("2010");
            rspBO.setRespDesc("\u4f1a\u5458[" + memberPO.getMemId() + "]\u7684\u4f1a\u5458\u7b49\u7ea7\u5931\u6548\u65f6\u95f4\u4e3a\u7a7a!");
            return rspBO;
        }
        if (memberPO.getLevelExpTime().compareTo(systemCurrentTime) < 0 || !String.valueOf(memberPO.getMemLevel()).equals(umcRuleCalculateAtomRspBO.getTargetValue())) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(memberPO.getLevelExpTime());
            calendar.add(1, 1);
            Date newLevelExpTime = calendar.getTime();
            MemberPO memberUpdateModel = new MemberPO();
            memberUpdateModel.setMemLevel(Integer.valueOf(umcRuleCalculateAtomRspBO.getTargetValue()));
            memberUpdateModel.setLevelEffTime(systemCurrentTime);
            memberUpdateModel.setLevelExpTime(newLevelExpTime);
            memberUpdateModel.setMemId(memberPO.getMemId());
            memberUpdateModel.setIsPlus(UmcEnumConstant.IsPlus.NO.getCode());
            int updateResult = this.memberMapper.updateByCondition(memberUpdateModel);
            if (updateResult < 1) {
                if (IS_DEBUG_ENABLED) {
                    LOGGER.debug("\u66f4\u65b0\u4f1a\u5458\u7b49\u7ea7\u548c\u65b0\u7684\u751f\u3001\u5931\u6548\u65f6\u95f4\u5931\u8d25");
                }
                rspBO.setRespCode("2010");
                rspBO.setRespDesc("\u66f4\u65b0\u4f1a\u5458\u7b49\u7ea7\u548c\u65b0\u7684\u751f\u3001\u5931\u6548\u65f6\u95f4\u5931\u8d25");
                return rspBO;
            }
            Integer insertRecordResult = this.recordMemChangeLog(memberUpdateModel, memberPO);
            if (insertRecordResult < 1) {
                rspBO.setRespCode("2019");
                rspBO.setRespDesc("\u63d2\u5165\u4f1a\u5458\u7b49\u7ea7\u548c\u65b0\u7684\u751f\u3001\u5931\u6548\u65f6\u95f4\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25");
                return rspBO;
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u66f4\u65b0\u4f1a\u5458\u7b49\u7ea7\u6210\u529f");
        return rspBO;
    }

    private Integer recordMemChangeLog(MemberPO updateMemberPO, MemberPO oldMemberPO) {
        int operType = 1;
        MemChgLogPO memChgLogPO = new MemChgLogPO();
        BeanUtils.copyProperties((Object)oldMemberPO, (Object)memChgLogPO);
        memChgLogPO.setMemLevel(updateMemberPO.getMemLevel());
        memChgLogPO.setLevelEffTime(updateMemberPO.getLevelEffTime());
        memChgLogPO.setLevelExpTime(updateMemberPO.getLevelExpTime());
        memChgLogPO.setOperType(operType);
        memChgLogPO.setOperLoginId(String.valueOf(updateMemberPO.getMemLevel()));
        memChgLogPO.setOperResult("\u8bc4\u7ea7\u540e\u4fee\u6539\u4f1a\u5458\u4fe1\u606f");
        memChgLogPO.setOperDesc("\u66f4\u65b0\u65b0\u4f1a\u5458\u7b49\u7ea7\uff0c\u65b0\u4f1a\u5458\u7b49\u7ea7\u751f\u3001\u5931\u6548\u65f6\u95f4");
        memChgLogPO.setOperTime(new Date());
        return this.memChgLogMapper.insert(memChgLogPO);
    }
}

