/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.umc.busi.UmcMyMailListQueryBusiService;
import com.tydic.umc.busi.bo.MsgBusiBO;
import com.tydic.umc.busi.bo.UmcMyMailListQueryBusiReqBO;
import com.tydic.umc.busi.bo.UmcMyMailListQueryBusiRspBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.dao.MemMsgRecMapper;
import com.tydic.umc.dao.MemberMapper;
import com.tydic.umc.dao.MsgSysMapper;
import com.tydic.umc.po.MemMsgRecPO;
import com.tydic.umc.po.MemberPO;
import com.tydic.umc.po.MsgSysPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcMyMailListQueryBusiService")
public class UmcMyMailListQueryBusiServiceImpl
implements UmcMyMailListQueryBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcMyMailListQueryBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final String SUCCESS_MSG = "\u6211\u7684\u7ad9\u5185\u4fe1\u67e5\u8be2\u670d\u52a1\u6210\u529f";
    private static final String ERROR_MSG = "\u6211\u7684\u7ad9\u5185\u4fe1\u67e5\u8be2\u670d\u52a1\u5931\u8d25,\u6570\u636e\u5e93\u5f02\u5e38";
    @Autowired
    private MsgSysMapper msgSysMapper;
    @Autowired
    private MemMsgRecMapper memMsgRecMapper;
    @Autowired
    private MemberMapper memberMapper;

    public UmcMyMailListQueryBusiRspBO queryMyMailList(UmcMyMailListQueryBusiReqBO reqBO) {
        UmcMyMailListQueryBusiRspBO rspBO = new UmcMyMailListQueryBusiRspBO();
        if ((UmcCommConstant.MsgType.PERSONAL_MSG + "").equals(reqBO.getMsgType())) {
            this.queryPersonalMsg(reqBO, rspBO);
        } else if ((UmcCommConstant.MsgType.SYSTEM_MSG + "").equals(reqBO.getMsgType())) {
            this.querySysMsg(reqBO, rspBO);
        }
        return rspBO;
    }

    private void queryPersonalMsg(UmcMyMailListQueryBusiReqBO reqBO, UmcMyMailListQueryBusiRspBO rspBO) {
        MemMsgRecPO memMsgRecPO = new MemMsgRecPO();
        memMsgRecPO.setMemId(reqBO.getMemId());
        memMsgRecPO.setMsgType(UmcCommConstant.MsgType.PERSONAL_MSG);
        memMsgRecPO.setOrderBy("SEND_TIME DESC");
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<MemMsgRecPO> memMsgRecPOList = this.memMsgRecMapper.getListPageByConditions(memMsgRecPO, (Page<MemMsgRecPO>)page);
        if (null == memMsgRecPOList) {
            rspBO.setRespCode("2044");
            rspBO.setRespDesc(ERROR_MSG);
            return;
        }
        if (memMsgRecPOList.isEmpty()) {
            rspBO.setRows(new ArrayList());
            rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u65e0\u4e2a\u4eba\u6d88\u606f\u8bb0\u5f55");
            return;
        }
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        ArrayList<MsgBusiBO> msgBusiRspBOList = new ArrayList<MsgBusiBO>();
        for (MemMsgRecPO msgRecPO : memMsgRecPOList) {
            MsgBusiBO msgBusiRspBO = new MsgBusiBO();
            BeanUtils.copyProperties((Object)msgRecPO, (Object)msgBusiRspBO);
            msgBusiRspBO.setMsgId(msgRecPO.getId() + "");
            msgBusiRspBO.setSendMemId(msgRecPO.getSendId());
            msgBusiRspBO.setSendTime(DateUtils.dateToStrLong((Date)msgRecPO.getSendTime()));
            msgBusiRspBOList.add(msgBusiRspBO);
        }
        rspBO.setRows(msgBusiRspBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc(SUCCESS_MSG);
    }

    private void querySysMsg(UmcMyMailListQueryBusiReqBO reqBO, UmcMyMailListQueryBusiRspBO rspBO) {
        MemberPO memberPO = new MemberPO();
        memberPO.setMemId(reqBO.getMemId());
        memberPO = this.memberMapper.getModelByCondition(memberPO);
        if (null == memberPO) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug(ERROR_MSG);
            }
            rspBO.setRespCode("2044");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u4f1a\u5458\u4fe1\u606f");
            return;
        }
        MsgSysPO msgSysPO = new MsgSysPO();
        msgSysPO.setMemLevel(memberPO.getMemLevel());
        msgSysPO.setOrderBy("CREATE_TIME DESC");
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<MsgSysPO> msgSysPOList = this.msgSysMapper.getListPageByMailService(msgSysPO, (Page<MsgSysPO>)page);
        if (null == msgSysPOList) {
            rspBO.setRespCode("2044");
            rspBO.setRespDesc(ERROR_MSG);
            return;
        }
        if (msgSysPOList.isEmpty()) {
            rspBO.setRows(new ArrayList());
            rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u65e0\u7cfb\u7edf\u6d88\u606f\u8bb0\u5f55");
            return;
        }
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        ArrayList<MsgBusiBO> msgBusiRspBOList = new ArrayList<MsgBusiBO>();
        for (MsgSysPO sysPO : msgSysPOList) {
            MsgBusiBO msgBusiRspBO = new MsgBusiBO();
            BeanUtils.copyProperties((Object)sysPO, (Object)msgBusiRspBO);
            msgBusiRspBO.setMsgType(UmcCommConstant.MsgType.SYSTEM_MSG);
            msgBusiRspBO.setMsgId(sysPO.getMsgId() + "");
            msgBusiRspBO.setSendMemId("sys");
            msgBusiRspBO.setSendTime(DateUtils.dateToStrLong((Date)sysPO.getCreateTime()));
            MemMsgRecPO memMsgRecPO = new MemMsgRecPO();
            memMsgRecPO.setMemId(reqBO.getMemId());
            memMsgRecPO.setMsgTitle(sysPO.getMsgTitle());
            memMsgRecPO.setMsgContent(sysPO.getMsgContent());
            memMsgRecPO.setMsgType(UmcCommConstant.MsgType.SYSTEM_MSG);
            memMsgRecPO = this.memMsgRecMapper.getModelByConditions(memMsgRecPO);
            if (null == memMsgRecPO) {
                msgBusiRspBO.setSendState(UmcCommConstant.SendState.UNREAD);
            } else {
                msgBusiRspBO.setSendState(UmcCommConstant.SendState.READ);
            }
            msgBusiRspBOList.add(msgBusiRspBO);
        }
        rspBO.setRows(msgBusiRspBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc(SUCCESS_MSG);
    }
}

