/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.umc.atom.UmcMultiCondQueryMemAtomService;
import com.tydic.umc.atom.bo.MemberInfoAtomBO;
import com.tydic.umc.atom.bo.UmcMultiCondQueryMemAtomReqBO;
import com.tydic.umc.atom.bo.UmcMultiCondQueryMemAtomRspBO;
import com.tydic.umc.busi.UmcParseQrAndQryMemBusiService;
import com.tydic.umc.busi.bo.UmcParseQrAndQryMemBusiReqBO;
import com.tydic.umc.busi.bo.UmcParseQrAndQryMemBusiRspBO;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.IntegralMapper;
import com.tydic.umc.po.IntegralPO;
import com.tydic.umc.util.HexadecimalUtils;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcParseQrAndQryMemBusiService")
public class UmcParseQrAndQryMemBusiServiceImpl
implements UmcParseQrAndQryMemBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcParseQrAndQryMemBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private UmcMultiCondQueryMemAtomService umcMultiCondQueryMemAtomService;
    private IntegralMapper integralMapper;

    @Autowired
    public UmcParseQrAndQryMemBusiServiceImpl(UmcMultiCondQueryMemAtomService umcMultiCondQueryMemAtomService, IntegralMapper integralMappe) {
        this.umcMultiCondQueryMemAtomService = umcMultiCondQueryMemAtomService;
        this.integralMapper = integralMappe;
    }

    public UmcParseQrAndQryMemBusiRspBO parseQrAndQryMem(UmcParseQrAndQryMemBusiReqBO umcParseQrAndQryMemBusiReqBO) {
        UmcParseQrAndQryMemBusiRspBO rspBO = new UmcParseQrAndQryMemBusiRspBO();
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u4f1a\u5458\u4e2d\u5fc3\u4e8c\u7ef4\u7801\u89e3\u6790\u548c\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u7684\u5165\u53c2\u4e3a\uff1a" + umcParseQrAndQryMemBusiReqBO.toString());
        }
        Date sysCurrentTime = new Date();
        String qrStr = HexadecimalUtils.hexStringToString(umcParseQrAndQryMemBusiReqBO.getQrStr());
        if (StringUtils.isEmpty((CharSequence)qrStr)) {
            rspBO.setRespCode("2005");
            rspBO.setRespDesc("\u4e8c\u7ef4\u7801\u89e3\u6790\u5931\u8d25");
            return rspBO;
        }
        Long memId = qrStr.contains("$") ? Long.valueOf(qrStr.substring(qrStr.indexOf("$") + 1, qrStr.indexOf("#"))) : Long.valueOf(qrStr.substring(0, qrStr.indexOf("#")));
        Date expTime = DateUtils.strToDateLong((String)qrStr.substring(qrStr.indexOf("#") + 1, qrStr.length()));
        if (sysCurrentTime.compareTo(expTime) > 0) {
            rspBO.setRespCode("2005");
            rspBO.setRespDesc("\u4e8c\u7ef4\u7801\u5df2\u8fc7\u671f");
            return rspBO;
        }
        UmcMultiCondQueryMemAtomReqBO umcMultiCondQueryMemAtomReqBO = new UmcMultiCondQueryMemAtomReqBO();
        umcMultiCondQueryMemAtomReqBO.setMemId(memId);
        UmcMultiCondQueryMemAtomRspBO umcMultiCondQueryMemAtomRspBO = this.umcMultiCondQueryMemAtomService.multiCondQueryMem(umcMultiCondQueryMemAtomReqBO);
        if (!"0000".equals(umcMultiCondQueryMemAtomRspBO.getRespCode())) {
            rspBO.setRespCode("2005");
            rspBO.setRespDesc("\u8c03\u7528[\u4f1a\u5458\u4e2d\u5fc3\u591a\u6761\u4ef6\u67e5\u8be2\u4f1a\u5458\u539f\u5b50\u670d\u52a1]\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u5931\u8d25");
            return rspBO;
        }
        MemberInfoAtomBO memberInfoAtomBO = umcMultiCondQueryMemAtomRspBO.getMemberInfoAtomBO();
        if (memberInfoAtomBO == null) {
            rspBO.setRespCode("2005");
            rspBO.setRespDesc("\u4f1a\u5458\u4fe1\u606f\u4e0d\u5b58\u5728");
            return rspBO;
        }
        BeanUtils.copyProperties((Object)memberInfoAtomBO, (Object)rspBO);
        Long totalEffectIntegral = 0L;
        Long totalInvalidIntegral = 0L;
        IntegralPO qryAllIntegralModel = new IntegralPO();
        qryAllIntegralModel.setMemId(memId);
        List<IntegralPO> allIntegralPOS = this.integralMapper.getListByCondition(qryAllIntegralModel);
        for (IntegralPO integralPO : allIntegralPOS) {
            if (UmcEnumConstant.IntegralState.LOSE_EFFICACY.getCode().equals(integralPO.getState())) {
                totalInvalidIntegral = totalInvalidIntegral + integralPO.getIntegral();
                continue;
            }
            if (!UmcEnumConstant.IntegralState.EFFECTIVE.getCode().equals(integralPO.getState())) continue;
            totalEffectIntegral = totalEffectIntegral + integralPO.getIntegral();
        }
        rspBO.setTotalEffectIntegral(totalEffectIntegral);
        rspBO.setTotalInvalidIntegral(totalInvalidIntegral);
        rspBO.setRespDesc("0000");
        rspBO.setRespDesc("\u4f1a\u5458\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }
}

