/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.umc.busi.DictionaryBusiService;
import com.tydic.umc.busi.UmcQryCouponListBusiService;
import com.tydic.umc.busi.bo.CouponTypeBO;
import com.tydic.umc.busi.bo.UmcMemCouponBusiBO;
import com.tydic.umc.busi.bo.UmcQryCouponListBusiReqBO;
import com.tydic.umc.busi.bo.UmcQryCouponListBusiRspBO;
import com.tydic.umc.dao.MemCouponMapper;
import com.tydic.umc.po.MemCouponPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcQryCouponListBusiService")
public class UmcQryCouponListBusiServiceImpl
implements UmcQryCouponListBusiService {
    private MemCouponMapper memCouponMapper;
    private DictionaryBusiService dictionaryBusiService;

    @Autowired
    public UmcQryCouponListBusiServiceImpl(MemCouponMapper memCouponMapper, DictionaryBusiService dictionaryBusiService) {
        this.memCouponMapper = memCouponMapper;
        this.dictionaryBusiService = dictionaryBusiService;
    }

    public UmcQryCouponListBusiRspBO qryCouponList(UmcQryCouponListBusiReqBO busiReqBO) {
        UmcQryCouponListBusiRspBO rsp = new UmcQryCouponListBusiRspBO();
        Page page = new Page(busiReqBO.getPageNo().intValue(), busiReqBO.getPageSize().intValue());
        List<MemCouponPO> memCouponPOList = this.memCouponMapper.getListPageByConditionBySpecial(busiReqBO, (Page<MemCouponPO>)page);
        if (null == memCouponPOList || memCouponPOList.size() <= 0) {
            rsp.setPageNo(Integer.valueOf(page.getPageNo()));
            rsp.setTotal(Integer.valueOf(page.getTotalPages()));
            rsp.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u4f18\u60e0\u5238\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        Map couponkindMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC", "COUPON_KIND");
        Map usedStateMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC", "COUPON_USED_STATE");
        ArrayList<UmcMemCouponBusiBO> umcMemCouponBusiBOList = new ArrayList<UmcMemCouponBusiBO>();
        BigDecimal bd = new BigDecimal(10);
        for (MemCouponPO po : memCouponPOList) {
            UmcMemCouponBusiBO umcMemCouponBusiBO = new UmcMemCouponBusiBO();
            BeanUtils.copyProperties((Object)po, (Object)umcMemCouponBusiBO);
            try {
                if (null != po.getCouponValue()) {
                    umcMemCouponBusiBO.setCouponValue(MoneyUtils.Long2BigDecimal((Long)po.getCouponValue().longValue()));
                }
                if (null != po.getCouponBalance()) {
                    umcMemCouponBusiBO.setCouponBalance(MoneyUtils.Long2BigDecimal((Long)po.getCouponBalance().longValue()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (null != po.getUsedState()) {
                umcMemCouponBusiBO.setUsedStateStr((String)usedStateMap.get(po.getUsedState().toString()));
            }
            if (null != po.getCouponKind()) {
                umcMemCouponBusiBO.setCouponKindStr((String)couponkindMap.get(po.getCouponKind().toString()));
            }
            if (null != po.getCouponJson()) {
                String json = po.getCouponJson();
                CouponTypeBO couponTypeBO = (CouponTypeBO)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)json), CouponTypeBO.class);
                if (null != couponTypeBO.getConditionType()) {
                    BigDecimal couponSize;
                    if (couponTypeBO.getConditionType() == 1 && couponTypeBO.getDiscountType() == 1 && null != couponTypeBO.getDiscountValue()) {
                        couponSize = new BigDecimal(couponTypeBO.getDiscountValue());
                        BigDecimal couponSize1 = bd.multiply(couponSize);
                        umcMemCouponBusiBO.setCouponRemark("\u6ee1" + couponTypeBO.getConditionValue() + "\u4ef6\u4eab" + couponSize1 + "\u6298\u4f18\u60e0");
                    }
                    if (couponTypeBO.getConditionType() == 1 && couponTypeBO.getDiscountType() == 2) {
                        umcMemCouponBusiBO.setCouponRemark("\u6ee1" + couponTypeBO.getConditionValue() + "\u4ef6\u51cf" + couponTypeBO.getDiscountValue() + "\u5143");
                    }
                    if (couponTypeBO.getConditionType() == 2 && couponTypeBO.getDiscountType() == 1 && null != couponTypeBO.getDiscountValue()) {
                        couponSize = new BigDecimal(couponTypeBO.getDiscountValue());
                        BigDecimal couponSize2 = bd.multiply(couponSize);
                        umcMemCouponBusiBO.setCouponRemark("\u6ee1" + couponTypeBO.getConditionValue() + "\u5143\u4eab" + couponSize2 + "\u6298\u4f18\u60e0");
                    }
                    if (couponTypeBO.getConditionType() == 2 && couponTypeBO.getDiscountType() == 2) {
                        umcMemCouponBusiBO.setCouponRemark("\u6ee1" + couponTypeBO.getConditionValue() + "\u5143\u51cf" + couponTypeBO.getDiscountValue() + "\u5143");
                    }
                }
                umcMemCouponBusiBO.setConditionValue(couponTypeBO.getConditionValue());
            }
            umcMemCouponBusiBOList.add(umcMemCouponBusiBO);
        }
        rsp.setRows(umcMemCouponBusiBOList);
        rsp.setPageNo(Integer.valueOf(page.getPageNo()));
        rsp.setTotal(Integer.valueOf(page.getTotalPages()));
        rsp.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4f1a\u5458\u4e2d\u5fc3\u4f1a\u5458\u4f18\u60e0\u5238\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }
}

