/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.umc.busi.UmcQryNearExpIntegralBusiService;
import com.tydic.umc.busi.bo.IntegralBusiBO;
import com.tydic.umc.busi.bo.UmcQryNearExpIntegralBusiReqBO;
import com.tydic.umc.busi.bo.UmcQryNearExpIntegralBusiRspBO;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.IntegralMapper;
import com.tydic.umc.po.IntegralPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcQryNearExpIntegralBusiService")
public class UmcQryNearExpIntegralBusiServiceImpl
implements UmcQryNearExpIntegralBusiService {
    private IntegralMapper integralMapper;

    @Autowired
    public UmcQryNearExpIntegralBusiServiceImpl(IntegralMapper integralMapper) {
        this.integralMapper = integralMapper;
    }

    public UmcQryNearExpIntegralBusiRspBO qryNearExpIntegral(UmcQryNearExpIntegralBusiReqBO busiReqBO) {
        UmcQryNearExpIntegralBusiRspBO rsp = new UmcQryNearExpIntegralBusiRspBO();
        Page page = new Page(busiReqBO.getPageNo().intValue(), busiReqBO.getPageSize().intValue());
        IntegralPO integralPO = new IntegralPO();
        integralPO.setMemId(busiReqBO.getMemId());
        integralPO.setState(UmcEnumConstant.IntegralState.EFFECTIVE.getCode());
        integralPO.setExpTime(busiReqBO.getExpTime());
        integralPO.setOrderBy("EXP_TIME");
        List<IntegralPO> integralPOList = this.integralMapper.getListPageByCondition(integralPO, (Page<IntegralPO>)page);
        if (null == integralPOList || integralPOList.size() <= 0) {
            rsp.setPageNo(Integer.valueOf(page.getPageNo()));
            rsp.setTotal(Integer.valueOf(page.getTotalPages()));
            rsp.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u5373\u5c06\u8fc7\u671f\u79ef\u5206\u65e5\u5fd7\u8bb0\u5f55\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        ArrayList<IntegralBusiBO> integralBusiBOList = new ArrayList<IntegralBusiBO>();
        for (IntegralPO po : integralPOList) {
            IntegralBusiBO integralBusiBO = new IntegralBusiBO();
            BeanUtils.copyProperties((Object)po, (Object)integralBusiBO);
            integralBusiBOList.add(integralBusiBO);
        }
        Long totalIntegral = this.calculationTotalIntegral(busiReqBO);
        rsp.setRows(integralBusiBOList);
        rsp.setTotalIntegral(totalIntegral);
        rsp.setPageNo(Integer.valueOf(page.getPageNo()));
        rsp.setTotal(Integer.valueOf(page.getTotalPages()));
        rsp.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4f1a\u5458\u4e2d\u5fc3\u79ef\u5206\u83b7\u53d6\u8bb0\u5f55\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }

    private Long calculationTotalIntegral(UmcQryNearExpIntegralBusiReqBO busiReqBO) {
        Long totalIntegral = 0L;
        IntegralPO integralPO = new IntegralPO();
        integralPO.setMemId(busiReqBO.getMemId());
        integralPO.setState(UmcEnumConstant.IntegralState.EFFECTIVE.getCode());
        integralPO.setExpTime(new Date());
        integralPO.setOrderBy("EXP_TIME");
        List<IntegralPO> integralPOList = this.integralMapper.getListByCondition(integralPO);
        for (IntegralPO po : integralPOList) {
            totalIntegral = totalIntegral + po.getIntegral();
        }
        return totalIntegral;
    }
}

