/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.umc.busi.DictionaryBusiService;
import com.tydic.umc.busi.UmcQryWalletBalanceBusiService;
import com.tydic.umc.busi.bo.UmcQryWalletBalanceBusiReqBO;
import com.tydic.umc.busi.bo.UmcQryWalletBalanceBusiRspBO;
import com.tydic.umc.common.UmcWalletBalanceRspBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.dao.MemberWalletMapper;
import com.tydic.umc.po.MemberWalletPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="umcQryWalletBalanceBusiService")
public class UmcQryWalletBalanceBusiServiceImpl
implements UmcQryWalletBalanceBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcQryWalletBalanceBusiServiceImpl.class);
    @Autowired
    private MemberWalletMapper memberWalletMapper;
    @Autowired
    private DictionaryBusiService dictionaryBusiService;

    public UmcQryWalletBalanceBusiRspBO qryWalletBalance(UmcQryWalletBalanceBusiReqBO busiReqBO) {
        UmcQryWalletBalanceBusiRspBO busiRspBO = new UmcQryWalletBalanceBusiRspBO();
        ArrayList<UmcWalletBalanceRspBO> rows = new ArrayList<UmcWalletBalanceRspBO>();
        MemberWalletPO memberWalletPO = new MemberWalletPO();
        memberWalletPO.setMemId(busiReqBO.getMemId());
        memberWalletPO.setMemIds(busiReqBO.getMemIds());
        memberWalletPO.setWalletType(busiReqBO.getWalletType());
        memberWalletPO.setIsExpire(busiReqBO.getIsExpire());
        List<MemberWalletPO> balancePOList = this.memberWalletMapper.qryWalletBalance(memberWalletPO);
        ArrayList<Long> memIds = new ArrayList<Long>();
        if (null == busiReqBO.getMemId()) {
            memIds.addAll(busiReqBO.getMemIds());
        } else {
            memIds.add(busiReqBO.getMemId());
        }
        if (CollectionUtils.isEmpty(balancePOList)) {
            ArrayList<UmcWalletBalanceRspBO> bos = new ArrayList<UmcWalletBalanceRspBO>();
            this.createDefaul(memIds, bos);
            busiRspBO.setRows(bos);
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u6210\u529f");
            return busiRspBO;
        }
        Map walletTypeMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC", "WALLET_TYPT");
        for (MemberWalletPO po : balancePOList) {
            ListIterator memIdIt = memIds.listIterator();
            UmcWalletBalanceRspBO umcWalletBalanceRspBO = new UmcWalletBalanceRspBO();
            BeanUtils.copyProperties((Object)po, (Object)umcWalletBalanceRspBO);
            if (null != po.getMemId()) {
                umcWalletBalanceRspBO.setMemId(po.getMemId());
            }
            if (null != po.getWalletId()) {
                umcWalletBalanceRspBO.setWalletId(po.getWalletId());
            }
            if (null != po.getWalletType()) {
                umcWalletBalanceRspBO.setWalletType(po.getWalletType());
                umcWalletBalanceRspBO.setWalletTypeStr((String)walletTypeMap.get(po.getWalletType().toString()));
            }
            if (null != po.getBalance()) {
                try {
                    umcWalletBalanceRspBO.setBalance(MoneyUtils.Long2BigDecimal((Long)po.getBalance()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (null != po.getAvailableBalance()) {
                try {
                    umcWalletBalanceRspBO.setAvailableBalance(MoneyUtils.Long2BigDecimal((Long)po.getAvailableBalance()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (null != po.getUsedAmount()) {
                try {
                    umcWalletBalanceRspBO.setUsedAmount(MoneyUtils.Long2BigDecimal((Long)po.getUsedAmount()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (null != po.getLockAmount()) {
                try {
                    umcWalletBalanceRspBO.setLockAmount(MoneyUtils.Long2BigDecimal((Long)po.getLockAmount()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            rows.add(umcWalletBalanceRspBO);
            this.removeExist(memIdIt, po.getMemId());
        }
        if (!CollectionUtils.isEmpty(memIds)) {
            ArrayList<UmcWalletBalanceRspBO> bos = new ArrayList<UmcWalletBalanceRspBO>();
            this.createDefaul(memIds, bos);
            rows.addAll(bos);
        }
        busiRspBO.setRows(rows);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u94b1\u5305\u4f59\u989d\u67e5\u8be2\u6210\u529f\uff01");
        LOGGER.debug("busiRspBO :" + JSON.toJSONString((Object)busiRspBO));
        return busiRspBO;
    }

    private void removeExist(Iterator it, Long memId) {
        while (it.hasNext()) {
            Object obj = it.next();
            if (null == obj || !memId.equals((Long)obj)) continue;
            it.remove();
            break;
        }
    }

    private void createDefaul(List<Long> memIds, List<UmcWalletBalanceRspBO> bos) {
        BigDecimal balance = new BigDecimal(0);
        for (Long memId : memIds) {
            UmcWalletBalanceRspBO bo = new UmcWalletBalanceRspBO();
            bo.setMemId(memId);
            bo.setAvailableBalance(balance);
            bo.setBalance(balance);
            bo.setLockAmount(balance);
            bo.setUsedAmount(balance);
            bo.setWalletType(UmcCommConstant.WALLET_TYPE.BALANCE);
            bos.add(bo);
        }
    }
}

