/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.umc.base.bo.UmcRspBaseBO;
import com.tydic.umc.base.bo.UmcRspListBO;
import com.tydic.umc.base.bo.UmcRspPageBO;
import com.tydic.umc.busi.UmcRegionManageBusiService;
import com.tydic.umc.busi.bo.AddrAreaBO;
import com.tydic.umc.busi.bo.AddrCityBO;
import com.tydic.umc.busi.bo.AddrProvinceBO;
import com.tydic.umc.busi.bo.AddrTownsBO;
import com.tydic.umc.busi.bo.UmcQueryRegionBusiReqBO;
import com.tydic.umc.dao.AddrAreaDAO;
import com.tydic.umc.dao.AddrCityDAO;
import com.tydic.umc.dao.AddrProvinceDAO;
import com.tydic.umc.dao.AddrTownsDAO;
import com.tydic.umc.dao.RegionsMapper;
import com.tydic.umc.po.AddrAreaPO;
import com.tydic.umc.po.AddrCityPO;
import com.tydic.umc.po.AddrProvincePO;
import com.tydic.umc.po.AddrTownsPO;
import com.tydic.umc.po.RegionsPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="umcRegionManageBusiService")
public class UmcRegionManageBusiServiceImpl
implements UmcRegionManageBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcRegionManageBusiServiceImpl.class);
    @Autowired
    private AddrProvinceDAO addrProvinceDAO;
    @Autowired
    private AddrCityDAO addrCityDAO;
    @Autowired
    private AddrAreaDAO addrAreaDAO;
    @Autowired
    private AddrTownsDAO addrTownsDAO;
    @Autowired
    private RegionsMapper regionsMapper;

    public UmcRspListBO<AddrProvinceBO> queryProvinceList(UmcQueryRegionBusiReqBO busiReqBO) {
        AddrAreaPO addrAreaPO = new AddrAreaPO();
        addrAreaPO.setName(busiReqBO.getProvinceName());
        ArrayList<AddrProvinceBO> rows = new ArrayList<AddrProvinceBO>();
        UmcRspListBO result = new UmcRspListBO();
        List<AddrProvincePO> daoList = this.addrProvinceDAO.selectAll(addrAreaPO);
        if (!CollectionUtils.isEmpty(daoList)) {
            for (AddrProvincePO po : daoList) {
                AddrProvinceBO bo = new AddrProvinceBO();
                bo.setProvinceCode(po.getCode());
                bo.setProvinceName(po.getName());
                bo.setCode(po.getCode());
                bo.setName(po.getName());
                rows.add(bo);
            }
        }
        result.setRespCode("0000");
        result.setRespDesc("\u67e5\u8be2\u6210\u529f");
        result.setRows(rows);
        return result;
    }

    public UmcRspPageBO<AddrProvinceBO> queryProvinceListPage(UmcQueryRegionBusiReqBO busiReqBO) {
        Page page = new Page(busiReqBO.getPageNo().intValue(), busiReqBO.getPageSize().intValue());
        AddrAreaPO addrAreaPO = new AddrAreaPO();
        addrAreaPO.setName(busiReqBO.getProvinceName());
        ArrayList<AddrProvinceBO> rows = new ArrayList<AddrProvinceBO>();
        UmcRspPageBO result = new UmcRspPageBO();
        List<AddrProvincePO> daoList = this.addrProvinceDAO.selectAllPage(addrAreaPO, page);
        if (!CollectionUtils.isEmpty(daoList)) {
            for (AddrProvincePO po : daoList) {
                AddrProvinceBO bo = new AddrProvinceBO();
                bo.setProvinceCode(po.getCode());
                bo.setProvinceName(po.getName());
                bo.setCode(po.getCode());
                bo.setName(po.getName());
                rows.add(bo);
            }
        }
        result.setRespCode("0000");
        result.setRespDesc("\u67e5\u8be2\u6210\u529f");
        result.setRows(rows);
        result.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        result.setTotal(Integer.valueOf(page.getTotalPages()));
        result.setPageNo(Integer.valueOf(page.getPageNo()));
        return result;
    }

    public UmcRspListBO<AddrAreaBO> queryAreaList(UmcQueryRegionBusiReqBO busiReqBO) {
        AddrAreaPO addrAreaPO = new AddrAreaPO();
        addrAreaPO.setCityCode(busiReqBO.getCityCode());
        List<AddrAreaPO> daoList = this.addrAreaDAO.selectByRecord(addrAreaPO);
        ArrayList<AddrAreaBO> rows = new ArrayList<AddrAreaBO>();
        if (!CollectionUtils.isEmpty(daoList)) {
            for (AddrAreaPO po : daoList) {
                AddrAreaBO bo = new AddrAreaBO();
                bo.setAreaCode(po.getCode());
                bo.setAreaName(po.getName());
                bo.setCode(po.getCode());
                bo.setName(po.getName());
                bo.setCityCode(po.getCityCode());
                rows.add(bo);
            }
        }
        UmcRspListBO result = new UmcRspListBO();
        result.setRespCode("0000");
        result.setRespDesc("\u67e5\u8be2\u6210\u529f");
        result.setRows(rows);
        return result;
    }

    public UmcRspListBO<AddrCityBO> queryCityList(UmcQueryRegionBusiReqBO busiReqBO) {
        AddrCityPO addrCityPO = new AddrCityPO();
        addrCityPO.setProvinceCode(busiReqBO.getProvinceCode());
        List<AddrCityPO> daoList = this.addrCityDAO.selectByRecord(addrCityPO);
        ArrayList<AddrCityBO> rows = new ArrayList<AddrCityBO>();
        if (!CollectionUtils.isEmpty(daoList)) {
            for (AddrCityPO po : daoList) {
                AddrCityBO bo = new AddrCityBO();
                bo.setCityCode(po.getCode());
                bo.setCityName(po.getName());
                bo.setCode(po.getCode());
                bo.setName(po.getName());
                bo.setProvinceCode(po.getProvinceCode());
                rows.add(bo);
            }
        }
        UmcRspListBO result = new UmcRspListBO();
        result.setRespCode("0000");
        result.setRespDesc("\u67e5\u8be2\u6210\u529f");
        result.setRows(rows);
        return result;
    }

    public UmcRspListBO<AddrTownsBO> queryTownList(UmcQueryRegionBusiReqBO busiReqBO) {
        UmcRspListBO result = new UmcRspListBO();
        ArrayList<AddrTownsBO> rows = new ArrayList<AddrTownsBO>();
        AddrTownsPO addrTownsPO = new AddrTownsPO();
        addrTownsPO.setAreaCode(busiReqBO.getAreaCode());
        List<AddrTownsPO> daoList = this.addrTownsDAO.selectByRecord(addrTownsPO);
        if (!CollectionUtils.isEmpty(daoList)) {
            for (AddrTownsPO po : daoList) {
                AddrTownsBO bo = new AddrTownsBO();
                bo.setTownCode(po.getCode());
                bo.setCode(po.getCode());
                bo.setName(po.getName());
                bo.setTownName(po.getName());
                bo.setAreaCode(po.getAreaCode());
                rows.add(bo);
            }
        }
        result.setRespCode("0000");
        result.setRespDesc("\u67e5\u8be2\u6210\u529f");
        result.setRows(rows);
        return result;
    }

    public UmcRspBaseBO updateRegionAll() {
        UmcRspBaseBO rspBO = new UmcRspBaseBO();
        RegionsPO condition = new RegionsPO();
        ArrayList<AddrProvincePO> addrProvinceList = new ArrayList<AddrProvincePO>();
        ArrayList<AddrCityPO> addrCityList = new ArrayList<AddrCityPO>();
        ArrayList<AddrAreaPO> addrAreaList = new ArrayList<AddrAreaPO>();
        ArrayList<AddrTownsPO> addrTownsList = new ArrayList<AddrTownsPO>();
        List<RegionsPO> regionsList = this.regionsMapper.getList(condition);
        for (RegionsPO regionsPO : regionsList) {
            Map json;
            List areaList;
            boolean addFlag;
            AddrCityPO addrCityPO = new AddrCityPO();
            AddrProvincePO addrProvincePO = new AddrProvincePO();
            if (CollectionUtils.isEmpty(addrProvinceList)) {
                addrProvincePO.setCode(String.valueOf(regionsPO.getProvince()));
                addrProvincePO.setName(regionsPO.getProvinceName());
                addrProvinceList.add(addrProvincePO);
            } else {
                addFlag = true;
                for (AddrProvincePO addrProvincePO2 : addrProvinceList) {
                    String province = String.valueOf(regionsPO.getProvince());
                    if (!addrProvincePO2.getCode().equals(province)) continue;
                    addFlag = false;
                    break;
                }
                LOGGER.debug("addFlag" + addFlag);
                if (addFlag) {
                    addrProvincePO.setCode(String.valueOf(regionsPO.getProvince()));
                    addrProvincePO.setName(regionsPO.getProvinceName());
                    addrProvinceList.add(addrProvincePO);
                }
            }
            if (CollectionUtils.isEmpty(addrCityList)) {
                addrCityPO.setCode(String.valueOf(regionsPO.getCity()));
                addrCityPO.setName(regionsPO.getCityName());
                addrCityPO.setProvinceCode(String.valueOf(regionsPO.getProvince()));
                addrCityList.add(addrCityPO);
            } else {
                addFlag = true;
                for (AddrCityPO addrCityPO2 : addrCityList) {
                    String city = String.valueOf(regionsPO.getCity());
                    if (!addrCityPO2.getCode().equals(city)) continue;
                    addFlag = false;
                    break;
                }
                if (addFlag) {
                    addrCityPO.setCode(String.valueOf(regionsPO.getCity()));
                    addrCityPO.setName(regionsPO.getCityName());
                    addrCityPO.setProvinceCode(String.valueOf(regionsPO.getProvince()));
                    addrCityList.add(addrCityPO);
                }
            }
            if (CollectionUtils.isEmpty((Collection)(areaList = (List)(json = (Map)JSONObject.parse((String)regionsPO.getRegionsJson())).get("regionList")))) continue;
            for (Map area : areaList) {
                AddrAreaPO areaPO = new AddrAreaPO();
                areaPO.setCode(String.valueOf(area.get("code")));
                areaPO.setName(String.valueOf(area.get("name")));
                areaPO.setCityCode(addrCityPO.getCode());
                addrAreaList.add(areaPO);
                List townList = (List)area.get("regionList");
                if (CollectionUtils.isEmpty((Collection)townList)) continue;
                for (Map town : townList) {
                    AddrTownsPO townsPO = new AddrTownsPO();
                    townsPO.setCode(String.valueOf(town.get("code")));
                    townsPO.setName(String.valueOf(town.get("name")));
                    townsPO.setAreaCode(areaPO.getCode());
                    addrTownsList.add(townsPO);
                }
            }
        }
        for (AddrProvincePO addrProvincePO : addrProvinceList) {
            this.addrProvinceDAO.insert(addrProvincePO);
        }
        for (AddrCityPO addrCityPO : addrCityList) {
            this.addrCityDAO.insert(addrCityPO);
        }
        for (AddrAreaPO addrAreaPO : addrAreaList) {
            this.addrAreaDAO.insert(addrAreaPO);
        }
        for (AddrTownsPO addrTownsPO : addrTownsList) {
            this.addrTownsDAO.insert(addrTownsPO);
        }
        return rspBO;
    }
}

