/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.umc.busi.UmcRelationUnionAddBusiService;
import com.tydic.umc.busi.bo.UmcRelationUnionAddBusiReqBO;
import com.tydic.umc.busi.bo.UmcRelationUnionAddBusiRspBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.dao.UmcRelationUnionMapper;
import com.tydic.umc.po.UmcRelationUnionPO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.ArrayList;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UmcRelationUnionAddBusiServiceImpl
implements UmcRelationUnionAddBusiService {
    @Autowired
    private UmcRelationUnionMapper umcRelationUnionMapper;

    public UmcRelationUnionAddBusiRspBO addRelation(UmcRelationUnionAddBusiReqBO reqBO) {
        HashSet relationIdSet = new HashSet(reqBO.getRelationIdList());
        HashSet memIdSet = new HashSet(reqBO.getMemIdList());
        ArrayList<Long> ids = new ArrayList<Long>(relationIdSet.size());
        ArrayList<UmcRelationUnionPO> insertPOlist = new ArrayList<UmcRelationUnionPO>();
        for (Long memId : memIdSet) {
            for (Long relationId : relationIdSet) {
                UmcRelationUnionPO po = new UmcRelationUnionPO();
                po.setRelationId1(memId);
                po.setRelationId2(relationId);
                po.setDelStatus(UmcCommConstant.RelationDelStatus.NO);
                po.setType(reqBO.getType());
                po = this.umcRelationUnionMapper.getRelationLimitOne(po);
                if (po == null) {
                    UmcRelationUnionPO insetPO = new UmcRelationUnionPO();
                    insetPO.setId(Sequence.getInstance().nextId());
                    insetPO.setDelStatus(UmcCommConstant.RelationDelStatus.NO);
                    insetPO.setType(reqBO.getType());
                    insetPO.setRelationId1(memId);
                    insetPO.setRelationId2(relationId);
                    insetPO.setRemark(reqBO.getRemark());
                    ids.add(insetPO.getId());
                    insertPOlist.add(insetPO);
                    continue;
                }
                ids.add(po.getId());
            }
        }
        UmcRelationUnionAddBusiRspBO rspBO = new UmcRelationUnionAddBusiRspBO();
        if (CollectionUtils.isEmpty(insertPOlist)) {
            rspBO.setIds(ids);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u65b0\u589e\u6210\u529f");
            return rspBO;
        }
        int result = this.umcRelationUnionMapper.insertbatch(insertPOlist);
        if (result != insertPOlist.size()) {
            throw new UmcBusinessException("8888", "\u65b0\u589e\u5931\u8d25");
        }
        rspBO.setIds(ids);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u65b0\u589e\u6210\u529f");
        return rspBO;
    }
}

