/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.tydic.umc.atom.UmcIntegralAddAtomService;
import com.tydic.umc.atom.UmcJudContAndRptSignAtomService;
import com.tydic.umc.atom.UmcSignAddAtomService;
import com.tydic.umc.atom.bo.UmcIntegralAddAtomReqBO;
import com.tydic.umc.atom.bo.UmcIntegralAddAtomRspBO;
import com.tydic.umc.atom.bo.UmcJudContAndRptSignAtomReqBO;
import com.tydic.umc.atom.bo.UmcJudContAndRptSignAtomRspBO;
import com.tydic.umc.atom.bo.UmcSignAddAtomReqBO;
import com.tydic.umc.atom.bo.UmcSignAddAtomRspBO;
import com.tydic.umc.busi.UmcSignGiveIntegralBusiService;
import com.tydic.umc.busi.bo.UmcSignGiveIntegralBusiReqBO;
import com.tydic.umc.busi.bo.UmcSignGiveIntegralBusiRspBO;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.util.UmcBusinessException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcSignGiveIntegralBusiService")
public class UmcSignGiveIntegralBusiServiceImpl
implements UmcSignGiveIntegralBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcSignGiveIntegralBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private UmcJudContAndRptSignAtomService umcJudContAndRptSignAtomService;
    private UmcSignAddAtomService umcSignAddAtomService;
    private UmcIntegralAddAtomService umcIntegralAddAtomService;

    @Autowired
    public UmcSignGiveIntegralBusiServiceImpl(UmcJudContAndRptSignAtomService umcJudContAndRptSignAtomService, UmcSignAddAtomService umcSignAddAtomService, UmcIntegralAddAtomService umcIntegralAddAtomService) {
        this.umcJudContAndRptSignAtomService = umcJudContAndRptSignAtomService;
        this.umcSignAddAtomService = umcSignAddAtomService;
        this.umcIntegralAddAtomService = umcIntegralAddAtomService;
    }

    public UmcSignGiveIntegralBusiRspBO addSignAndIntegral(UmcSignGiveIntegralBusiReqBO umcSignGiveIntegralBusiReqBO) {
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u6267\u884c\u4f1a\u5458\u7b7e\u5230\u9001\u79ef\u5206\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u4e3a\uff1a" + umcSignGiveIntegralBusiReqBO.toString());
        }
        UmcSignGiveIntegralBusiRspBO rspBO = new UmcSignGiveIntegralBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u7b7e\u5230\u9001\u79ef\u5206\u6210\u529f");
        Long memId = umcSignGiveIntegralBusiReqBO.getMemId();
        String signDesc = umcSignGiveIntegralBusiReqBO.getSignDesc();
        String signPicRul = umcSignGiveIntegralBusiReqBO.getSignPicRul();
        Integer signSystem = umcSignGiveIntegralBusiReqBO.getSignSystem();
        Long recvIntegral = umcSignGiveIntegralBusiReqBO.getRecvIntegral();
        UmcJudContAndRptSignAtomRspBO umcJudContAndRptSignAtomRspBO = this.judgeSignContinue(memId);
        if (!"0000".equals(umcJudContAndRptSignAtomRspBO.getRespCode())) {
            rspBO.setRespCode(umcJudContAndRptSignAtomRspBO.getRespCode());
            rspBO.setRespDesc(umcJudContAndRptSignAtomRspBO.getRespDesc());
            return rspBO;
        }
        UmcSignAddAtomRspBO umcSignAddAtomRspBO = this.signRecord(memId, recvIntegral, signDesc, signPicRul, signSystem, umcJudContAndRptSignAtomRspBO);
        if (!"0000".equals(umcSignAddAtomRspBO.getRespCode())) {
            throw new UmcBusinessException("2004", "\u7b7e\u5230\u5931\u8d25!");
        }
        UmcIntegralAddAtomRspBO umcIntegralAddAtomRspBO = this.addIntegral(memId, recvIntegral);
        if (!"0000".equals(umcIntegralAddAtomRspBO.getRespCode())) {
            throw new UmcBusinessException("2004", "\u79ef\u5206\u8d60\u9001\u5931\u8d25!");
        }
        return rspBO;
    }

    private UmcJudContAndRptSignAtomRspBO judgeSignContinue(Long memId) {
        UmcJudContAndRptSignAtomReqBO reqBO = new UmcJudContAndRptSignAtomReqBO();
        reqBO.setMemId(memId);
        return this.umcJudContAndRptSignAtomService.judgeSignContinue(reqBO);
    }

    private UmcSignAddAtomRspBO signRecord(Long memId, Long newIntegral, String signDesc, String signPicRul, Integer signSystem, UmcJudContAndRptSignAtomRspBO umcJudContAndRptSignAtomRspBO) {
        UmcSignAddAtomReqBO umcSignAddAtomReqBO = new UmcSignAddAtomReqBO();
        umcSignAddAtomReqBO.setMemId(memId);
        umcSignAddAtomReqBO.setRecvIntegral(newIntegral);
        umcSignAddAtomReqBO.setContinuityNum(umcJudContAndRptSignAtomRspBO.getContinuityNum());
        umcSignAddAtomReqBO.setSignDate(umcJudContAndRptSignAtomRspBO.getSignDate());
        umcSignAddAtomReqBO.setSignTime(umcJudContAndRptSignAtomRspBO.getSignTime());
        umcSignAddAtomReqBO.setSignDesc(signDesc);
        umcSignAddAtomReqBO.setSignPicRul(signPicRul);
        umcSignAddAtomReqBO.setSignSystem(signSystem);
        return this.umcSignAddAtomService.insertSign(umcSignAddAtomReqBO);
    }

    private UmcIntegralAddAtomRspBO addIntegral(Long memId, Long newIntegral) {
        UmcIntegralAddAtomReqBO reqBO = new UmcIntegralAddAtomReqBO();
        reqBO.setMemId(memId);
        reqBO.setIntegral(newIntegral);
        reqBO.setState(UmcEnumConstant.IntegralState.EFFECTIVE.getCode());
        reqBO.setCreateTime(new Date());
        reqBO.setOperCode(UmcEnumConstant.AddIntegralOperCode.SIGN_IN.getCode());
        reqBO.setOperResult("\u64cd\u4f5c\u4e1a\u52a1\u7f16\u7801[" + UmcEnumConstant.AddIntegralOperCode.SIGN_IN.getCode() + "]\u589e\u52a0\u79ef\u5206");
        reqBO.setOperDesc("\u64cd\u4f5c\u4e1a\u52a1\u7f16\u7801[" + UmcEnumConstant.AddIntegralOperCode.SIGN_IN.getCode() + "]\u589e\u52a0\u79ef\u5206");
        return this.umcIntegralAddAtomService.insertIntegral(reqBO);
    }
}

