/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.tydic.umc.atom.UmcGrowValueDeductAtomService;
import com.tydic.umc.atom.UmcRuleCalculateAtomService;
import com.tydic.umc.atom.bo.UmcGrowValueDeductAtomReqBO;
import com.tydic.umc.atom.bo.UmcGrowValueDeductAtomRspBO;
import com.tydic.umc.atom.bo.UmcRuleCalculateAtomReqBO;
import com.tydic.umc.atom.bo.UmcRuleCalculateAtomRspBO;
import com.tydic.umc.busi.UmcTimingTaskMemRatingBusiService;
import com.tydic.umc.busi.bo.UmcTimingTaskMemRatingBusiReqBO;
import com.tydic.umc.busi.bo.UmcTimingTaskMemRatingBusiRspBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.OperRuleMapper;
import com.tydic.umc.po.OperRulePO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcTimingTaskMemRatingBusiService")
public class UmcTimingTaskMemRatingBusiServiceImpl
implements UmcTimingTaskMemRatingBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcTimingTaskMemRatingBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private OperRuleMapper operRuleMapper;
    private UmcRuleCalculateAtomService umcRuleCalculateAtomService;
    private UmcGrowValueDeductAtomService umcGrowValueDeductAtomService;

    @Autowired
    public UmcTimingTaskMemRatingBusiServiceImpl(OperRuleMapper operRuleMapper, UmcRuleCalculateAtomService umcRuleCalculateAtomService, UmcGrowValueDeductAtomService umcGrowValueDeductAtomService) {
        this.operRuleMapper = operRuleMapper;
        this.umcRuleCalculateAtomService = umcRuleCalculateAtomService;
        this.umcGrowValueDeductAtomService = umcGrowValueDeductAtomService;
    }

    public UmcTimingTaskMemRatingBusiRspBO deductionGrow(UmcTimingTaskMemRatingBusiReqBO umcTimingTaskMemRatingBusiReqBO) {
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u4f1a\u5458\u4e2d\u5fc3\u5b9a\u65f6\u4efb\u52a1\u8bc4\u7ea7\u524d\u6263\u51cf\u79ef\u5206\u5e76\u8bb0\u5f55\u65e5\u5fd7\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + umcTimingTaskMemRatingBusiReqBO.toString());
        }
        UmcTimingTaskMemRatingBusiRspBO rspBO = new UmcTimingTaskMemRatingBusiRspBO();
        OperRulePO operRulePO = this.qryOperRule();
        if (operRulePO == null) {
            rspBO.setRespCode("2025");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u7f16\u7801");
            return rspBO;
        }
        UmcRuleCalculateAtomRspBO ruleCalculateAtomRspBO = this.qryDeductionGrow(operRulePO.getRuleId());
        if (!"0000".equals(ruleCalculateAtomRspBO.getRespCode())) {
            rspBO.setRespCode(ruleCalculateAtomRspBO.getRespCode());
            rspBO.setRespDesc(ruleCalculateAtomRspBO.getRespDesc());
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)ruleCalculateAtomRspBO.getTargetValue())) {
            rspBO.setRespCode("2025");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6263\u51cf\u9ed8\u8ba4\u503c");
            return rspBO;
        }
        Long memId = umcTimingTaskMemRatingBusiReqBO.getMemId();
        Long growValue = Long.valueOf(ruleCalculateAtomRspBO.getTargetValue());
        UmcGrowValueDeductAtomRspBO growValueDeductAtomRspBO = this.deductGrown(memId, growValue);
        rspBO.setRespCode(growValueDeductAtomRspBO.getRespCode());
        rspBO.setRespDesc("\u8bc4\u7ea7\u79ef\u5206\u524d\u9ed8\u8ba4\u6263\u51cf\u6210\u957f\u503c\u6210\u529f");
        return rspBO;
    }

    private OperRulePO qryOperRule() {
        OperRulePO operRuleModel = new OperRulePO();
        operRuleModel.setOperCode(UmcEnumConstant.AddGrowOperCode.MEMBER_RATING_DEDUCTION_GROWN.getCode());
        operRuleModel.setRuleType(UmcCommConstant.RuleType.MEM_RATING);
        return this.operRuleMapper.getModelByCondition(operRuleModel);
    }

    private UmcRuleCalculateAtomRspBO qryDeductionGrow(Long ruleId) {
        UmcRuleCalculateAtomReqBO umcRuleCalculateAtomReqBO = new UmcRuleCalculateAtomReqBO();
        umcRuleCalculateAtomReqBO.setRuleId(ruleId);
        umcRuleCalculateAtomReqBO.setRuleType(UmcCommConstant.RuleType.MEM_RATING);
        return this.umcRuleCalculateAtomService.ruleCalculate(umcRuleCalculateAtomReqBO);
    }

    private UmcGrowValueDeductAtomRspBO deductGrown(Long memId, Long growValue) {
        UmcGrowValueDeductAtomReqBO umcGrowValueDeductAtomReqBO = new UmcGrowValueDeductAtomReqBO();
        umcGrowValueDeductAtomReqBO.setMemId(memId);
        umcGrowValueDeductAtomReqBO.setGrowValue(growValue);
        umcGrowValueDeductAtomReqBO.setOperCode(UmcEnumConstant.AddGrowOperCode.MEMBER_RATING_DEDUCTION_GROWN.getCode());
        umcGrowValueDeductAtomReqBO.setOperSystem("UMC");
        umcGrowValueDeductAtomReqBO.setOperResult("\u4f1a\u5458\u5b9a\u65f6\u8bc4\u7ea7\u524d\u9700\u8981\u5148\u9ed8\u8ba4\u6263\u51cf\u79ef\u5206");
        umcGrowValueDeductAtomReqBO.setOperDesc("\u4f1a\u5458\u5b9a\u65f6\u8bc4\u7ea7\u524d\u9700\u8981\u5148\u9ed8\u8ba4\u6263\u51cf\u79ef\u5206");
        return this.umcGrowValueDeductAtomService.deductGroupValue(umcGrowValueDeductAtomReqBO);
    }
}

