/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.tydic.umc.busi.UmcUpdateMemPwdBusiService;
import com.tydic.umc.busi.bo.UmcUpdateMemPwdBusiReqBO;
import com.tydic.umc.busi.bo.UmcUpdateMemPwdBusiRspBO;
import com.tydic.umc.dao.MemUserMapper;
import com.tydic.umc.dao.MemberMapper;
import com.tydic.umc.po.MemUserPO;
import com.tydic.umc.po.MemberPO;
import com.tydic.umc.util.PwdUtils;
import com.tydic.umc.util.UmcBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="umcUpdateMemPwdBusiService")
public class UmcUpdateMemPwdBusiServiceImpl
implements UmcUpdateMemPwdBusiService {
    @Autowired
    private MemUserMapper memUserMapper;
    @Autowired
    private MemberMapper memberMapper;

    public UmcUpdateMemPwdBusiRspBO updateMemPwd(UmcUpdateMemPwdBusiReqBO reqBO) {
        UmcUpdateMemPwdBusiRspBO rspBO = new UmcUpdateMemPwdBusiRspBO();
        ArrayList<Long> memIds = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)reqBO.getMemIds())) {
            memIds = this.getMemIdByUserId(reqBO.getUserIds());
        } else {
            for (Long memId : reqBO.getMemIds()) {
                memIds.add(memId);
            }
            this.checkMemId(memIds);
        }
        this.updatePwd(memIds, reqBO.getPassword());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<Long> getMemIdByUserId(List<Long> userIds) {
        MemUserPO memUserPO = new MemUserPO();
        memUserPO.setUserIds(userIds);
        List<MemUserPO> memUserPOS = this.memUserMapper.getList(memUserPO);
        if (memUserPOS.size() != userIds.size()) {
            throw new UmcBusinessException("6032", "\u6839\u636e\u7528\u6237ID\u67e5\u8be2\u4f1a\u5458ID\u4e3a\u7a7a");
        }
        ArrayList<Long> memIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(memUserPOS)) {
            for (MemUserPO po : memUserPOS) {
                memIds.add(po.getMemId());
            }
            return memIds;
        }
        throw new UmcBusinessException("6032", "\u6839\u636e\u7528\u6237ID\u67e5\u8be2\u4f1a\u5458ID\u4e3a\u7a7a");
    }

    private void updatePwd(List<Long> memIds, String pwd) {
        String encryptPwd = PwdUtils.getEncrypt(pwd);
        for (Long memId : memIds) {
            MemberPO memberPO = new MemberPO();
            memberPO.setMemId(memId);
            memberPO.setPasswd(encryptPwd);
            int updateValue = this.memberMapper.updateByCondition(memberPO);
            if (updateValue >= 1) continue;
            throw new UmcBusinessException("6032", "\u4f1a\u5458\u4fe1\u606f\u66f4\u65b0\u5bc6\u7801\u5931\u8d25\uff01");
        }
    }

    private void checkMemId(List<Long> memIds) {
        MemberPO memberPO = new MemberPO();
        memberPO.setMemIds(memIds);
        List<MemberPO> memberPOS = this.memberMapper.getListByMemIds(memberPO);
        if (CollectionUtils.isEmpty(memberPOS)) {
            throw new UmcBusinessException("6032", "\u4f1a\u5458ID\u4e0d\u5b58\u5728");
        }
        if (memberPOS.size() != memIds.size()) {
            throw new UmcBusinessException("6032", "\u4f1a\u5458ID\u4e0d\u5b58\u5728");
        }
    }
}

