/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.busi.impl;

import com.tydic.umc.busi.UmcVfCodeCheckBusiService;
import com.tydic.umc.busi.bo.UmcVfCodeCheckBusiReqBO;
import com.tydic.umc.busi.bo.UmcVfCodeCheckBusiRspBO;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.VfCodeMapper;
import com.tydic.umc.po.VfCodePO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcVFCodeCheckBusiService")
public class UmcVfCodeCheckBusiServiceImpl
implements UmcVfCodeCheckBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcVfCodeCheckBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private final int UPDATE_EXPIRED_STATE_OPERATION = 1;
    private final int UPDATE_ACCESS_STATE_OPERATION = 2;
    private VfCodeMapper vfCodeMapper;

    @Autowired
    public UmcVfCodeCheckBusiServiceImpl(VfCodeMapper vfCodeMapper) {
        this.vfCodeMapper = vfCodeMapper;
    }

    public UmcVfCodeCheckBusiRspBO checkVfCode(UmcVfCodeCheckBusiReqBO umcVfCodeCheckBusiReqBO) {
        boolean compareResult;
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u6267\u884c\u968f\u673a\u7801\u6821\u9a8c\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u4e3a\uff1a" + umcVfCodeCheckBusiReqBO.toString());
        }
        UmcVfCodeCheckBusiRspBO rspBO = new UmcVfCodeCheckBusiRspBO();
        VfCodePO vfCodeModel = new VfCodePO();
        vfCodeModel.setAccNbr(umcVfCodeCheckBusiReqBO.getRegMobile());
        vfCodeModel.setVfCode(umcVfCodeCheckBusiReqBO.getVFCode());
        VfCodePO vfCodePO = this.vfCodeMapper.getModelByCondition(vfCodeModel);
        if (vfCodePO == null) {
            rspBO.setRespCode("2002");
            rspBO.setRespDesc("\u65e0\u6548\u7684\u9a8c\u8bc1\u7801");
            return rspBO;
        }
        if (UmcEnumConstant.VfCodeState.AUTHENTICATED.getCode().equals(vfCodePO.getState())) {
            rspBO.setRespCode("2002");
            rspBO.setRespDesc("\u9a8c\u8bc1\u7801\u5df2\u9a8c\u8bc1");
            return rspBO;
        }
        if (UmcEnumConstant.VfCodeState.EXPIRED.getCode().equals(vfCodePO.getState())) {
            rspBO.setRespCode("2002");
            rspBO.setRespDesc("\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f");
            return rspBO;
        }
        Date sysCurrentTime = new Date();
        boolean bl = compareResult = sysCurrentTime.getTime() > vfCodePO.getExpTime().getTime();
        if (compareResult) {
            int updateResult = this.updateVfCode(vfCodePO, 1);
            rspBO.setRespCode("2002");
            if (updateResult < 1) {
                rspBO.setRespDesc("\u4fee\u6539\u9a8c\u8bc1\u7801\u72b6\u6001\u4e3a\u8fc7\u671f\u5931\u8d25");
            } else {
                rspBO.setRespDesc("\u9a8c\u8bc1\u7801\u5df2\u5931\u6548");
            }
            return rspBO;
        }
        int updateResult = this.updateVfCode(vfCodePO, 2);
        if (updateResult < 1) {
            rspBO.setRespCode("2002");
            rspBO.setRespDesc("\u4fee\u6539\u9a8c\u8bc1\u7801\u72b6\u6001\u4e3a\u901a\u8fc7\u5931\u8d25");
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u9a8c\u8bc1\u7801\u6821\u9a8c\u901a\u8fc7");
        }
        return rspBO;
    }

    private int updateVfCode(VfCodePO vfCodePO, int updateType) {
        switch (updateType) {
            case 1: {
                vfCodePO.setState(UmcEnumConstant.VfCodeState.EXPIRED.getCode());
                break;
            }
            case 2: {
                vfCodePO.setState(UmcEnumConstant.VfCodeState.AUTHENTICATED.getCode());
                vfCodePO.setVfTime(new Date());
                break;
            }
        }
        return this.vfCodeMapper.updateByCondition(vfCodePO);
    }
}

